/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file;

import com.tridium.history.db.BHistoryDbTable;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.file.HistoryFileOutput;
import com.tridium.history.file.fixed.BFixedLengthHistoryTable;
import com.tridium.history.file.recstore.BRecordStoreHistoryTable;
import com.tridium.history.io.FileRandomAccess;
import com.tridium.history.io.RandomAccess;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.io.RandomAccessFileInputStream;
import javax.baja.io.RandomAccessFileOutputStream;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public abstract class BFileHistoryTable
extends BHistoryDbTable {
    public static final Type TYPE = Sys.loadType(BFileHistoryTable.class);
    private static final BIcon icon = BIcon.std((String)"history.png");
    private static final int BYTES_PER_INTEGER = 4;
    private static final int MAGIC = -1593380578;
    public static final int VERSION_1 = 1;
    public static final int VERSION = 2;
    private static final int CONFIG_OFFSET = 12;
    private static final int DEFAULT_DATA_OFFSET = 1600;
    private File file;
    private boolean local = false;
    private RandomAccessFile access;
    private HistoryFileOutput output;
    private RandomAccess dataAccess;
    private int version = 2;
    private int dataOffset;
    private boolean resizing = false;
    private Queue appendQueue = new Queue();
    private boolean locked = false;
    private static final boolean isMigrationMode = Boolean.getBoolean("niagara.migration");
    private static final byte[] V1_HEADER = BFileHistoryTable.createHeaderArray(1);
    private static final byte[] V2_HEADER = BFileHistoryTable.createHeaderArray(2);
    private final byte[] header = new byte[V2_HEADER.length];
    private static final int MAGIC_IDX = 0;
    private static final int VERSION_IDX = 1;
    private static final int DATA_OFFSET_IDX = 2;
    private final byte[] intBuffer = new byte[4];

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BFileHistoryTable make(BHistoryDatabase db, BHistoryConfig config, boolean local) throws HistoryException {
        BFileHistoryTable result = BFileHistoryTable.makeDefault(config.makeRecord());
        result.setConfig(config);
        result.setDatabase(db);
        result.setConfig(config);
        result.local = local;
        return result;
    }

    public static BFileHistoryTable makeTest(BHistoryConfig config, RandomAccess dataAccess) {
        BFileHistoryTable result = BFileHistoryTable.makeDefault(config.makeRecord());
        result.setConfig(config);
        result.dataAccess = dataAccess;
        return result;
    }

    private static BFileHistoryTable makeDefault(BHistoryRecord rec) {
        if (rec.isFixedSize()) {
            return new BFixedLengthHistoryTable();
        }
        return new BRecordStoreHistoryTable();
    }

    public BFileHistoryTable() {
    }

    public BFileHistoryTable(BHistoryConfig config) {
        super(config);
    }

    public static BFileHistoryTable createFromFile(BHistoryDatabase db, File file, boolean local) throws IOException, HistoryException {
        int version;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " does not exist.");
        }
        BHistoryConfig config = null;
        byte[] localHeader = new byte[V2_HEADER.length];
        try (DataInputStream in = new DataInputStream(new FileInputStream(file));){
            BHistoryId id;
            in.readFully(localHeader, 0, localHeader.length);
            BFileHistoryTable.checkMagic(BFileHistoryTable.getHeader(0, localHeader), file);
            version = BFileHistoryTable.getHeader(1, localHeader);
            BFileHistoryTable.checkVersion(version, file);
            config = (BHistoryConfig)new ValueDocDecoder((InputStream)in).decodeDocument();
            if (local && !((BLocalHistoryDatabase)db).isLocal(id = config.getId())) {
                id = BHistoryId.make(((BLocalHistoryDatabase)db).getLocalStationName(), id.getHistoryName());
                config.setId(id);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        BFileHistoryTable table = BFileHistoryTable.make(db, config, local);
        for (int i = 0; i < localHeader.length; ++i) {
            table.header[i] = localHeader[i];
        }
        table.version = version;
        table.file = file;
        return table;
    }

    public static void setId(File file, BHistoryId newId) {
        RandomAccessFile access = null;
        try {
            access = new RandomAccessFile(file, "rws");
            RandomAccessFileInputStream in = new RandomAccessFileInputStream(access, 12L);
            BHistoryConfig config = (BHistoryConfig)new ValueDocDecoder((InputStream)in).decodeDocument();
            config.setId(newId);
            RandomAccessFileOutputStream out = new RandomAccessFileOutputStream(access, 12L);
            ValueDocEncoder enc = new ValueDocEncoder((OutputStream)out);
            enc.encodeDocument((BValue)config);
            out.flush();
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
        finally {
            if (access != null) {
                try {
                    access.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public File[] getFiles() {
        return new File[]{this.getFile()};
    }

    protected File getFile() {
        if (this.file == null) {
            BLocalHistoryDatabase db = (BLocalHistoryDatabase)this.getDatabase();
            if (db == null) {
                throw new IllegalStateException("Cannot open a history without a database.");
            }
            this.file = db.getFile(this.getConfig().getId(), true);
        }
        return this.file;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public final int getRecordCount() {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetRecordCount();
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract int doGetRecordCount() throws IOException;

    @Override
    public final BAbsTime getFirstTimestamp() {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetFirstTimestamp();
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract BAbsTime doGetFirstTimestamp() throws IOException;

    @Override
    public BAbsTime getLastTimestamp() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetLastTimestamp();
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract BAbsTime doGetLastTimestamp() throws IOException;

    @Override
    public BHistoryRecord getLastRecord() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            try {
                return this.doGetLastRecord();
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract BHistoryRecord doGetLastRecord() throws IOException;

    public static void checkMagic(int magic, File f) throws IOException {
        if (magic != -1593380578) {
            StringBuffer s = new StringBuffer(128);
            s.append("File is not a valid history file. ");
            s.append("Bad magic number (0x");
            s.append(Integer.toString(magic, 16).toUpperCase());
            s.append(") for ").append(f.getName());
            throw new IOException(s.toString());
        }
    }

    public static void checkVersion(int version, File f) throws IOException {
        if (version > 2) {
            StringBuffer s = new StringBuffer(128);
            s.append("File format version is not supported by this release. ");
            s.append("The maximum version supported by this release is ");
            s.append(2);
            s.append(" but the format version for this file is ").append(version);
            s.append('.');
            throw new IOException(s.toString());
        }
    }

    @Override
    protected final void doOpen() throws HistoryException {
        try {
            AccessController.doPrivileged(new DoOpenPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw (HistoryException)((Object)e.getException());
        }
    }

    protected abstract void createDataSection() throws IOException;

    protected abstract void openDataSection() throws IOException;

    @Override
    protected void doFlush() throws HistoryException {
        try {
            this.flushData();
        }
        catch (IOException e) {
            throw new HistoryException(e);
        }
    }

    protected abstract boolean flushData() throws IOException;

    @Override
    protected void doClose() {
        try {
            this.closeData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.access.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dataAccess = null;
        this.access = null;
        this.output = null;
        BLocalHistoryDatabase db = (BLocalHistoryDatabase)this.getDatabase();
        if (db != null) {
            db.tableClosed(this);
        }
    }

    protected abstract void closeData();

    @Override
    protected boolean doDelete() {
        if (!this.deleteData()) {
            return false;
        }
        try {
            if (this.access != null) {
                this.access.close();
                this.dataAccess = null;
                this.access = null;
                this.output = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return AccessController.doPrivileged(() -> {
            if (this.file != null) {
                return this.file.delete();
            }
            return true;
        });
    }

    protected abstract boolean deleteData();

    @Override
    public void doRenameHistory(String historyName) {
        BHistoryId.validateName(historyName);
        String initName = this.getConfig().getId().getHistoryName();
        if (initName != null && initName.equals(historyName)) {
            return;
        }
        BHistoryId newId = BHistoryId.make(this.getConfig().getId().getDeviceName(), historyName);
        try (HistorySpaceConnection conn = this.getDatabase().getConnection(null);){
            if (conn.exists(newId)) {
                throw new HistoryException(historyName + " already exists.  Cannot rename history.");
            }
            BHistoryConfig newConfig = (BHistoryConfig)this.getConfig().newCopy(true);
            newConfig.setId(newId);
            conn.createHistory(newConfig);
            BIHistory newHistory = conn.getHistory(newId);
            Cursor<BHistoryRecord> keep = this.timeQuery(null, null, false);
            while (keep.next()) {
                conn.append(newHistory, (BIHistoryRecordSet)keep.get());
            }
        }
        if (!this.delete()) {
            throw new HistoryException("Cannot delete original history.");
        }
    }

    @Override
    protected void doResize(BCapacity capacity, BFullPolicy fullPolicy) {
        AccessController.doPrivileged(new ResizePrivilegedAction(capacity, fullPolicy));
    }

    @Override
    public void doClear() {
        this.doDelete();
        this.doOpen();
    }

    @Override
    public void doClear(BAbsTime before) {
        if (before == null || before.isNull()) {
            return;
        }
        File oldFile = this.getFile();
        try {
            AccessController.doPrivileged(() -> {
                File newFile;
                if (!oldFile.exists()) {
                    this.doClear();
                    return null;
                }
                String newFilePath = oldFile.getAbsolutePath();
                if (newFilePath.endsWith(".hdb")) {
                    newFilePath = newFilePath.substring(0, newFilePath.length() - 3) + "tmp";
                }
                if ((newFile = new File(newFilePath)).exists()) {
                    newFile.delete();
                }
                BHistoryConfig newConfig = (BHistoryConfig)this.getConfig().newCopy(true);
                BFileHistoryTable newTable = BFileHistoryTable.make(null, newConfig, this.local);
                newTable.file = newFile;
                newTable.open();
                Cursor<BHistoryRecord> keep = this.timeQuery(before, null, false);
                while (keep.next()) {
                    newTable.append((BIHistoryRecordSet)keep.get());
                }
                newTable.close();
                try {
                    String chkFilePath = oldFile.getAbsolutePath().substring(0, newFilePath.length() - 3) + "chk";
                    File check = new File(chkFilePath);
                    if (check.exists()) {
                        check.delete();
                    }
                    if (!newFile.renameTo(check)) {
                        throw new HistoryException("Cannot rename new history: " + newFile.getAbsolutePath() + " to " + check.getAbsolutePath());
                    }
                    newFile = check;
                    if (!this.doDelete()) {
                        throw new HistoryException("Cannot delete original history.");
                    }
                }
                catch (HistoryException he) {
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                    throw he;
                }
                if (!newFile.renameTo(oldFile)) {
                    throw new HistoryException("Cannot rename new history: " + newFile.getAbsolutePath() + " to " + oldFile.getAbsolutePath());
                }
                this.doOpen();
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof RuntimeException) {
                throw (RuntimeException)pae.getException();
            }
            throw new HistoryException(pae.getException());
        }
    }

    @Override
    public final Cursor<BHistoryRecord> timeQuery(BAbsTime startTime, BAbsTime endTime, boolean descending) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            this.open();
            try {
                return this.doTimeQuery(startTime, endTime, descending);
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract Cursor<BHistoryRecord> doTimeQuery(BAbsTime var1, BAbsTime var2, boolean var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock() {
        Object object = this.tableLock;
        synchronized (object) {
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock() {
        Object object = this.tableLock;
        synchronized (object) {
            this.locked = false;
            while (!this.appendQueue.isEmpty()) {
                BIHistoryRecordSet recSet = (BIHistoryRecordSet)this.appendQueue.dequeue();
                this.append(recSet);
            }
        }
    }

    @Override
    public final int append(BIHistoryRecordSet newRecords) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.locked) {
                this.appendQueue.enqueue((Object)newRecords);
                return newRecords != null ? newRecords.getRecordCount() : 0;
            }
            this.checkDeleted();
            this.open();
            try {
                int count = newRecords.getRecordCount();
                if (count == 0) {
                    return 0;
                }
                int added = 0;
                BAbsTime lastTimestamp = this.getLastTimestamp();
                for (int i = 0; i < count; ++i) {
                    BHistoryRecord rec = newRecords.getRecord(i);
                    BAbsTime recTimestamp = rec.getTimestamp();
                    if (lastTimestamp != null && !lastTimestamp.isNull() && recTimestamp.isBefore(lastTimestamp)) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Unable to append out-of-order record to ").append(this.getConfig().getId().toString());
                        sb.append(": ").append(rec.toString());
                        System.out.println(sb.toString());
                        continue;
                    }
                    if (!this.doAppend(rec)) {
                        return added;
                    }
                    ++added;
                    lastTimestamp = recTimestamp;
                }
                return added;
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract boolean doAppend(BHistoryRecord var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(BHistoryRecord oldRecord, BHistoryRecord newRecord) throws HistoryException, UnsupportedOperationException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            this.open();
            try {
                this.doUpdate(oldRecord, newRecord);
            }
            catch (IOException e) {
                throw new HistoryException(e);
            }
        }
    }

    protected abstract void doUpdate(BHistoryRecord var1, BHistoryRecord var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfig() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            RandomAccessFileInputStream in = new RandomAccessFileInputStream(this.access, 12L);
            try {
                BHistoryConfig config = (BHistoryConfig)new ValueDocDecoder((InputStream)in).decodeDocument();
                BHistoryId inId = config.getId();
                if (this.local && !inId.getDeviceName().equals(Sys.getStation().getStationName())) {
                    inId = BHistoryId.make(Sys.getStation().getStationName(), inId.getHistoryName());
                    config.setId(inId);
                }
                this.setConfig(config);
            }
            catch (Exception e) {
                throw new HistoryException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfig() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            boolean wasOpen = this.isOpen();
            if (!wasOpen) {
                this.open();
            }
            try {
                ByteArrayOutputStream temp = new ByteArrayOutputStream();
                ValueDocEncoder tempEnc = new ValueDocEncoder((OutputStream)temp);
                tempEnc.encodeDocument((BValue)this.getConfig());
                int numBytes = temp.size();
                if (numBytes > this.dataOffset - 12) {
                    this.doResize(this.getConfig().getCapacity(), this.getConfig().getFullPolicy());
                } else {
                    RandomAccessFileOutputStream out = new RandomAccessFileOutputStream(this.access, 12L);
                    ValueDocEncoder enc = new ValueDocEncoder((OutputStream)out);
                    enc.encodeDocument((BValue)this.getConfig());
                    out.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!wasOpen) {
                this.close();
            }
        }
    }

    @Override
    public void doConfigChanged() {
        if (this.isOpen() && !this.resizing) {
            try {
                this.writeConfig();
            }
            catch (Exception e) {
                BHistoryService.logger.log(Level.SEVERE, "Unable to save configuration for " + (Object)((Object)this.getConfig().getId()), e);
            }
        }
    }

    public RandomAccess getAccess() {
        if (this.dataAccess == null) {
            this.dataAccess = new FileRandomAccess(this.access, this.dataOffset);
        }
        return this.dataAccess;
    }

    public void seek(long pos) throws IOException {
        this.access.seek((long)this.dataOffset + pos);
    }

    public long pos() throws IOException {
        return this.access.getFilePointer() - (long)this.dataOffset;
    }

    public long length() throws IOException {
        return this.access.length() - (long)this.dataOffset;
    }

    public void setLength(long newLength) throws IOException {
        this.access.setLength(newLength + (long)this.dataOffset);
    }

    public DataOutput out() {
        return this.output;
    }

    public DataInput in() {
        return this.access;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void dump(PrintWriter out) throws IOException {
        out.println("version    : " + this.version);
        out.println("dataOffset   : " + this.dataOffset);
        out.flush();
    }

    public abstract int getPageWriteCount();

    public abstract int getHeaderWriteCount();

    public abstract int getTotalRecordAppends();

    private static int getHeader(int field, byte[] localHeader) {
        int idx = field * 4;
        return (0xFF & localHeader[idx]) << 24 | (0xFF & localHeader[idx + 1]) << 16 | (0xFF & localHeader[idx + 2]) << 8 | 0xFF & localHeader[idx + 3];
    }

    private void writeInt(DataOutput out, int value) throws IOException {
        this.intBuffer[0] = (byte)(0xFF & value >> 24);
        this.intBuffer[1] = (byte)(0xFF & value >> 16);
        this.intBuffer[2] = (byte)(0xFF & value >> 8);
        this.intBuffer[3] = (byte)(0xFF & value);
        out.write(this.intBuffer, 0, this.intBuffer.length);
    }

    private static byte[] createHeaderArray(int version) {
        return ByteBuffer.allocate(12).putInt(-1593380578).putInt(version).putInt(1600).array();
    }

    private class ResizePrivilegedAction
    implements PrivilegedAction<Object> {
        BCapacity capacity;
        BFullPolicy fullPolicy;

        private ResizePrivilegedAction(BCapacity capacity, BFullPolicy fullPolicy) {
            this.capacity = capacity;
            this.fullPolicy = fullPolicy;
        }

        @Override
        public Object run() {
            File newFile;
            File oldFile = BFileHistoryTable.this.getFile();
            String newFilePath = oldFile.getAbsolutePath();
            if (newFilePath.endsWith(".hdb")) {
                newFilePath = newFilePath.substring(0, newFilePath.length() - 3) + "tmp";
            }
            if ((newFile = new File(newFilePath)).exists()) {
                newFile.delete();
            }
            BHistoryConfig newConfig = (BHistoryConfig)BFileHistoryTable.this.getConfig().newCopy(true);
            newConfig.setCapacity(this.capacity);
            newConfig.setFullPolicy(this.fullPolicy);
            BFileHistoryTable newTable = BFileHistoryTable.make(null, newConfig, BFileHistoryTable.this.local);
            newTable.file = newFile;
            newTable.open();
            Cursor<BHistoryRecord> recs = BFileHistoryTable.this.timeQuery(null, null, false);
            while (recs.next()) {
                newTable.append((BIHistoryRecordSet)recs.get());
            }
            newTable.close();
            try {
                String chkFilePath = oldFile.getAbsolutePath().substring(0, newFilePath.length() - 3) + "chk";
                File check = new File(chkFilePath);
                if (check.exists()) {
                    check.delete();
                }
                if (!newFile.renameTo(check)) {
                    throw new HistoryException("Cannot rename new history: " + newFile.getAbsolutePath());
                }
                newFile = check;
                if (!BFileHistoryTable.this.doDelete()) {
                    throw new HistoryException("Cannot delete original history.");
                }
            }
            catch (HistoryException he) {
                if (newFile.exists()) {
                    newFile.delete();
                }
                throw he;
            }
            if (!newFile.renameTo(oldFile)) {
                throw new HistoryException("Cannot rename new history: " + newFile.getAbsolutePath());
            }
            BFileHistoryTable.this.resizing = true;
            BFileHistoryTable.this.setConfig(newConfig);
            BFileHistoryTable.this.resizing = false;
            BFileHistoryTable.this.doOpen();
            return null;
        }
    }

    private class DoOpenPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private DoOpenPrivilegedAction() {
        }

        @Override
        public Object run() throws HistoryException {
            boolean createNew;
            File file = BFileHistoryTable.this.getFile();
            boolean bl = createNew = !file.exists();
            if (BFileHistoryTable.this.access != null) {
                throw new IllegalStateException("File is already open.");
            }
            try {
                String openMode = isMigrationMode ? "rw" : "rws";
                BFileHistoryTable.this.access = new RandomAccessFile(file, openMode);
                BFileHistoryTable.this.output = new HistoryFileOutput(BFileHistoryTable.this.access, this);
                if (createNew) {
                    BFileHistoryTable.this.dataOffset = 1600;
                    if (BFileHistoryTable.this.version == 1) {
                        BFileHistoryTable.this.access.write(V1_HEADER);
                    } else {
                        BFileHistoryTable.this.access.write(V2_HEADER);
                    }
                    RandomAccessFileOutputStream out = new RandomAccessFileOutputStream(BFileHistoryTable.this.access, 12L);
                    ValueDocEncoder enc = new ValueDocEncoder((OutputStream)out);
                    enc.encodeDocument((BValue)BFileHistoryTable.this.getConfig());
                    out.flush();
                    long configEnd = BFileHistoryTable.this.access.getFilePointer();
                    if (configEnd > (long)BFileHistoryTable.this.dataOffset) {
                        while (configEnd > (long)BFileHistoryTable.this.dataOffset) {
                            BFileHistoryTable.this.dataOffset = BFileHistoryTable.this.dataOffset * 2;
                        }
                        BFileHistoryTable.this.access.seek(8L);
                        BFileHistoryTable.this.writeInt(BFileHistoryTable.this.access, BFileHistoryTable.this.dataOffset);
                    }
                    if (configEnd < (long)BFileHistoryTable.this.dataOffset - 1L) {
                        BFileHistoryTable.this.access.seek(BFileHistoryTable.this.dataOffset - 1);
                        BFileHistoryTable.this.access.write(0);
                    }
                    BFileHistoryTable.this.access.seek(BFileHistoryTable.this.dataOffset);
                    BFileHistoryTable.this.createDataSection();
                    BFileHistoryTable.this.openDataSection();
                } else {
                    BFileHistoryTable.this.access.readFully(BFileHistoryTable.this.header, 0, BFileHistoryTable.this.header.length);
                    BFileHistoryTable.checkMagic(BFileHistoryTable.getHeader(0, BFileHistoryTable.this.header), file);
                    BFileHistoryTable.checkVersion(BFileHistoryTable.getHeader(1, BFileHistoryTable.this.header), file);
                    BFileHistoryTable.this.dataOffset = BFileHistoryTable.getHeader(2, BFileHistoryTable.this.header);
                    BFileHistoryTable.this.openDataSection();
                }
            }
            catch (IOException e) {
                if (BFileHistoryTable.this.access != null) {
                    try {
                        BFileHistoryTable.this.access.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new HistoryException(e);
            }
            return null;
        }
    }
}

