/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.history.db.BLocalDbHistory;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.sys.metrics.Metrics;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.collection.AbstractCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Cursor;

public class ConfigIndex {
    private static Comparator<BHistoryDevice> devNameComparator = new DeviceNameComparator();
    private static Comparator<BIHistory> histNameComparator = new HistoryNameComparator();
    private final BLocalHistoryDatabase db;
    private final HashMap<String, HashMap<BHistoryId, BHistoryConfig>> byDevice = new HashMap(101);
    private static final HashMap<BHistoryId, BHistoryConfig> INIT = new HashMap(0);
    private static final HashMap<BHistoryId, BHistoryConfig> INIT_IN_PROGRESS = new HashMap(0);
    private static final BIHistory[] NONE = new BIHistory[0];

    public ConfigIndex(BLocalHistoryDatabase db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        BHistoryDevice[] devices = this.db.listDevicesFromFile();
        int count = devices.length;
        HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap = this.byDevice;
        synchronized (hashMap) {
            for (int i = 0; i < count; ++i) {
                this.byDevice.put(devices[i].getDeviceName(), INIT);
            }
        }
    }

    public Cursor<BHistoryConfig> cursor() {
        return new AllCursor(this.db, this);
    }

    public Cursor<BHistoryConfig> cursor(BHistoryDevice device) {
        return new DeviceCursor(this, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryConfig get(BHistoryId id) {
        HashMap<BHistoryId, BHistoryConfig> device = this.lookupDevice(id.getDeviceName(), false);
        if (device == null) {
            return null;
        }
        HashMap<BHistoryId, BHistoryConfig> hashMap = device;
        synchronized (hashMap) {
            return device.get((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deviceExists(String deviceName) {
        HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap = this.byDevice;
        synchronized (hashMap) {
            return this.byDevice.get(deviceName) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryDevice[] listDevices(boolean sort) {
        String[] deviceNames = null;
        HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap = this.byDevice;
        synchronized (hashMap) {
            deviceNames = this.byDevice.keySet().toArray(new String[this.byDevice.size()]);
        }
        int count = deviceNames.length;
        BHistoryDevice[] devices = new BHistoryDevice[count];
        for (int i = 0; i < count; ++i) {
            devices[i] = new BHistoryDevice(this.db, deviceNames[i]);
        }
        if (sort) {
            SortUtil.sort((Object[])devices, (Object[])devices, devNameComparator);
        }
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDevice(String deviceName) {
        HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap = this.byDevice;
        synchronized (hashMap) {
            if (this.deviceExists(deviceName)) {
                this.byDevice.remove(deviceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIHistory[] listHistories(BHistoryDevice device, boolean sort) {
        HashMap<BHistoryId, BHistoryConfig> map = this.lookupDevice(device.getDeviceName(), false);
        if (map == null) {
            return NONE;
        }
        BHistoryConfig[] configs = null;
        HashMap<BHistoryId, BHistoryConfig> hashMap = map;
        synchronized (hashMap) {
            configs = map.values().toArray(new BHistoryConfig[map.size()]);
        }
        int count = configs.length;
        Object[] histories = new BIHistory[count];
        for (int i = 0; i < count; ++i) {
            histories[i] = new BLocalDbHistory(this.db, configs[i].getId());
        }
        if (sort) {
            SortUtil.sort((Object[])histories, (Object[])histories, histNameComparator);
        }
        return histories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BHistoryId id, BHistoryConfig cfg) {
        HashMap<BHistoryId, BHistoryConfig> device = this.lookupDevice(id.getDeviceName(), true);
        if (device != null) {
            HashMap<BHistoryId, BHistoryConfig> hashMap = device;
            synchronized (hashMap) {
                device.put(id, cfg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(BHistoryId id, BHistoryConfig cfg) {
        HashMap<BHistoryId, BHistoryConfig> device = this.lookupDevice(id.getDeviceName(), true);
        if (device != null) {
            HashMap<BHistoryId, BHistoryConfig> hashMap = device;
            synchronized (hashMap) {
                device.put(id, cfg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BHistoryId id) {
        HashMap<BHistoryId, BHistoryConfig> device = this.lookupDevice(id.getDeviceName(), false);
        if (device != null) {
            HashMap<BHistoryId, BHistoryConfig> hashMap = device;
            synchronized (hashMap) {
                device.remove((Object)id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap<BHistoryId, BHistoryConfig> lookupDevice(String deviceName, boolean create) {
        HashMap<BHistoryId, BHistoryConfig> byId;
        HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap = this.byDevice;
        synchronized (hashMap) {
            HashMap<BHistoryId, BHistoryConfig> o = this.byDevice.get(deviceName);
            if (o == null && !create) {
                return null;
            }
            if (o == null || o == INIT) {
                this.byDevice.put(deviceName, INIT_IN_PROGRESS);
                byId = new HashMap<BHistoryId, BHistoryConfig>();
            } else {
                if (o != INIT_IN_PROGRESS) return o;
                while (o == INIT_IN_PROGRESS) {
                    try {
                        this.byDevice.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    o = this.byDevice.get(deviceName);
                }
                if (o != INIT) return o;
                this.byDevice.put(deviceName, INIT_IN_PROGRESS);
                byId = new HashMap();
            }
        }
        boolean notified = false;
        try {
            BIHistory[] histories;
            for (BIHistory history : histories = this.db.listHistoriesFromFile(new BHistoryDevice(this.db, deviceName))) {
                try {
                    BHistoryConfig cfg = history.getConfig();
                    byId.put(history.getId(), cfg);
                }
                catch (Exception e) {
                    BHistoryDatabase.log.log(Level.SEVERE, "Cannot get configuration for history: " + (Object)((Object)history.getId()), e);
                }
            }
            HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap2 = this.byDevice;
            synchronized (hashMap2) {
                HashMap<BHistoryId, BHistoryConfig> o = this.byDevice.get(deviceName);
                if (o == null || o == INIT_IN_PROGRESS) {
                    Iterator it = byId.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        BHistoryId entryId = (BHistoryId)((Object)entry.getKey());
                        if (Metrics.incrementHistory((String)entryId.getDeviceName(), (String)entryId.getHistoryName())) continue;
                        BHistoryDatabase.log.severe("Exceeded Global Capacity history limit.");
                        it.remove();
                    }
                    this.byDevice.put(deviceName, byId);
                    this.byDevice.notifyAll();
                    notified = true;
                } else {
                    byId = o;
                }
                return byId;
            }
        }
        finally {
            if (!notified) {
                HashMap<String, HashMap<BHistoryId, BHistoryConfig>> hashMap3 = this.byDevice;
                synchronized (hashMap3) {
                    if (this.byDevice.get(deviceName) == INIT_IN_PROGRESS) {
                        this.byDevice.put(deviceName, INIT);
                    }
                    this.byDevice.notifyAll();
                }
            }
        }
    }

    private static class HistoryNameComparator
    implements Comparator<BIHistory> {
        private HistoryNameComparator() {
        }

        @Override
        public int compare(BIHistory o1, BIHistory o2) {
            return o1.getNavDisplayName(null).compareTo(o2.getNavDisplayName(null));
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof HistoryNameComparator;
        }
    }

    private static class DeviceNameComparator
    implements Comparator<BHistoryDevice> {
        private DeviceNameComparator() {
        }

        @Override
        public int compare(BHistoryDevice dev1, BHistoryDevice dev2) {
            return dev1.getDeviceName().compareTo(dev2.getDeviceName());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof DeviceNameComparator;
        }
    }

    private static class AllCursor
    extends AbstractCursor<BHistoryConfig> {
        private final BHistorySpace space;
        private final ConfigIndex index;
        private boolean done;
        private BHistoryConfig cfg;
        private Iterator<BHistoryConfig> current;
        private BHistoryDevice[] devices;
        private int deviceIndex;

        public AllCursor(BHistorySpace space, ConfigIndex index) {
            this.space = space;
            this.index = index;
        }

        protected BHistoryConfig doGet() {
            if (this.done) {
                throw new IllegalStateException("No more elements.");
            }
            if (this.current == null) {
                throw new IllegalStateException("get() before next()");
            }
            return this.cfg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean advanceCursor() {
            HashMap hashMap;
            HashMap map;
            if (this.done) {
                return false;
            }
            if (this.current == null) {
                this.devices = this.space.listDevices();
                if (this.devices.length == 0) {
                    return this.toEnd();
                }
                this.deviceIndex = 0;
                map = this.index.lookupDevice(this.devices[this.deviceIndex].getDeviceName(), false);
                if (map == null) {
                    this.current = new HashMap().values().iterator();
                } else {
                    hashMap = map;
                    synchronized (hashMap) {
                        this.current = map.values().iterator();
                    }
                }
            }
            while (!this.current.hasNext()) {
                ++this.deviceIndex;
                if (this.deviceIndex == this.devices.length) {
                    return this.toEnd();
                }
                map = this.index.lookupDevice(this.devices[this.deviceIndex].getDeviceName(), false);
                if (map == null) {
                    this.current = new HashMap().values().iterator();
                    continue;
                }
                hashMap = map;
                synchronized (hashMap) {
                    this.current = map.values().iterator();
                }
            }
            this.cfg = this.current.next();
            return true;
        }

        private boolean toEnd() {
            this.done = true;
            this.devices = null;
            return false;
        }
    }

    private static class DeviceCursor
    extends AbstractCursor<BHistoryConfig> {
        private final ConfigIndex index;
        private final BHistoryDevice device;
        private BHistoryConfig cfg;
        private Iterator<BHistoryConfig> i;
        private boolean done;

        public DeviceCursor(ConfigIndex index, BHistoryDevice device) {
            this.index = index;
            this.device = device;
        }

        protected BHistoryConfig doGet() {
            if (this.done) {
                throw new IllegalStateException("No more elements.");
            }
            if (this.i == null) {
                throw new IllegalStateException("get() before next()");
            }
            return this.cfg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean advanceCursor() {
            if (this.done) {
                return false;
            }
            if (this.i == null) {
                HashMap map = this.index.lookupDevice(this.device.getDeviceName(), false);
                if (map == null) {
                    this.done = true;
                    return false;
                }
                HashMap hashMap = map;
                synchronized (hashMap) {
                    this.i = map.values().iterator();
                }
            }
            if (!this.i.hasNext()) {
                this.done = true;
                return false;
            }
            this.cfg = this.i.next();
            return true;
        }
    }
}

