/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.history.HistoryTableCursor;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.db.BLocalDbHistory;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BHistorySummary;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryQueryResult
extends BObject
implements BITable<BHistoryRecord> {
    public static final Type TYPE = Sys.loadType(BHistoryQueryResult.class);
    private final BLocalDbHistory history;
    private final BqlQuery query;
    private ColumnList columns;
    private final IFilter filter;
    private BFacets tableFacets;

    public Type getType() {
        return TYPE;
    }

    public BHistoryQueryResult(BLocalDbHistory history, BqlQuery query) {
        this(history, query, null);
    }

    private BHistoryQueryResult(BLocalDbHistory history, BqlQuery query, IFilter filter) {
        this.history = history;
        this.query = query;
        this.filter = filter;
        this.tableFacets = history.getTableFacets();
        try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(null);){
            RangeSet range;
            SelectQuery select;
            BTimeZone tz;
            BHistorySummary summary = conn.getSummary(history);
            BAbsTime first = summary.getFirstTimestamp();
            BAbsTime last = summary.getLastTimestamp();
            if (first != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"firstTimestamp", (BIDataValue)first));
            }
            if (last != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"lastTimestamp", (BIDataValue)last));
            }
            if ((tz = history.getConfig().getTimeZone()) != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"TimeZone", (BIDataValue)tz));
            }
            boolean addedTimeFacets = false;
            if (query instanceof SelectQuery && (select = (SelectQuery)query).hasPredicate() && !(range = select.getRange("timestamp", BAbsTime.TYPE, false)).isAll()) {
                range.sort();
                Range min = range.getRange(0);
                Range max = range.getRange(range.getCount() - 1);
                if (min.min != null) {
                    this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)((BIDataValue)min.min.as(BAbsTime.class))));
                }
                if (max.max != null) {
                    this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"endTime", (BIDataValue)((BIDataValue)max.max.as(BAbsTime.class))));
                }
                addedTimeFacets = true;
            }
            if (!addedTimeFacets) {
                if (first != null) {
                    this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)first));
                }
                if (last != null) {
                    this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"endTime", (BIDataValue)last));
                }
            }
        }
    }

    public TableCursor<BHistoryRecord> cursor() {
        return new HistoryTableCursor(this, this.history.doBqlQuery(this.query), this.filter);
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryColumns.getColumns(this.history.getConfig());
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }
}

