/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.db.TableHandle;
import java.util.HashMap;
import javax.baja.bql.BqlQuery;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.InvalidHistoryIdException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.spy.Spy;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BHistoryDbTable
extends BObject {
    public static final Type TYPE = Sys.loadType(BHistoryDbTable.class);
    private long lastAccess = 0L;
    private boolean open = false;
    private boolean deleted = false;
    private BHistoryDatabase db;
    private TableHandle handle;
    protected Object tableLock = new Object();
    private BHistoryConfig config;
    private HashMap<BComponent, Integer> historySources = null;
    private static final boolean isMigrationMode = Boolean.getBoolean("niagara.migration");

    public Type getType() {
        return TYPE;
    }

    public BHistoryDbTable() {
    }

    public BHistoryDbTable(BHistoryConfig config) {
        this.setConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableHandle getTableHandle() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryConfig getConfig() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(BHistoryConfig config) {
        Object object = this.tableLock;
        synchronized (object) {
            this.config = config;
            this.configChanged();
        }
    }

    public Object getTableLock() {
        return this.tableLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkDeleted();
            this.updateLastAccess();
            if (this.open) {
                return;
            }
            if (!this.getConfig().getId().isValid()) {
                throw new InvalidHistoryIdException(this.getConfig().getId());
            }
            if (this.handle != null) {
                this.handle.unbind();
                this.handle = null;
            }
            this.handle = new TableHandle(this, this.tableLock);
            this.doOpen();
            this.open = true;
            BCapacity capacity = this.getConfig().getCapacity();
            if (capacity.isByRecordCount() && this.getRecordCount() > capacity.getMaxRecords()) {
                BFullPolicy fullPolicy = this.getConfig().getFullPolicy();
                this.resize(capacity, fullPolicy);
            }
        }
    }

    protected abstract void doOpen() throws HistoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    this.doClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.handle.unbind();
                this.handle = null;
                this.open = false;
                this.lastAccess = 0L;
                this.unsubscribeAllHistorySources();
            }
        }
    }

    protected abstract void doClose();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.updateLastAccess();
            this.doFlush();
        }
    }

    protected abstract void doFlush() throws HistoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkDeleted() throws HistoryDeletedException {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.deleted) {
                throw new HistoryDeletedException(this.config.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete() {
        Object object = this.tableLock;
        synchronized (object) {
            this.close();
            if (this.doDelete()) {
                this.deleted = true;
                return true;
            }
            return false;
        }
    }

    protected abstract boolean doDelete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renameHistory(String historyName) {
        Object object = this.tableLock;
        synchronized (object) {
            this.doRenameHistory(historyName);
        }
    }

    protected abstract void doRenameHistory(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resize(BCapacity capacity, BFullPolicy fullPolicy) {
        Object object = this.tableLock;
        synchronized (object) {
            this.doResize(capacity, fullPolicy);
        }
    }

    protected abstract void doResize(BCapacity var1, BFullPolicy var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.tableLock;
        synchronized (object) {
            this.open();
            this.doClear();
        }
    }

    protected abstract void doClear();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(BAbsTime before) {
        Object object = this.tableLock;
        synchronized (object) {
            this.open();
            this.doClear(before);
        }
    }

    protected abstract void doClear(BAbsTime var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastAccess() {
        Object object = this.tableLock;
        synchronized (object) {
            if (Thread.currentThread() != BLocalHistoryDatabase.WARM_UP_THREAD && !isMigrationMode) {
                this.lastAccess = Clock.ticks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkLastAccess(long time, long relMillis) {
        Object object = this.tableLock;
        synchronized (object) {
            long staleTime = time - relMillis;
            if (staleTime < 0L) {
                return true;
            }
            return this.lastAccess >= staleTime;
        }
    }

    public abstract int getRecordCount() throws HistoryException, UnsupportedOperationException;

    public abstract BAbsTime getFirstTimestamp() throws HistoryException;

    public abstract BAbsTime getLastTimestamp() throws HistoryException;

    public abstract BHistoryRecord getLastRecord() throws HistoryException;

    public Cursor<BHistoryRecord> scan(boolean descending) throws HistoryException {
        return this.timeQuery(null, null, descending);
    }

    public abstract Cursor<BHistoryRecord> timeQuery(BAbsTime var1, BAbsTime var2, boolean var3) throws HistoryException;

    public Cursor<BHistoryRecord> bqlQuery(BqlQuery query) throws HistoryException {
        SelectQuery select = (SelectQuery)query;
        RangeSet range = null;
        boolean descending = false;
        if (select.getSelect().hasOrdering()) {
            BOrderByColumn[] orders = select.getSelect().getOrdering().getOrderByColumns();
            for (int i = 0; i < orders.length; ++i) {
                BFieldExpression expression;
                if (!(orders[i].getColumnExpression() instanceof BFieldExpression) || !(expression = (BFieldExpression)orders[i].getColumnExpression()).getField().equals(BHistoryRecord.timestamp.getName())) continue;
                descending = !orders[i].isAscending();
            }
        }
        if (!select.hasPredicate()) {
            return this.scan(descending);
        }
        range = select.getRange("timestamp", BAbsTime.TYPE, false);
        if (range.isAll()) {
            return this.scan(descending);
        }
        range.sort();
        Range min = range.getRange(0);
        Range max = range.getRange(range.getCount() - 1);
        return this.timeQuery((BAbsTime)min.min, (BAbsTime)max.max, descending);
    }

    public abstract int append(BIHistoryRecordSet var1) throws HistoryException;

    public abstract void update(BHistoryRecord var1, BHistoryRecord var2) throws HistoryException, UnsupportedOperationException;

    protected final void configChanged() {
        this.doConfigChanged();
    }

    protected void doConfigChanged() {
    }

    public BHistoryDatabase getDatabase() {
        return this.db;
    }

    public void setDatabase(BHistoryDatabase db) {
        this.db = db;
    }

    public void inspect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateHistorySubscriptionCount(BComponent source, int change) {
        HashMap<BComponent, Integer> map = null;
        Object object = this.tableLock;
        synchronized (object) {
            if (!this.open) {
                return 0;
            }
            if (change == 0) {
                return this.historySources != null ? this.historySources.size() : 0;
            }
            if (this.historySources == null) {
                this.historySources = new HashMap();
            }
            map = this.historySources;
        }
        object = map;
        synchronized (object) {
            if (this.open) {
                if (source instanceof BIPollableHistorySource) {
                    ((BIPollableHistorySource)source).updateHistorySubscriptionCount(change);
                }
                BHistoryDbTable.updateHistorySources(map, source, change);
            }
        }
        object = this.tableLock;
        synchronized (object) {
            if (this.historySources != null && this.historySources.isEmpty()) {
                this.historySources = null;
            }
            return this.historySources != null ? this.historySources.size() : 0;
        }
    }

    private static void updateHistorySources(HashMap<BComponent, Integer> map, BComponent historySource, int change) {
        Integer oldCount = map.get(historySource);
        int newCount = change;
        if (oldCount != null && (newCount = oldCount + newCount) <= 0) {
            map.remove(historySource);
            return;
        }
        map.put(historySource, new Integer(newCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllHistorySources() {
        if (this.historySources == null) {
            return;
        }
        HashMap<BComponent, Integer> hashMap = this.historySources;
        synchronized (hashMap) {
            for (BComponent src : this.historySources.keySet()) {
                try {
                    Integer count = this.historySources.get(src);
                    if (!(src instanceof BIPollableHistorySource)) continue;
                    ((BIPollableHistorySource)src).updateHistorySubscriptionCount(-1 * count);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.historySources.clear();
        }
        this.historySources = null;
    }

    public abstract Spy getTableSpy();
}

