/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.collection;

import com.tridium.history.collection.ColumnSpec;
import com.tridium.history.collection.HistoryColumn;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.io.RecordInput;
import com.tridium.history.util.BICombinableHistory;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRecordTable
extends BObject
implements BICombinableHistory<BHistoryRecord, BRecordTable> {
    private static final ColumnSpec[] EMPTY_SPEC = new ColumnSpec[0];
    public static final Type TYPE = Sys.loadType(BRecordTable.class);
    private final Type recType;
    private BFacets tableFacets;
    private ColumnList columns;
    private final ArrayList<BHistoryRecord> recList;

    public Type getType() {
        return TYPE;
    }

    public BRecordTable(Type recType) {
        this.recType = recType;
        this.columns = HistoryColumns.getColumns((BStruct)recType.getInstance(), EMPTY_SPEC);
        this.recList = new ArrayList(32);
    }

    public BRecordTable(RecordInput in) throws IOException {
        BHistoryRecord rec;
        in.setUniqueRecords(true);
        this.recType = in.getObjectType();
        BHistoryRecord proto = (BHistoryRecord)this.recType.getInstance();
        this.tableFacets = in.getTableFacets();
        this.columns = HistoryColumns.getColumns(proto, in.getColumnSpecs());
        this.recList = new ArrayList(128);
        while ((rec = (BHistoryRecord)in.read()) != null) {
            this.recList.add(rec);
        }
    }

    public Type getObjectType() throws IOException {
        return this.recType;
    }

    public void add(BHistoryRecord rec) {
        if (rec.getType() != this.recType) {
            throw new IllegalArgumentException("Type mismatch: " + rec.getType() + " != " + this.recType);
        }
        this.recList.add(rec);
    }

    public void insert(int index, BHistoryRecord rec) {
        if (rec.getType() != this.recType) {
            throw new IllegalArgumentException("Type mismatch: " + rec.getType() + " != " + this.recType);
        }
        this.recList.add(index, rec);
    }

    public BHistoryRecord get(int index) {
        return this.recList.get(index);
    }

    public BHistoryRecord remove(int index) {
        return this.recList.remove(index);
    }

    public BHistoryRecord[] removeAll() {
        BHistoryRecord[] records = this.recList.toArray(new BHistoryRecord[this.recList.size()]);
        this.recList.clear();
        return records;
    }

    public TableCursor<BHistoryRecord> cursor() {
        return new RecordCursor(this.recList);
    }

    public ColumnList getColumns() {
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public BRecordTable combine(BRecordTable other) {
        while (!other.isEmpty()) {
            this.add(other.remove(0));
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.recList.isEmpty();
    }

    @Override
    public BAbsTime lastTimestamp() {
        return this.recList.isEmpty() ? BAbsTime.NULL : this.recList.get(this.recList.size() - 1).getTimestamp();
    }

    private class RecordCursor
    extends AbstractTableCursor<BHistoryRecord> {
        final ArrayList<BHistoryRecord> recList;
        int index;

        public RecordCursor(ArrayList<BHistoryRecord> recList) {
            super((BITable)BRecordTable.this);
            this.index = -1;
            this.recList = recList;
        }

        protected boolean advanceCursor() {
            int count = this.recList.size();
            if (this.index == count) {
                return false;
            }
            ++this.index;
            return this.index != count;
        }

        public Row<BHistoryRecord> row() {
            return new AbstractRow<BHistoryRecord>(this.getTable(), this.recList.get(this.index)){

                public BIObject cell(Column column) {
                    return ((HistoryColumn)column).get((BObject)this.rowObject());
                }

                public int getCellFlags(Column column) {
                    return ((HistoryColumn)column).getFlags((BObject)this.rowObject());
                }

                public BFacets getCellFacets(Column column) {
                    return ((HistoryColumn)column).getFacets((BObject)this.rowObject());
                }

                public Row<BHistoryRecord> safeCopy() {
                    return this;
                }
            };
        }
    }
}

