/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.audit;

import com.tridium.history.audit.BAbstractAuditRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.ITruncatable;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(type="String", name="userName", defaultValue=""), @NiagaraProperty(type="String", name="message", defaultValue="")})
public class BSecurityAuditRecord
extends BAbstractAuditRecord
implements ITruncatable {
    public static final Property userName = BSecurityAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property message = BSecurityAuditRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BSecurityAuditRecord.class);

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    public String getMessage() {
        return this.getString(message);
    }

    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSecurityAuditRecord() {
    }

    public BSecurityAuditRecord(BAbsTime timestamp, String operation, String userName, String message) {
        super(timestamp);
        this.setOperation(operation);
        this.setUserName(userName);
        this.setMessage(message);
    }

    public static BSecurityAuditRecord fromEvent(SecurityAuditEvent event) {
        return new BSecurityAuditRecord(event.getTimestamp(), event.getOperation(), event.getUserName(), event.getMessage());
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    protected void doRead(DataInput in) throws IOException {
        this.setOperation(in.readUTF());
        this.setUserName(in.readUTF());
        this.setMessage(in.readUTF());
    }

    @Override
    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getOperation());
        out.writeUTF(this.getUserName());
        out.writeUTF(this.getMessage());
    }

    @Override
    public boolean truncate(int maxBytes) {
        ByteBuffer timestampBytes = new ByteBuffer(16);
        try {
            if (this.version == 1) {
                this.getTimestamp().encode((DataOutput)timestampBytes);
            } else {
                this.getTimestamp().encode48((DataOutput)timestampBytes);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        int fixedBytes = timestampBytes.getLength() + ByteBuffer.utfEncodedSize((String)this.getOperation()) + ByteBuffer.utfEncodedSize((String)this.getUserName());
        if (fixedBytes > maxBytes - 2) {
            return false;
        }
        String messageString = this.getMessage();
        int messageBytes = ByteBuffer.utfEncodedSize((String)messageString);
        if (fixedBytes + messageBytes <= maxBytes) {
            return true;
        }
        int messageLen = maxBytes - fixedBytes - 2;
        messageBytes = ByteBuffer.utfEncodedSize((String)messageString.substring(0, messageLen));
        while (fixedBytes + messageBytes > maxBytes) {
            messageBytes -= ByteBuffer.utfEncodedSize((char)messageString.charAt(--messageLen));
        }
        this.setMessage(messageString.substring(0, messageLen));
        return true;
    }
}

