/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.audit;

import com.tridium.history.audit.BAbstractAuditRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.ITruncatable;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.security.AuditEvent;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="target", type="String", defaultValue=""), @NiagaraProperty(name="slotName", type="String", defaultValue=""), @NiagaraProperty(name="oldValue", type="String", defaultValue=""), @NiagaraProperty(name="value", type="String", defaultValue=""), @NiagaraProperty(name="userName", type="String", defaultValue="")})
public class BAuditRecord
extends BAbstractAuditRecord
implements ITruncatable {
    public static final Property target = BAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property slotName = BAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property oldValue = BAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property value = BAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property userName = BAuditRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BAuditRecord.class);

    public String getTarget() {
        return this.getString(target);
    }

    public void setTarget(String v) {
        this.setString(target, v, null);
    }

    public String getSlotName() {
        return this.getString(slotName);
    }

    public void setSlotName(String v) {
        this.setString(slotName, v, null);
    }

    public String getOldValue() {
        return this.getString(oldValue);
    }

    public void setOldValue(String v) {
        this.setString(oldValue, v, null);
    }

    public String getValue() {
        return this.getString(value);
    }

    public void setValue(String v) {
        this.setString(value, v, null);
    }

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BAuditRecord() {
    }

    public BAuditRecord(BAbsTime timestamp, String operation, String source, String slotName, String oldValue, String newValue, String userName) {
        super(timestamp);
        this.setOperation(operation);
        this.setTarget(source);
        this.setSlotName(this.s(slotName));
        this.setOldValue(this.s(oldValue));
        this.setValue(this.s(newValue));
        this.setUserName(this.s(userName));
    }

    public static BAuditRecord fromEvent(AuditEvent event) {
        return new BAuditRecord(event.getTimestamp(), event.getOperation(), event.getTarget(), event.getSlotName(), event.getOldValue(), event.getValue(), event.getUserName());
    }

    public BAuditRecord setFromEvent(AuditEvent event) {
        this.setTimestamp(event.getTimestamp());
        this.setOperation(event.getOperation());
        this.setTarget(event.getTarget());
        this.setSlotName(this.s(event.getSlotName()));
        this.setOldValue(this.s(event.getOldValue()));
        this.setValue(this.s(event.getValue()));
        this.setUserName(this.s(event.getUserName()));
        return this;
    }

    private String s(String sIn) {
        return sIn == null ? "" : sIn;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    protected void doRead(DataInput in) throws IOException {
        this.setOperation(in.readUTF());
        this.setTarget(in.readUTF());
        this.setSlotName(in.readUTF());
        this.setOldValue(in.readUTF());
        this.setValue(in.readUTF());
        this.setUserName(in.readUTF());
    }

    @Override
    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getOperation());
        out.writeUTF(this.getTarget());
        out.writeUTF(this.getSlotName());
        out.writeUTF(this.getOldValue());
        out.writeUTF(this.getValue());
        out.writeUTF(this.getUserName());
    }

    @Override
    public String toString(Context ctx) {
        StringBuffer s = new StringBuffer(32);
        s.append(super.toString(ctx));
        s.append('[').append(this.getUserName()).append("] ");
        s.append(operation);
        if (this.getSlotName().length() > 0) {
            s.append(";slotName=" + this.getSlotName());
        }
        if (this.getOldValue().length() > 0) {
            s.append(";oldValue=" + this.getOldValue());
        }
        if (this.getValue().length() > 0) {
            s.append(";value=" + this.getValue());
        }
        return s.toString();
    }

    @Override
    public boolean truncate(int maxBytes) {
        boolean truncated = false;
        ByteBuffer timestampBytes = new ByteBuffer(16);
        try {
            if (this.version == 1) {
                this.getTimestamp().encode((DataOutput)timestampBytes);
            } else {
                this.getTimestamp().encode48((DataOutput)timestampBytes);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        int fixedBytes = timestampBytes.getLength() + ByteBuffer.utfEncodedSize((String)this.getOperation()) + ByteBuffer.utfEncodedSize((String)this.getTarget()) + ByteBuffer.utfEncodedSize((String)this.getSlotName()) + ByteBuffer.utfEncodedSize((String)this.getUserName());
        if (fixedBytes > maxBytes - 4) {
            return false;
        }
        String valueString = this.getValue();
        int valueBytes = ByteBuffer.utfEncodedSize((String)valueString);
        int valueLen = valueString.length();
        String oldValueString = this.getOldValue();
        int oldValueBytes = ByteBuffer.utfEncodedSize((String)oldValueString);
        int oldValueLen = oldValueString.length();
        while (fixedBytes + valueBytes + oldValueBytes > maxBytes) {
            if (valueBytes > 2) {
                truncated = true;
                valueBytes -= ByteBuffer.utfEncodedSize((char)valueString.charAt(--valueLen));
                continue;
            }
            truncated = true;
            oldValueBytes -= ByteBuffer.utfEncodedSize((char)oldValueString.charAt(--oldValueLen));
        }
        if (truncated) {
            this.setValue(valueString.substring(0, valueLen));
            this.setOldValue(oldValueString.substring(0, oldValueLen));
        }
        return true;
    }
}

