/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.audit;

import com.tridium.history.audit.BAbstractAuditRecord;
import com.tridium.util.HistoryCategoryUtil;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig()"), @NiagaraProperty(name="lastRecord", type="BHistoryRecord", defaultValue="new BStringTrendRecord()", flags=3)})
public abstract class BAbstractAuditHistorySource
extends BComponent
implements BIHistorySource {
    public static final Property enabled = BAbstractAuditHistorySource.newProperty((int)0, (boolean)true, null);
    public static final Property historyConfig = BAbstractAuditHistorySource.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    public static final Property lastRecord = BAbstractAuditHistorySource.newProperty((int)3, (BValue)new BStringTrendRecord(), null);
    public static final Type TYPE = Sys.loadType(BAbstractAuditHistorySource.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/histories.png");
    private static final Lexicon lex = Lexicon.make((String)"history");
    protected BIHistory history;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    public void setLastRecord(BHistoryRecord v) {
        this.set(lastRecord, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected abstract BTypeSpec getRecordType();

    protected abstract BHistoryId getHistoryId();

    protected abstract void auditStarted();

    protected abstract void auditStopped();

    public synchronized void started() {
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        BHistoryConfig config = this.getHistoryConfig();
        config.setRecordType(this.getRecordType());
        config.setId(this.getHistoryId());
        if (this.getEnabled()) {
            this.startAudit();
        }
    }

    private BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getHandleOrd());
    }

    private void initHistory() {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            this.initHistory(conn);
        }
    }

    private void initHistory(HistoryDatabaseConnection conn) {
        Optional<BCategoryMask> mask;
        BHistoryConfig config = this.getHistoryConfig();
        config.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        config.setTimeZone(BTimeZone.getLocal());
        BHistoryId id = config.getId();
        boolean created = false;
        if (!conn.exists(id)) {
            conn.createHistory(config);
            created = true;
        } else {
            conn.reconfigureHistory(config);
        }
        this.history = conn.getHistory(id);
        if (created && (mask = this.getHistoryCategoryMask(conn, this.history)).isPresent()) {
            BCategoryService categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
            BOrd historyOrd = HistoryCategoryUtil.convertToShorthand((BOrd)this.history.getOrdInSession(), (String)Sys.getStation().getStationName());
            categoryService.setOrdMap(categoryService.getOrdMap().setCategoryMask(historyOrd, mask.get()));
        }
        try {
            BHistoryRecord lastRec = conn.getLastRecord(this.history);
            if (lastRec != null) {
                this.setLastRecord(lastRec);
            }
        }
        catch (Exception e) {
            BHistoryService.logger.log(Level.SEVERE, "Could not initialize 'Last Record' property for AuditHistoryService.", e);
        }
    }

    protected Optional<BCategoryMask> getHistoryCategoryMask(HistoryDatabaseConnection conn, BIHistory history) {
        return Optional.empty();
    }

    private synchronized void startAudit() {
        try {
            this.initHistory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.auditStarted();
    }

    protected synchronized void stopAudit() {
        this.auditStopped();
        this.history = null;
    }

    public void audit(BAbstractAuditRecord rec) {
        boolean appended = false;
        boolean outOfOrder = false;
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
            outOfOrder = this.outOfOrderCheck(rec);
            conn.append(this.history, rec);
            appended = true;
        }
        catch (HistoryException e) {
            if (e instanceof HistoryDeletedException || e instanceof HistoryNotFoundException) {
                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryDatabase db = service.getDatabase();
                try (HistoryDatabaseConnection conn2 = db.getDbConnection(null);){
                    this.initHistory(conn2);
                    if (!outOfOrder) {
                        this.outOfOrderCheck(rec);
                    }
                    conn2.append(this.history, rec);
                    appended = true;
                }
            }
            throw e;
        }
        if (appended) {
            this.setLastRecord(rec);
        }
    }

    @Override
    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        if (config != this.getHistoryConfig()) {
            return;
        }
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            conn.reconfigureHistory(this.getHistoryConfig());
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.startAudit();
            } else {
                this.stopAudit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean outOfOrderCheck(BAbstractAuditRecord auditRec) {
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
            BAbsTime lastTimestamp = conn.getLastTimestamp(this.history);
            BAbsTime recTimestamp = auditRec.getTimestamp();
            if (lastTimestamp == null) return false;
            if (lastTimestamp.isNull()) return false;
            if (!recTimestamp.isBefore(lastTimestamp)) return false;
            StringBuilder sb = new StringBuilder();
            sb.append(auditRec.getOperation()).append(' ');
            sb.append(lex.getText("log.append.outOfOrder", new Object[]{this.getTimestampString(recTimestamp)}));
            auditRec.setOperation(sb.toString());
            auditRec.setTimestamp(lastTimestamp);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            if (!BHistoryService.logger.isLoggable(Level.FINE)) return false;
            BHistoryService.logger.log(Level.FINE, "Error performing out-of-order check.", t);
        }
        return false;
    }

    protected String getTimestampString(BAbsTime timestamp) {
        BHistoryConfig config = this.getHistoryConfig();
        BFacets facets = null;
        try {
            facets = (BFacets)config.get("timestampFacets");
            BTimeZone timeZone = config.getTimeZone();
            facets = facets != null ? BFacets.make((BFacets)facets, (String)"TimeZone", (BIDataValue)timeZone) : BFacets.make((String)"TimeZone", (BIDataValue)timeZone);
            facets = BFacets.make((BFacets)facets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
        }
        catch (Exception e) {
            BHistoryService.logger.log(Level.WARNING, "Error creating timestamp facets.", e);
        }
        return timestamp.toString((Context)facets);
    }

    public BIcon getIcon() {
        return icon;
    }
}

