/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.BHistory;
import com.tridium.history.HistoryTableCursor;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.util.BICombinableHistory;
import javax.baja.bql.RemoteQueryable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BHistorySummary;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryTimeQuery
extends BObject
implements BICombinableHistory<BHistoryRecord, BHistoryTimeQuery>,
RemoteQueryable {
    public static final Type TYPE = Sys.loadType(BHistoryTimeQuery.class);
    private final BHistory history;
    private final BAbsTime startTime;
    private BAbsTime endTime;
    private ColumnList columns;
    private final IFilter filter;
    private BFacets tableFacets;
    private final boolean descending;

    public Type getType() {
        return TYPE;
    }

    public BHistoryTimeQuery(BHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending) {
        this(history, startTime, endTime, null, descending);
    }

    private BHistoryTimeQuery(BHistory history, BAbsTime startTime, BAbsTime endTime, IFilter filter, boolean descending) {
        this.history = history;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
        this.descending = descending;
        BHistoryId id = history.getId();
        this.tableFacets = BFacets.make((String)"historyId", (BIDataValue)BString.make((String)id.encodeToString()), (String)"tableName", (BIDataValue)BString.make((String)history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX)));
        if (startTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)startTime));
        }
        if (endTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"endTime", (BIDataValue)endTime));
        }
        try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(null);){
            BTimeZone tz;
            BHistorySummary summary = conn.getSummary(history);
            BAbsTime first = summary.getFirstTimestamp();
            BAbsTime last = summary.getLastTimestamp();
            if (first != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"firstTimestamp", (BIDataValue)first));
            }
            if (last != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"lastTimestamp", (BIDataValue)last));
            }
            if ((tz = history.getConfig().getTimeZone()) != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"TimeZone", (BIDataValue)tz));
            }
        }
    }

    public TableCursor<BHistoryRecord> cursor() {
        return new HistoryTableCursor(this, this.history.timeQueryCursor(this.startTime, this.endTime, this.descending), this.filter);
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryColumns.getColumns(this.history.getConfig());
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public synchronized BHistoryTimeQuery combine(BHistoryTimeQuery query) {
        if (!this.history.equals(query.history)) {
            throw new IllegalStateException("not combining from same history?");
        }
        this.endTime = query.endTime;
        this.tableFacets = query.tableFacets;
        if (this.startTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)this.startTime));
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        try (TableCursor<BHistoryRecord> c = this.cursor();){
            boolean bl = c.next();
            return bl;
        }
    }

    @Override
    public BAbsTime lastTimestamp() {
        BAbsTime lastTimestamp = BAbsTime.NULL;
        try (TableCursor<BHistoryRecord> cursor = this.cursor();){
            while (cursor.next()) {
                lastTimestamp = ((BHistoryRecord)cursor.get()).getTimestamp();
            }
        }
        return lastTimestamp;
    }

    public BObject bqlQuery(BOrd ord) {
        if (this.history instanceof BFoxHistory) {
            BFoxHistorySpace historySpace = (BFoxHistorySpace)this.history.getSpace();
            return historySpace.bqlQuery(ord);
        }
        throw new UnresolvedException("Query is not remote.");
    }

    public BHistory getHistory() {
        return this.history;
    }

    public BAbsTime getStartTime() {
        return this.startTime;
    }

    public BAbsTime getEndTime() {
        return this.endTime;
    }

    public IFilter getFilter() {
        return this.filter;
    }
}

