/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.BHistoryMirror;
import com.tridium.history.BIHistoryNavSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUnrestrictedFolder;

public class BHistoryShortcuts
extends BUnrestrictedFolder
implements NavListener {
    public static final Property historyQueryPredicate = BHistoryShortcuts.newProperty((int)0, (String)"", null);
    public static final Property onlyDisplayParentDeviceHistories = BHistoryShortcuts.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BHistoryShortcuts.class);
    private static final BIcon icon = BIcon.std((String)"historyShortcutFolder.png");
    private static final Comparator<BIHistory> histNameComparator = new HistoryNameComparator();
    private static final BTypeSpec DEVICE_TYPE = BTypeSpec.make((String)"driver:Device");
    protected Work work = null;

    public String getHistoryQueryPredicate() {
        return this.getString(historyQueryPredicate);
    }

    public void setHistoryQueryPredicate(String v) {
        this.setString(historyQueryPredicate, v, null);
    }

    public boolean getOnlyDisplayParentDeviceHistories() {
        return this.getBoolean(onlyDisplayParentDeviceHistories);
    }

    public void setOnlyDisplayParentDeviceHistories(boolean v) {
        this.setBoolean(onlyDisplayParentDeviceHistories, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getHistoryDeviceName() {
        BValue val = this.get("historyDeviceName");
        if (val instanceof BString && !val.equals((Object)BString.DEFAULT)) {
            return val.toString();
        }
        Type deviceType = DEVICE_TYPE.getResolvedType();
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getType().is(deviceType)) continue;
            return parent.getName();
        }
        return null;
    }

    public BHistorySpace getHistorySpace() {
        try {
            BOrd ord = BOrd.make((String)"history:");
            return (BHistorySpace)ord.get((BObject)this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getQueryPredicate() {
        return this.getHistoryQueryPredicate();
    }

    public boolean hasNavChildren() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BINavNode getNavChild(String name) {
        BHistorySpace space = this.getHistorySpace();
        try (HistorySpaceConnection conn = space.getConnection(null);){
            if (space == null) return super.getNavChild(name);
            BHistoryId id = BHistoryId.make(name);
            boolean exists = conn.exists(id);
            if (!exists) return super.getNavChild(name);
            BHistoryMirror bHistoryMirror = new BHistoryMirror(conn.getHistory(id), (BINavNode)this);
            return bHistoryMirror;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getNavChild(name);
    }

    public BINavNode resolveNavChild(String name) {
        BINavNode child = this.getNavChild(name);
        if (child == null) {
            throw new UnresolvedException(name);
        }
        return child;
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] compChildren;
        block50: {
            compChildren = super.getNavChildren();
            int appendLen = compChildren != null ? compChildren.length : 0;
            BHistorySpace space = this.getHistorySpace();
            if (space != null) {
                boolean predicateExists;
                space.fw(9903, (Object)this, null, null, null);
                if (!this.isSubscribed()) {
                    this.loadSlots();
                    this.lease();
                }
                String devName = this.getOnlyDisplayParentDeviceHistories() ? this.getHistoryDeviceName() : null;
                boolean devNameFilter = devName != null;
                String predicate = this.getQueryPredicate();
                boolean bl = predicateExists = predicate != null && predicate.length() > 0;
                if (predicateExists && devNameFilter) {
                    predicate = predicate.trim();
                    String upperCasePredicate = predicate.toUpperCase();
                    StringBuffer sb = new StringBuffer();
                    if (upperCasePredicate.startsWith("WHERE ")) {
                        sb.append(predicate.substring(0, 6));
                        sb.append("id.deviceName='").append(devName).append("'");
                        if (predicate.length() > 6) {
                            sb.append(" and ").append(predicate.substring(6));
                        }
                    } else {
                        int idx = upperCasePredicate.indexOf(" WHERE ");
                        if (idx >= 0) {
                            sb.append(predicate.substring(0, idx + 7));
                            sb.append("id.deviceName='").append(devName).append("'");
                            if (predicate.length() > idx + 7) {
                                sb.append(" and ").append(predicate.substring(idx + 7));
                            }
                        } else {
                            sb.append("where id.deviceName='").append(devName).append("' ");
                            sb.append(predicate);
                        }
                    }
                    predicate = sb.toString();
                }
                if (predicateExists) {
                    StringBuffer s = new StringBuffer();
                    s.append("history:|bql:select id from sys.histories");
                    s.append(" ").append(predicate);
                    BOrd bqlOrd = BOrd.make((String)s.toString());
                    BITable table = (BITable)bqlOrd.get((BObject)this);
                    try (TableCursor cursor = table.cursor();
                         HistorySpaceConnection conn = space.getConnection(null);){
                        if (cursor.next()) {
                            ArrayList<Object> children = new ArrayList<Object>();
                            for (BINavNode n : compChildren) {
                                children.add(n);
                            }
                            Column idCol = table.getColumns().get("id");
                            do {
                                BHistoryId id = BHistoryId.make(cursor.cell(idCol).toString());
                                children.add(new BHistoryMirror(conn.getHistory(id), (BINavNode)this, devNameFilter));
                            } while (cursor.next());
                            BINavNode[] bINavNodeArray = children.toArray(new BINavNode[children.size()]);
                            return bINavNodeArray;
                        }
                        break block50;
                    }
                }
                if (devNameFilter) {
                    if (space.deviceExists(devName)) {
                        int i;
                        BHistoryDevice dev = space.getDevice(devName);
                        Object[] histories = space.listHistories(dev);
                        SortUtil.sort((Object[])histories, (Object[])histories, histNameComparator);
                        int len = histories.length;
                        BINavNode[] children = new BINavNode[len + appendLen];
                        for (i = 0; i < appendLen; ++i) {
                            children[i] = compChildren[i];
                        }
                        for (i = 0; i < len; ++i) {
                            children[i + appendLen] = new BHistoryMirror((BIHistory)histories[i], (BINavNode)this, devNameFilter);
                        }
                        return children;
                    }
                } else {
                    int i;
                    ArrayList<BIHistory> arr = new ArrayList<BIHistory>();
                    BHistoryDevice[] devices = space.listDevices();
                    for (int i2 = 0; i2 < devices.length; ++i2) {
                        arr.addAll(Arrays.asList(space.listHistories(devices[i2])));
                    }
                    Object[] histories = arr.toArray(new BIHistory[arr.size()]);
                    SortUtil.sort((Object[])histories, (Object[])histories, histNameComparator);
                    int len = histories.length;
                    BINavNode[] children = new BINavNode[len + appendLen];
                    for (i = 0; i < appendLen; ++i) {
                        children[i] = compChildren[i];
                    }
                    for (i = 0; i < len; ++i) {
                        children[i + appendLen] = new BHistoryMirror((BIHistory)histories[i], (BINavNode)this, devNameFilter);
                    }
                    return children;
                }
            }
        }
        return compChildren;
    }

    public void addNavChild(BINavNode child) {
        throw new UnsupportedOperationException();
    }

    public void removeNavChild(BINavNode child) {
        throw new UnsupportedOperationException();
    }

    public void navEvent(NavEvent event) {
        String filterDevName;
        BOrd parentOrd = event.getParentOrd();
        OrdQuery[] list = parentOrd.parse();
        OrdQuery leaf = list[list.length - 1];
        if (!(leaf instanceof HistoryQuery)) {
            return;
        }
        HistoryQuery query = (HistoryQuery)leaf;
        if (!query.isDeviceQuery()) {
            return;
        }
        String devName = query.getDeviceName();
        String string = filterDevName = this.getOnlyDisplayParentDeviceHistories() ? this.getHistoryDeviceName() : null;
        if (filterDevName != null && !filterDevName.equals(devName)) {
            return;
        }
        BIHistoryNavSupport support = BIHistoryNavSupport.getHistoryNavSupport();
        if (support != null) {
            if (this.work == null) {
                this.work = new Work(support.makeNavTreeWork((BINavNode)this));
            }
            if (!this.work.running) {
                support.runNavTreeWork(this.work);
            }
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.add("workbench:NavContainerView");
        return agents;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (!this.isRunning()) {
            BIHistoryNavSupport support;
            boolean refresh = false;
            switch (x) {
                case 2: {
                    Slot slot = (Slot)a;
                    refresh = b == Context.commit && (slot.equals((Object)historyQueryPredicate) || slot.equals((Object)onlyDisplayParentDeviceHistories) || slot.getName().equals("historyDeviceName"));
                    break;
                }
                case 3: {
                    Slot slot = (Slot)a;
                    refresh = b == Context.commit && slot.getName().equals("historyDeviceName");
                    break;
                }
                case 4: {
                    Slot slot = (Slot)a;
                    refresh = c == Context.commit && slot.getName().equals("historyDeviceName");
                    break;
                }
                case 5: {
                    Slot slot = (Slot)a;
                    String oldName = (String)b;
                    boolean bl = refresh = c == Context.commit && (slot.getName().equals("historyDeviceName") || oldName.equals("historyDeviceName"));
                }
            }
            if (refresh && (support = BIHistoryNavSupport.getHistoryNavSupport()) != null) {
                if (this.work == null) {
                    this.work = new Work(support.makeNavTreeWork((BINavNode)this));
                }
                if (!this.work.running) {
                    support.runNavTreeWork(this.work);
                }
            }
        }
        return super.fw(x, a, b, c, d);
    }

    protected static class Work
    implements Runnable {
        public boolean running = false;
        Runnable work;

        public Work(Runnable work) {
            this.work = work;
        }

        @Override
        public void run() {
            try {
                this.running = true;
                this.work.run();
            }
            finally {
                this.running = false;
            }
        }
    }

    private static class HistoryNameComparator
    implements Comparator<BIHistory> {
        private HistoryNameComparator() {
        }

        @Override
        public int compare(BIHistory h1, BIHistory h2) {
            return h1.getNavDisplayName(null).compareTo(h2.getNavDisplayName(null));
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof HistoryNameComparator;
        }
    }
}

