/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.BHistory;
import com.tridium.history.DeltaCursor;
import com.tridium.history.HistoryTableCursor;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.util.BICombinableHistory;
import javax.baja.bql.RemoteQueryable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryDeltaQuery
extends BObject
implements BICombinableHistory<BHistoryRecord, BHistoryDeltaQuery>,
RemoteQueryable {
    public static final Type TYPE = Sys.loadType(BHistoryDeltaQuery.class);
    private final BIHistory history;
    private final BAbsTime startTime;
    private BAbsTime endTime;
    private ColumnList columns;
    private final IFilter filter;
    private BFacets tableFacets;

    public Type getType() {
        return TYPE;
    }

    public BHistoryDeltaQuery(BIHistory history, BAbsTime startTime, BAbsTime endTime) {
        this(history, startTime, endTime, null);
    }

    public BHistoryDeltaQuery(BIHistory history, BAbsTime startTime, BAbsTime endTime, IFilter filter) {
        this.history = history;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
        BHistoryId id = history.getId();
        this.tableFacets = BFacets.make((String)"historyId", (BIDataValue)BString.make((String)id.encodeToString()), (String)"tableName", (BIDataValue)BString.make((String)history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX)));
        if (startTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)startTime));
        }
        if (endTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"endTime", (BIDataValue)endTime));
        }
        try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(null);){
            BTimeZone tz;
            BHistorySummary summary = conn.getSummary(history);
            BAbsTime first = summary.getFirstTimestamp();
            BAbsTime last = summary.getLastTimestamp();
            if (first != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"firstTimestamp", (BIDataValue)first));
            }
            if (last != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"lastTimestamp", (BIDataValue)last));
            }
            if ((tz = history.getConfig().getTimeZone()) != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"TimeZone", (BIDataValue)tz));
            }
        }
    }

    public TableCursor<BHistoryRecord> cursor() {
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(null);){
            BITable<BHistoryRecord> collection = conn.timeQuery(this.history, this.startTime, this.endTime);
            BRolloverValue minValue = null;
            Property minProp = this.history.getConfig().loadSlots().getProperty("minRolloverValue");
            if (minProp != null) {
                minValue = (BRolloverValue)this.history.getConfig().get(minProp);
            }
            BRolloverValue maxValue = null;
            Property maxProp = this.history.getConfig().loadSlots().getProperty("maxRolloverValue");
            if (maxProp != null) {
                maxValue = (BRolloverValue)this.history.getConfig().get(maxProp);
            }
            BNumericTrendRecord referenceRecord = BHistoryDeltaQuery.getReferenceRecord(this.history, this.startTime);
            HistoryTableCursor historyTableCursor = new HistoryTableCursor(this, (Cursor<BHistoryRecord>)new DeltaCursor((Cursor<BHistoryRecord>)collection.cursor(), minValue, maxValue, referenceRecord), this.filter);
            return historyTableCursor;
        }
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryColumns.getColumns(this.history.getConfig());
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public synchronized BHistoryDeltaQuery combine(BHistoryDeltaQuery query) {
        if (!this.history.equals(query.history)) {
            throw new IllegalStateException("not combining from same history?");
        }
        this.endTime = query.endTime;
        this.tableFacets = query.tableFacets;
        if (this.startTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)this.startTime));
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        try (TableCursor<BHistoryRecord> c = this.cursor();){
            boolean bl = c.next();
            return bl;
        }
    }

    @Override
    public BAbsTime lastTimestamp() {
        BAbsTime lastTimestamp = BAbsTime.NULL;
        try (TableCursor<BHistoryRecord> cursor = this.cursor();){
            while (cursor.next()) {
                lastTimestamp = ((BHistoryRecord)cursor.get()).getTimestamp();
            }
        }
        return lastTimestamp;
    }

    private static BNumericTrendRecord getReferenceRecord(BIHistory history, BAbsTime start) {
        if (start == null) {
            return null;
        }
        try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(null);){
            BITable<BHistoryRecord> collection = conn.timeQuery(history, null, start);
            BNumericTrendRecord result = null;
            if (collection != null) {
                try (TableCursor cursor = collection.cursor();){
                    while (true) {
                        if (cursor.next()) {
                            BObject obj = (BObject)cursor.get();
                            if (obj instanceof BNumericTrendRecord) {
                                if (!((BNumericTrendRecord)obj).getTimestamp().isBefore(start)) continue;
                                result = (BNumericTrendRecord)obj;
                                continue;
                            }
                            BNumericTrendRecord bNumericTrendRecord = null;
                            return bNumericTrendRecord;
                            continue;
                        }
                        break;
                    }
                }
            }
            BNumericTrendRecord bNumericTrendRecord = result;
            return bNumericTrendRecord;
        }
    }

    public BObject bqlQuery(BOrd ord) {
        if (this.history instanceof BFoxHistory) {
            BFoxHistorySpace historySpace = (BFoxHistorySpace)this.history.getSpace();
            return historySpace.bqlQuery(ord);
        }
        throw new UnresolvedException("Query is not remote.");
    }
}

