/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.point;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.BInfinityPointDeviceExt;
import com.tridium.andoverInfinity.comm.req.BInfinityPointDisableRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityPointEnableRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityReadPointRequest;
import com.tridium.andoverInfinity.identify.BInfinityPointId;
import com.tridium.andoverInfinity.identify.BInfinityReadPointParams;
import com.tridium.andoverInfinity.identify.BInfinityWritePointParams;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import java.util.logging.Level;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityProxyExt
extends BDdfProxyExt
implements BIPollable {
    public static final Property readParameters = BInfinityProxyExt.newProperty((int)0, (BValue)new BInfinityReadPointParams(), (BFacets)MGR_INCLUDE);
    public static final Property writeParameters = BInfinityProxyExt.newProperty((int)0, (BValue)new BInfinityWritePointParams(), (BFacets)MGR_INCLUDE);
    public static final Property pointId = BInfinityProxyExt.newProperty((int)0, (BValue)new BInfinityPointId(), (BFacets)MGR_INCLUDE);
    public static final Property pollFrequency = BInfinityProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Action sendEnableCommand = BInfinityProxyExt.newAction((int)0, null);
    public static final Action sendDisableCommand = BInfinityProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BInfinityProxyExt.class);
    private boolean pointDisabledInPanel = false;
    BInfinityNetwork net;

    public BDdfIdParams getReadParameters() {
        return (BDdfIdParams)this.get(readParameters);
    }

    public void setReadParameters(BDdfIdParams v) {
        this.set(readParameters, (BValue)v, null);
    }

    public BDdfIdParams getWriteParameters() {
        return (BDdfIdParams)this.get(writeParameters);
    }

    public void setWriteParameters(BDdfIdParams v) {
        this.set(writeParameters, (BValue)v, null);
    }

    public BDdfIdParams getPointId() {
        return (BDdfIdParams)this.get(pointId);
    }

    public void setPointId(BDdfIdParams v) {
        this.set(pointId, (BValue)v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public void sendEnableCommand() {
        this.invoke(sendEnableCommand, null, null);
    }

    public void sendDisableCommand() {
        this.invoke(sendDisableCommand, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BInfinityPointDeviceExt.TYPE;
    }

    public BInfinityNetwork getInfinityNetwork() {
        if (this.net != null) {
            return this.net;
        }
        return (BInfinityNetwork)this.getNetwork();
    }

    public BIDdfReadRequest makePollRequest() {
        BInfinityReadPointRequest req = (BInfinityReadPointRequest)super.makePollRequest();
        req.setNetwork(this.getInfinityNetwork());
        return req;
    }

    public void doSendEnableCommand() {
        if (!this.isRunning()) {
            return;
        }
        BInfinityReadPointParams rdparms = (BInfinityReadPointParams)this.getReadParameters();
        String pointName = rdparms.getPointName();
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("do enable command on " + pointName);
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPointEnableRequest(this));
    }

    public void doSendDisableCommand() {
        if (!this.isRunning()) {
            return;
        }
        BInfinityReadPointParams rdparms = (BInfinityReadPointParams)this.getReadParameters();
        String pointName = rdparms.getPointName();
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("do disable command on " + pointName);
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPointDisableRequest(this));
    }
}

