/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinetDevice;
import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.BInfinityNetworkDevice;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityWritePointResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.andoverInfinity.identify.BInfinityReadPointParams;
import com.tridium.andoverInfinity.identify.BInfinityWritePointParams;
import com.tridium.andoverInfinity.point.BInfinityProxyExt;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityWritePointRequest
extends BDdfWriteRequest
implements RequiresNetworkAccess,
Vt100Const {
    public static final Type TYPE = Sys.loadType(BInfinityWritePointRequest.class);
    BInfinityNetwork network;
    String disableCommandString = "";
    String setCommandString;
    BStatusValue writeValue;

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityWritePointRequest:processReceive(), mode=" + cursorModes[mode]);
        int line = this.network.getScreen().getCursorLine();
        switch (mode) {
            case 4: {
                if (this.network.getScreen().getTextLine(line).endsWith("R>")) {
                    BInfinityWritePointParams writeParams = (BInfinityWritePointParams)this.getOriginator().getWriteParameters();
                    if (!writeParams.disableCommandHasBeenSent && this.network.getScreen().getTextLine(line - 2).trim().indexOf(this.disableCommandString.trim()) != -1) {
                        writeParams.disableCommandHasBeenSent = true;
                    }
                    if (this.network.getScreen().getTextLine(line - 1).trim().indexOf(this.setCommandString.trim()) != -1) {
                        BInfinityWritePointResponse rsp = new BInfinityWritePointResponse();
                        BStatusValue val = this.copyWriteValue();
                        rsp.setValueWritten(val);
                        return rsp;
                    }
                    throw new DdfResponseException(this.network.getScreen().getTextLine(line - 1));
                }
                throw new DdfResponseException("R> not found:" + this.network.getScreen().getTextLine(line));
            }
        }
        throw new DdfResponseException("cursor mode invalid:" + mode);
    }

    private BInfinityProxyExt getOriginator() {
        IDdfWritable[] pointsToUpdate = this.getWritableSource();
        for (int i = 0; i < pointsToUpdate.length; ++i) {
            if (!(pointsToUpdate[i] instanceof BInfinityProxyExt)) continue;
            return (BInfinityProxyExt)pointsToUpdate[i];
        }
        throw new RuntimeException("not a InfinityProxyExt");
    }

    private BStatusValue copyWriteValue() {
        if (this.writeValue instanceof BStatusNumeric) {
            return (BStatusNumeric)this.writeValue.newCopy();
        }
        if (this.writeValue instanceof BStatusBoolean) {
            return (BStatusBoolean)this.writeValue.newCopy();
        }
        if (this.writeValue instanceof BStatusEnum) {
            return (BStatusEnum)this.writeValue.newCopy();
        }
        return (BStatusString)this.writeValue.newCopy();
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityWritePointRequest:toByteArray(), mode=" + cursorModes[mode]);
        StringBuffer sb = new StringBuffer();
        switch (mode) {
            case 0: 
            case 1: 
            case 138: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        BInfinityProxyExt updateProxy = this.getOriginator();
        BInfinityReadPointParams pointParams = (BInfinityReadPointParams)updateProxy.getReadParameters();
        String pointName = pointParams.getPointName();
        BInfinetDevice device = (BInfinetDevice)updateProxy.getDevice();
        BInfinityDeviceId deviceId = (BInfinityDeviceId)device.getDeviceId();
        String deviceName = device instanceof BInfinityNetworkDevice ? "" : deviceId.getControllerName();
        this.writeValue = updateProxy.getWriteValue();
        String valueString = "";
        if (this.writeValue instanceof BStatusNumeric) {
            int precision = updateProxy.getPointFacets().geti("precision", 1);
            valueString = ((BStatusNumeric)this.writeValue).valueToString((Context)BFacets.makeNumeric((int)precision));
        } else if (this.writeValue instanceof BStatusEnum) {
            valueString = Integer.toString(((BStatusEnum)this.writeValue).getEnum().getOrdinal());
        } else if (this.writeValue instanceof BStatusBoolean) {
            valueString = ((BStatusBoolean)this.writeValue).getBoolean() ? "On" : "Off";
        } else if (this.writeValue instanceof BStatusString) {
            valueString = '\"' + ((BStatusString)this.writeValue).getValue() + '\"';
        }
        if (valueString.length() == 0) {
            throw new RuntimeException("cannot covert " + updateProxy.getDisplayName(null) + "writeValue.");
        }
        BInfinityWritePointParams writeParams = (BInfinityWritePointParams)updateProxy.getWriteParameters();
        if (writeParams.needToSendDisableCommand()) {
            StringBuffer disSb = new StringBuffer();
            disSb.append("DIS ");
            disSb.append(deviceName).append(" ");
            disSb.append(pointName).append("\r");
            this.disableCommandString = disSb.toString();
            sb.append(disSb);
        }
        StringBuffer setSb = new StringBuffer();
        setSb.append("SET ");
        setSb.append(deviceName).append(" ");
        setSb.append(pointName).append("=").append(valueString).append("\r");
        this.setCommandString = setSb.toString();
        sb.append(setSb);
        return sb.toString().getBytes();
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

