/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinitySetTimeRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess {
    public static final Property remainingRetryCount = BInfinitySetTimeRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BInfinitySetTimeRequest.class);
    BInfinityNetwork network;
    String jaceDateTimeString = "";

    public int getRemainingRetryCount() {
        return this.getInt(remainingRetryCount);
    }

    public void setRemainingRetryCount(int v) {
        this.setInt(remainingRetryCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinitySetTimeRequest:processReceive(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 4: 
            case 95: 
            case 134: 
            case 135: {
                this.network.getLogger().severe("error on sync time " + this.jaceDateTimeString + ",mode=" + cursorModes[mode]);
                throw new DdfResponseException("error setting time:" + cursorModes[mode]);
            }
            case 2: {
                return new BInfinitySuccessResponse();
            }
        }
        this.network.getLogger().severe("illegal mode on sync time " + this.jaceDateTimeString + ",mode=" + cursorModes[mode]);
        throw new DdfResponseException("illegal mode to set time:" + cursorModes[mode]);
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        StringBuffer sb = new StringBuffer();
        this.network.getLogger().fine("BInfinitySetTimeRequest:toByteArray(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 0: 
            case 1: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        sb.append("\u001bOSED");
        this.jaceDateTimeString = this.getJaceDateTimeString();
        System.out.println("jaceDateTimeString:" + this.jaceDateTimeString);
        sb.append(this.jaceDateTimeString);
        sb.append("\r");
        return sb.toString().getBytes();
    }

    private String getJaceDateTimeString() {
        BAbsTime jDate = BAbsTime.now();
        int jMinute = jDate.getMinute();
        int jSecond = jDate.getSecond();
        String jYearString = String.valueOf(jDate.getYear());
        String jMonthString = jDate.getMonth().getTag().toUpperCase().substring(0, 3);
        String jDayString = String.valueOf(jDate.getDay());
        String jHourString = String.valueOf(jDate.getHour());
        String jMinuteString = String.valueOf(jDate.getMinute());
        String jSecondString = String.valueOf(jDate.getSecond());
        if (jMinute < 10) {
            jMinuteString = "0" + jMinuteString;
        }
        if (jSecond < 10) {
            jSecondString = "0" + jSecondString;
        }
        String answer = jMonthString + " " + jDayString + "," + jYearString + " " + jHourString + ":" + jMinuteString + ":" + jSecondString;
        while (answer.length() < 32) {
            answer = answer + " ";
        }
        return answer;
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

