/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.BBlob;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinitySaveInfinetRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Property remainingRetryCount = BInfinitySaveInfinetRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BInfinitySaveInfinetRequest.class);
    BInfinityNetwork network;
    StringBuffer backup = new StringBuffer();

    public int getRemainingRetryCount() {
        return this.getInt(remainingRetryCount);
    }

    public void setRemainingRetryCount(int v) {
        this.setInt(remainingRetryCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        if (this.network.isShouldAbortReload()) {
            this.network.getLogger().info("sending reload abort");
            this.network.setShouldAbortReload(false);
            return new BInfinityAckWithData(String.valueOf('\u001b'));
        }
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinitySaveInfinetRequest:processReceive(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 136: {
                this.network.getScreen().initializeBackupBuffer();
                this.network.setBackupModeActive(true);
                return new BInfinityAckWithData("\r");
            }
            case 137: {
                this.network.setBackupModeActive(false);
                return new BInfinityAckWithData("\r");
            }
            case 138: {
                return new BInfinityAckWithData("");
            }
            case 4: {
                this.network.setBackupModeActive(false);
                return new BInfinitySuccessResponse();
            }
        }
        this.network.getLogger().severe("illegal mode on infinet save ,mode=" + cursorModes[mode]);
        this.network.keystrokesCommand(BString.make((String)String.valueOf('\u001b')));
        throw new DdfResponseException("illegal mode on infinet save ,mode=" + cursorModes[mode]);
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        StringBuffer sb = new StringBuffer();
        this.network.getLogger().fine("BInfinitySaveInfinetRequest:toByteArray(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 0: 
            case 1: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        sb.append("SAVE INFINET\r");
        return sb.toString().getBytes();
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
        network.setShouldAbortReload(false);
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
        this.network.getLogger().fine("BInfinitySaveInfinetRequest:processErrorResponse()");
        byte[] blobBytes = this.network.getScreen().getBackupBytes();
        System.out.print(new String(blobBytes));
        this.network.fireBackupModeDone((BValue)BBlob.make((byte[])blobBytes));
        this.network.setBackupModeActive(false);
    }

    public void processLateResponse(BIDdfResponse ddfRsp) {
        this.network.fireBackupModeDone((BValue)BString.make((String)""));
        this.network.setBackupModeActive(false);
    }

    public void processResponse(BIDdfResponse ddfRsp) {
        byte[] blobBytes = this.network.getScreen().getBackupBytes();
        this.network.getLogger().fine("BInfinitySaveInfinetRequest:processResponse()");
        System.out.print(new String(blobBytes));
        this.network.fireBackupModeDone((BValue)BBlob.make((byte[])blobBytes));
    }

    public void processTimeout() {
        this.network.getLogger().fine("BInfinitySaveInfinetRequest:processTimeout()");
        this.network.fireBackupModeDone((BValue)BString.make((String)""));
        this.network.setBackupModeActive(false);
    }
}

