/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.io.BufferedReader;
import java.io.IOException;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityReloadLineRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Property responseTimeout = BInfinityReloadLineRequest.newProperty((int)0, (BValue)BRelTime.make((long)200L), null);
    public static final Property remainingRetryCount = BInfinityReloadLineRequest.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BInfinityReloadLineRequest.class);
    BInfinityNetwork network;
    BufferedReader in;
    String nextLine;

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    public int getRemainingRetryCount() {
        return this.getInt(remainingRetryCount);
    }

    public void setRemainingRetryCount(int v) {
        this.setInt(remainingRetryCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    BInfinityReloadLineRequest(String nextLine, BufferedReader in) {
        this.nextLine = nextLine;
        this.in = in;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityReloadLineRequest.processReceive(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 140: {
                int lineNum = this.network.getScreen().getCursorLine() - 1;
                String errorLine = this.network.getScreen().getFullLine(lineNum);
                this.network.getLogger().severe(this.nextLine + ":" + errorLine);
                throw new DdfResponseException(this.nextLine + ":" + errorLine);
            }
            case 4: {
                return new BInfinitySuccessResponse();
            }
        }
        this.network.getLogger().severe("illegal mode on infinet save ,mode=" + cursorModes[mode]);
        throw new DdfResponseException("illegal mode on infinet save ,mode=" + cursorModes[mode]);
    }

    public byte[] toByteArray() {
        return this.nextLine.getBytes();
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
        this.network.getLogger().severe("BInfinityReloadRequest:" + errorRsp.getMessage());
        this.processTimeout();
    }

    public void processLateResponse(BIDdfResponse ddfRsp) {
    }

    public void processResponse(BIDdfResponse ddfRsp) {
        System.out.println("BInfinityReloadRequest:processResponse");
        this.network.setReloadModeActive(false);
        this.network.fireBackupModeDone((BValue)BString.make((String)"done"));
    }

    public void processTimeout() {
        String line;
        int mode = this.network.getScreen().getMode();
        switch (mode) {
            case 4: {
                System.out.println("BInfinityReloadRequest:processTimeout while CURSOR_IS_IN_COMMAND_LINE_AREA");
                this.network.setReloadModeActive(false);
                this.network.fireBackupModeDone((BValue)BString.make((String)"done"));
                return;
            }
        }
        try {
            line = this.in.readLine();
        }
        catch (IOException e) {
            this.network.getLogger().severe("IOException reading dump file buffer");
            e.printStackTrace();
            return;
        }
        if (line == null) {
            this.network.setReloadModeActive(false);
            this.network.fireBackupModeDone((BValue)BString.make((String)"done"));
        } else {
            BInfinityReloadLineRequest lineReq = new BInfinityReloadLineRequest(line + "\n", this.in);
            ((BInfinityCommunicator)this.network.getCommunicator()).communicate((BIDdfRequest)lineReq);
        }
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

