/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.BInfinityReloadLineRequest;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityReloadStartResponse;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import javax.baja.sys.BBlob;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityReloadInfinetRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess,
BIDdfCustomRequest {
    public static final Property fileContents = BInfinityReloadInfinetRequest.newProperty((int)0, (BValue)BBlob.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BInfinityReloadInfinetRequest.class);
    BInfinityNetwork network;
    BufferedReader in;

    public BBlob getFileContents() {
        return (BBlob)this.get(fileContents);
    }

    public void setFileContents(BBlob v) {
        this.set(fileContents, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        if (this.network.getLogger().isLoggable(Level.FINE)) {
            this.network.getLogger().fine("BInfinitySaveInfinetRequest.processReceive, mode=" + cursorModes[mode]);
        }
        switch (mode) {
            case 140: {
                return new BInfinityReloadStartResponse();
            }
        }
        throw new DdfResponseException("illegal mode on infinet save ,mode=" + cursorModes[mode]);
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        StringBuffer sb = new StringBuffer();
        if (this.network.getLogger().isLoggable(Level.FINE)) {
            this.network.getLogger().fine("BInfinityReloadInfinetRequest:toByteArray(), mode=" + cursorModes[mode]);
        }
        switch (mode) {
            case 0: 
            case 1: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        this.network.setReloadModeActive(true);
        sb.append("RELOAD -o\r");
        this.in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.getFileContents().copyBytes())));
        return sb.toString().getBytes();
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
        this.network.setReloadModeActive(false);
        this.network.fireReloadModeDone((BValue)BString.make((String)errorRsp.getMessage()));
        this.network.getLogger().severe(errorRsp.getMessage());
    }

    public void processLateResponse(BIDdfResponse ddfRsp) {
    }

    public void processResponse(BIDdfResponse ddfRsp) {
        if (this.network.getLogger().isLoggable(Level.FINE)) {
            this.network.getLogger().fine("BInfinityReloadInfinetRequest:processResponse is sending first line");
        }
        try {
            String firstLine = this.in.readLine();
            if (firstLine != null) {
                firstLine = firstLine + "\n";
                if (this.network.getLogger().isLoggable(Level.FINE)) {
                    this.network.getLogger().fine("firstLine=" + firstLine);
                }
                BInfinityReloadLineRequest lineReq = new BInfinityReloadLineRequest(firstLine, this.in);
                lineReq.setNetwork(this.network);
                ((BInfinityCommunicator)this.network.getCommunicator()).communicate((BIDdfRequest)lineReq);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.network.getLogger().severe("could not read first Line of reload file ,mode=" + cursorModes[this.network.getScreen().getMode()] + e);
        }
    }

    public void processTimeout() {
        this.network.setReloadModeActive(false);
        this.network.fireReloadModeDone((BValue)BString.make((String)"no response to reload command"));
        this.network.getLogger().severe("no response to reload command");
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

