/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinetDevice;
import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.BInfinityNetworkDevice;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityPointAutoResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.andoverInfinity.identify.BInfinityReadPointParams;
import com.tridium.andoverInfinity.identify.BInfinityWritePointParams;
import com.tridium.andoverInfinity.point.BInfinityProxyExt;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfWriteRequest;
import com.tridium.ddf.comm.req.IDdfWritable;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityPointEnableRequest
extends BDdfWriteRequest
implements RequiresNetworkAccess,
Vt100Const {
    public static final Type TYPE = Sys.loadType(BInfinityPointEnableRequest.class);
    BInfinityNetwork network;
    String enableCommandString;

    public Type getType() {
        return TYPE;
    }

    public BInfinityPointEnableRequest() {
    }

    public BInfinityPointEnableRequest(BInfinityProxyExt ddfProxyExt) {
        super((BDdfProxyExt)ddfProxyExt);
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityPointEnableRequest:processReceive(), mode=" + cursorModes[mode]);
        int line = this.network.getScreen().getCursorLine();
        switch (mode) {
            case 4: {
                if (this.network.getScreen().getTextLine(line).endsWith("R>")) {
                    BInfinityProxyExt ext = this.getOriginator();
                    String responseLine = this.network.getScreen().getTextLine(line - 1);
                    if (responseLine.indexOf(this.enableCommandString) != -1) {
                        BInfinityWritePointParams writeparams = (BInfinityWritePointParams)ext.getWriteParameters();
                        writeparams.disableCommandHasBeenSent = false;
                        BInfinityPointAutoResponse rsp = new BInfinityPointAutoResponse();
                        return rsp;
                    }
                    throw new DdfResponseException("Response does not echo request:" + this.network.getScreen().getTextLine(line - 1));
                }
                throw new DdfResponseException("R> not found:" + this.network.getScreen().getTextLine(line));
            }
        }
        throw new DdfResponseException("cursor mode invalid:" + mode);
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityPointEnableRequest:toByteArray(), mode=" + cursorModes[mode]);
        StringBuffer sb = new StringBuffer();
        switch (mode) {
            case 0: 
            case 1: 
            case 138: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        BInfinityProxyExt updateProxy = this.getOriginator();
        BInfinityReadPointParams pointParams = (BInfinityReadPointParams)updateProxy.getReadParameters();
        String pointName = pointParams.getPointName();
        BInfinetDevice device = (BInfinetDevice)updateProxy.getDevice();
        BInfinityDeviceId deviceId = (BInfinityDeviceId)device.getDeviceId();
        if (device instanceof BInfinityNetworkDevice) {
            sb.append("EN ").append(pointName).append("\r");
            this.enableCommandString = "EN " + pointName;
        } else {
            sb.append("EN ").append(deviceId.getControllerName()).append(" ").append(pointName).append("\r");
            this.enableCommandString = "EN " + deviceId.getControllerName() + " " + pointName;
        }
        return sb.toString().getBytes();
    }

    private BInfinityProxyExt getOriginator() {
        IDdfWritable[] pointsToUpdate = this.getWritableSource();
        for (int i = 0; i < pointsToUpdate.length; ++i) {
            if (!(pointsToUpdate[i] instanceof BInfinityProxyExt)) continue;
            return (BInfinityProxyExt)pointsToUpdate[i];
        }
        throw new RuntimeException("not a InfinityProxyExt");
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

