/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityTransmitter;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinityPointDiscoverResponse;
import com.tridium.andoverInfinity.discover.BInfinityPointDiscoveryLeaf;
import com.tridium.andoverInfinity.discover.BInfinityPointDiscoveryPreferences;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.andoverInfinity.identify.BInfinityDiscoveryPointId;
import com.tridium.andoverInfinity.identify.BInfinityReadPointParams;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfDiscoveryRequest;
import com.tridium.ddf.comm.req.BDdfRawTransmitRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryJob;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityPointDiscoverRequest
extends BDdfDiscoveryRequest
implements Vt100Const,
RequiresNetworkAccess {
    public static final Type TYPE = Sys.loadType(BInfinityPointDiscoverRequest.class);
    private BInfinityNetwork network;
    private Vector<BInfinityPointDiscoveryLeaf> discoveredLeaves = new Vector();

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        if (this.network.getScreen().isBell()) {
            this.getDiscoverer().getJob().log().message("received bell character, aborting");
            throw new DdfResponseException("received bell");
        }
        int mode = this.network.getScreen().getMode();
        this.getDiscoverer().getJob().log().message("processReceive, mode:" + cursorModes[mode]);
        this.network.getLogger().fine("BInfinityPointDiscoverRequest:processReceive(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 4: {
                String actualLevel = this.network.getScreen().parseInfinetControllerNameFromLine1();
                BInfinityDeviceId deviceId = (BInfinityDeviceId)this.getDeviceId();
                String desiredLevel = deviceId.getControllerName();
                if (actualLevel != null && actualLevel.length() > 0 && !desiredLevel.equals(actualLevel)) {
                    this.getDiscoverer().getJob().log().message("adding change device command....");
                    if ("".equalsIgnoreCase(desiredLevel)) {
                        return new BInfinityAckWithData("CD\r");
                    }
                    return new BInfinityAckWithData("CD " + desiredLevel + "\r");
                }
                this.getDiscoverer().getJob().log().message("sending View Points command");
                return new BInfinityAckWithData("\u001bOSVP");
            }
            case 17: {
                this.getDiscoverer().getJob().log().message("no user points found, sending View system Variables command");
                this.getDiscoverer().getJob().progress(50);
                return new BInfinityAckWithData("\rVV");
            }
            case 24: {
                this.getDiscoverer().getJob().log().message("User points found, processing...");
                this.getDiscoverer().getJob().progress(25);
                this.processScreenBufferForPoints(mode);
                this.getDiscoverer().getJob().log().message("Found " + this.discoveredLeaves.size() + " user points");
                this.getDiscoverer().getJob().progress(50);
                return new BInfinityAckWithData("\u001bOSVV");
            }
            case 29: {
                this.getDiscoverer().getJob().log().message("System Variable points found, processing...");
                this.getDiscoverer().getJob().progress(75);
                this.processScreenBufferForPoints(mode);
                BInfinityPointDiscoveryLeaf[] capturedLeaves = new BInfinityPointDiscoveryLeaf[this.discoveredLeaves.size()];
                this.discoveredLeaves.toArray(capturedLeaves);
                BInfinityPointDiscoverResponse rsp = new BInfinityPointDiscoverResponse(capturedLeaves);
                this.getDiscoverer().getJob().log().message("Found " + capturedLeaves.length + " total points");
                this.getDiscoverer().getJob().progress(100);
                return rsp;
            }
        }
        this.getDiscoverer().getJob().log().failed("illegal mode for point discovery:" + cursorModes[mode]);
        throw new DdfResponseException("illegal mode for point discovery:" + cursorModes[mode]);
    }

    private void processScreenBufferForPoints(int mode) {
        switch (mode) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                String newPoint;
                if (this.network.getLogger().isLoggable(Level.FINE)) {
                    this.network.getScreen().doDumpScreen();
                }
                boolean lastPage = false;
                for (int i = 5; i < 21 && (newPoint = this.network.getScreen().getFullLine(i)).substring(1, 79).trim().length() != 0; ++i) {
                    BInfinityPointDiscoveryLeaf newDiscovery;
                    boolean alreadyAdded = false;
                    try {
                        newDiscovery = this.parseDiscoveryObject(newPoint, mode);
                    }
                    catch (Exception e) {
                        this.getDiscoverer().getJob().log().message("error parsing:" + newPoint);
                        continue;
                    }
                    for (int j = 0; j < this.discoveredLeaves.size(); ++j) {
                        BInfinityPointDiscoveryLeaf alreadyDiscoveredLeaf = this.discoveredLeaves.get(j);
                        if (!((BInfinityReadPointParams)newDiscovery.getReadParameters()).getPointName().equals(((BInfinityReadPointParams)alreadyDiscoveredLeaf.getReadParameters()).getPointName())) continue;
                        alreadyAdded = true;
                        lastPage = true;
                        break;
                    }
                    if (!alreadyAdded) {
                        this.discoveredLeaves.add(newDiscovery);
                    }
                    if (i != 20 || lastPage) continue;
                    this.getDiscoverer().getJob().log().message("getting next page...");
                    String pagedown = Vt100Const.CURSOR_PAGE_DOWN;
                    if (this.network.getPageUpPageDown()) {
                        pagedown = "\u001b[6~";
                    }
                    BDdfRawTransmitRequest req = new BDdfRawTransmitRequest(pagedown.getBytes());
                    BInfinityTransmitter xmitter = (BInfinityTransmitter)this.network.getDdfCommunicator().getDdfTransmitter();
                    try {
                        xmitter.forceTransmit((BIDdfRequest)req);
                        BDdfAutoDiscoveryJob j = (BDdfAutoDiscoveryJob)this.getDiscoverer().getJob();
                        BInfinityPointDiscoveryPreferences pref = (BInfinityPointDiscoveryPreferences)j.getDiscoveryPreferences();
                        this.getDiscoverer().getJob().log().message("sleeping " + pref.getPointDiscoveryPageTimeout());
                        Thread.sleep(pref.getPointDiscoveryPageTimeout().getMillis());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    i = 5;
                }
                break;
            }
        }
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityPointDiscoverRequest:toByteArray(), mode=" + cursorModes[mode]);
        StringBuffer sb = new StringBuffer();
        BInfinityDeviceId deviceId = (BInfinityDeviceId)this.getDeviceId();
        String desiredLevel = deviceId.getControllerName();
        this.getDiscoverer().getJob().log().message("Starting mode is " + cursorModes[mode]);
        switch (mode) {
            case 4: {
                this.getDiscoverer().getJob().progress(5);
                this.getDiscoverer().getJob().log().message("adding cursor moves...");
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                this.getDiscoverer().getJob().log().message("Sending recovery sequence only...");
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                this.getDiscoverer().getJob().log().message("adding recovery sequence...");
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        String actualLevel = this.network.getScreen().parseInfinetControllerNameFromLine1();
        this.getDiscoverer().getJob().log().message("actual level = " + actualLevel);
        this.getDiscoverer().getJob().log().message("desired level = " + desiredLevel);
        if (actualLevel == null) {
            return sb.toString().getBytes();
        }
        if (!desiredLevel.equals(actualLevel)) {
            this.getDiscoverer().getJob().log().message("adding change device command....");
            if (desiredLevel == "") {
                sb.append("CD\r");
            } else {
                sb.append("CD " + desiredLevel + "\r");
            }
        }
        return sb.toString().getBytes();
    }

    public BInfinityPointDiscoveryLeaf parseDiscoveryObject(String line, int mode) throws Exception {
        String pointState;
        String pointChannel;
        String pointIou;
        String pointUnits;
        String pointValue;
        String pointType;
        String pointName;
        System.out.println("BInfinityPointDiscoverRequest.parseDiscoveryObject");
        System.out.println("  parsing:" + line);
        if (mode == 24 || mode == 25 || mode == 26 || mode == 27 || mode == 28) {
            pointName = line.substring(2, 18).trim();
            pointType = line.substring(50, 63).trim();
            if (pointType.equals("String")) {
                pointValue = line.substring(19, 49).trim();
                pointUnits = "";
                pointIou = "";
                pointChannel = "";
                pointState = line.substring(70, 79).trim();
            } else if (pointType.equals("DateTime")) {
                pointValue = line.substring(19, 49).trim();
                pointUnits = "";
                pointIou = "";
                pointChannel = "";
                pointState = line.substring(70, 79).trim();
            } else {
                pointValue = line.substring(19, 36).trim();
                pointUnits = line.substring(36, 49).trim();
                pointIou = line.substring(64, 67).trim();
                pointChannel = line.substring(68, 70).trim();
                pointState = line.substring(70, 79).trim();
            }
        } else if (mode == 29) {
            pointName = line.substring(2, 18).trim();
            pointType = "System Var";
            pointValue = line.substring(36, 64).trim();
            pointUnits = "";
            pointIou = "";
            pointChannel = "";
            pointState = line.substring(70, 79).trim();
        } else {
            throw new Exception("incorrect mode");
        }
        BInfinityPointDiscoveryLeaf discLeaf = new BInfinityPointDiscoveryLeaf();
        BInfinityReadPointParams params = (BInfinityReadPointParams)discLeaf.getReadParameters();
        BInfinityDiscoveryPointId id = (BInfinityDiscoveryPointId)discLeaf.getPointId();
        params.setPointName(pointName);
        id.setRawValue(pointValue);
        id.setRawPointUnits(pointUnits);
        id.setRawPointType(pointType);
        id.setRawPointChannel(pointChannel);
        id.setRawPointIou(pointIou);
        id.setRawPointState(pointState);
        return discLeaf;
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

