/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityTransmitter;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinityDeviceDiscoverResponse;
import com.tridium.andoverInfinity.discover.BInfinityDeviceDiscoveryPreferences;
import com.tridium.andoverInfinity.identify.BInfinityDeviceDiscoveryObject;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfDiscoveryRequest;
import com.tridium.ddf.comm.req.BDdfRawTransmitRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInfinityDeviceDiscoverRequest
extends BDdfDiscoveryRequest
implements Vt100Const,
RequiresNetworkAccess {
    public static final Type TYPE = Sys.loadType(BInfinityDeviceDiscoverRequest.class);
    private BInfinityNetwork network;
    private Vector<BInfinityDeviceDiscoveryObject> devices = new Vector();

    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        if (this.network.getScreen().isBell()) {
            this.getDiscoverer().getJob().log().message("received bell character, aborting");
            throw new DdfResponseException("received bell");
        }
        int mode = this.network.getScreen().getMode();
        this.getDiscoverer().getJob().log().message("processReceive, mode:" + cursorModes[mode]);
        this.network.getLogger().fine("BInfinityDeviceDescoverRequest:processReceive(),mode=" + cursorModes[mode]);
        switch (mode) {
            case 4: {
                this.getDiscoverer().getJob().log().message("sending View infineT controllers...");
                this.getDiscoverer().getJob().progress(10);
                return new BInfinityAckWithData("\u001bOSVt");
            }
            case 17: {
                this.getDiscoverer().getJob().log().message("no controllers found");
                this.getDiscoverer().getJob().progress(100);
                BInfinityDeviceDiscoverResponse emptyRsp = new BInfinityDeviceDiscoverResponse();
                return emptyRsp;
            }
            case 33: {
                this.getDiscoverer().getJob().log().message("devices found, processing...");
                this.getDiscoverer().getJob().progress(50);
                this.processScreenBufferForDevices(mode);
                this.getDiscoverer().getJob().progress(100);
                BInfinityDeviceDiscoverResponse rsp = new BInfinityDeviceDiscoverResponse();
                BInfinityDeviceDiscoveryObject[] capturedDevices = new BInfinityDeviceDiscoveryObject[this.devices.size()];
                this.devices.toArray(capturedDevices);
                rsp.setDiscoveryData(capturedDevices);
                return rsp;
            }
        }
        throw new DdfResponseException("illegal mode for device discovery:" + mode);
    }

    private void processScreenBufferForDevices(int mode) {
        block2 : switch (mode) {
            case 33: {
                if (this.network.getLogger().isLoggable(Level.FINE)) {
                    this.network.getScreen().doDumpScreen();
                }
                boolean lastPage = false;
                for (int i = 5; i < 21; ++i) {
                    BInfinityDeviceDiscoveryObject newDiscovery;
                    String newDevice = this.network.getScreen().getFullLine(i).substring(1, 79).trim();
                    this.network.getLogger().fine(newDevice);
                    if (newDevice.length() == 0) break block2;
                    try {
                        newDiscovery = this.parseDiscoveryObject(newDevice, mode);
                    }
                    catch (Exception e) {
                        this.getDiscoverer().getJob().log().message("error parsing:" + newDevice);
                        continue;
                    }
                    boolean alreadyAdded = false;
                    for (int j = 0; j < this.devices.size(); ++j) {
                        if (!(this.devices.get(j) instanceof BInfinityDeviceDiscoveryObject)) continue;
                        BInfinityDeviceDiscoveryObject alreadyDiscoveredLeaf = this.devices.get(j);
                        if (!newDiscovery.getControllerName().equals(alreadyDiscoveredLeaf.getControllerName())) continue;
                        alreadyAdded = true;
                        lastPage = true;
                        break;
                    }
                    if (!alreadyAdded) {
                        this.getDiscoverer().getJob().log().message("found " + newDiscovery.getDiscoveryName() + " port=" + newDiscovery.getPort());
                        this.devices.add(newDiscovery);
                    }
                    if (i != 20 || lastPage) continue;
                    this.getDiscoverer().getJob().log().message("getting next page...");
                    String pagedown = Vt100Const.CURSOR_PAGE_DOWN;
                    if (this.network.getPageUpPageDown()) {
                        pagedown = "\u001b[6~";
                    }
                    BDdfRawTransmitRequest req = new BDdfRawTransmitRequest(pagedown.getBytes());
                    BInfinityTransmitter xmitter = (BInfinityTransmitter)this.network.getDdfCommunicator().getDdfTransmitter();
                    try {
                        xmitter.forceTransmit((BIDdfRequest)req);
                        BInfinityDeviceDiscoveryPreferences pref = (BInfinityDeviceDiscoveryPreferences)this.network.getDiscoveryPreferences();
                        Thread.sleep(pref.getDeviceDiscoveryPageTimeout().getMillis());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    i = 5;
                }
                break;
            }
        }
    }

    private BInfinityDeviceDiscoveryObject parseDiscoveryObject(String line, int mode) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        BInfinityDeviceDiscoveryObject newDevice = new BInfinityDeviceDiscoveryObject();
        newDevice.setControllerName(tokenizer.nextToken());
        newDevice.setPort(tokenizer.nextToken());
        newDevice.setModel(tokenizer.nextToken());
        newDevice.setSerialNumber(tokenizer.nextToken());
        newDevice.setId(tokenizer.nextToken());
        newDevice.setOnlineStatus(tokenizer.nextToken());
        return newDevice;
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityDeviceDescoverRequest:toByteArray()," + cursorModes[mode]);
        StringBuffer sb = new StringBuffer();
        this.getDiscoverer().getJob().log().message("Starting mode is " + cursorModes[mode]);
        switch (mode) {
            case 4: {
                this.getDiscoverer().getJob().progress(5);
                this.getDiscoverer().getJob().log().message("adding cursor moves...");
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                this.getDiscoverer().getJob().log().message("Sending recovery sequence only...");
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                this.getDiscoverer().getJob().log().message("adding recovery sequence...");
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        sb.append("\u001bOSVt");
        return sb.toString().getBytes();
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

