/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.CursorPosition;
import com.tridium.andoverInfinity.comm.MarkerPosition;
import com.tridium.andoverInfinity.comm.Vt100Const;
import java.util.StringTokenizer;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BVt100
extends BStruct
implements Vt100Const {
    public static final Type TYPE = Sys.loadType(BVt100.class);
    private boolean backupmodeNewLine = false;
    private ScreenBuffer screenBuffer;
    private StringBuffer escapeSequence;
    private StringBuffer possibleEscapeSequence;
    private int state = 0;
    private int line = 0;
    private CursorPosition oldPosition = new CursorPosition(0, 0);
    private int col = 0;
    private static final int READING_TEXT = 0;
    private static final int READING_ESCAPE_SEQUENCE = 1;
    private static final int POSSIBLE_ESCAPE_SEQUENCE = 2;
    private boolean readingGraphics = false;
    private boolean bell = false;
    private BInfinityNetwork network;
    private char currentTextMode = (char)78;
    private boolean receivedNullCharacter = false;
    private boolean insertMode = false;
    private CursorPosition insertModeCursorPosition;
    private StringBuffer backup = new StringBuffer();
    private int insertMovesCount = 0;
    private boolean readyToCheckForInsertMoves = false;

    public Type getType() {
        return TYPE;
    }

    public BVt100() {
        this.screenBuffer = new ScreenBuffer();
    }

    public BInfinityNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }

    public CursorPosition getCursorPosition() {
        return this.screenBuffer.getPos();
    }

    public byte[] getBackupBytes() {
        byte[] bytes = this.backup.toString().getBytes();
        this.backup = new StringBuffer();
        return bytes;
    }

    public void initializeBackupBuffer() {
        this.backup = new StringBuffer();
    }

    public boolean isBackupmodeNewLine() {
        return this.backupmodeNewLine;
    }

    public void processByte(char newByte) {
        if (this.network.getBackupModeActive()) {
            this.backup.append(newByte);
            this.backupmodeNewLine = newByte == '\r';
        }
        this.bell = false;
        if (newByte == '\u0007') {
            this.bell = true;
            this.network.setConnected(true);
        } else if (newByte == '\u001b') {
            this.state = 1;
            this.escapeSequence = new StringBuffer();
            this.escapeSequence.append(newByte);
        } else if (newByte == '\u000e') {
            this.readingGraphics = true;
        } else if (newByte == '\u000f') {
            this.readingGraphics = false;
        } else if (newByte == '\u0000') {
            this.insertModeCursorPosition = this.screenBuffer.getPos().newCopy();
            this.receivedNullCharacter = true;
            System.out.println("****** received null character-" + this.insertModeCursorPosition);
        } else if (newByte <= '\u007f') {
            if (this.state != 1) {
                this.receivedNullCharacter = false;
            }
            switch (this.state) {
                case 0: {
                    this.readyToCheckForInsertMoves = false;
                    if (this.readingGraphics) {
                        if (newByte == 'q') {
                            this.screenBuffer.write('-', this.line, this.col);
                            this.screenBuffer.writeFormat('-', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (newByte == 'x') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('|', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (newByte == 'j') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('j', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (newByte == 'k') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('k', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (newByte == 'l') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('l', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        } else if (newByte == 'm') {
                            this.screenBuffer.write('|', this.line, this.col);
                            this.screenBuffer.writeFormat('m', this.line, this.col);
                            this.screenBuffer.pos.line = this.line;
                            ++this.screenBuffer.pos.col;
                        }
                        ++this.col;
                        break;
                    }
                    if (newByte == '\n') {
                        ++this.line;
                        this.col = 0;
                        if (this.line < 24) {
                            this.screenBuffer.clearLine(this.line);
                        } else {
                            this.line = 23;
                            this.screenBuffer.scrollBufferUp();
                        }
                        this.screenBuffer.getPos().setLine(this.line);
                        this.screenBuffer.getPos().setCol(this.col);
                        for (int i = 0; i < 24; ++i) {
                            this.network.fireTerminalUpdated((BValue)new BInfinityLine(i, 0, i, 0, this.getFullLine(i), this.getFormatLine(i)));
                        }
                    } else if (newByte != '\r') {
                        this.screenBuffer.write(newByte, this.line, this.col);
                        this.screenBuffer.writeFormat(this.currentTextMode, this.line, this.col);
                        this.screenBuffer.pos.line = this.line;
                        ++this.screenBuffer.pos.col;
                    }
                    if (this.network.isTerminalModeActive()) {
                        BInfinityLine aline = new BInfinityLine(this.oldPosition.line, this.oldPosition.col, this.screenBuffer.getPos().getLine(), this.screenBuffer.getPos().getCol(), this.getFullLine(this.oldPosition.line), this.getFormatLine(this.oldPosition.line));
                        this.network.fireTerminalUpdated((BValue)aline);
                    }
                    ++this.col;
                    break;
                }
                case 1: {
                    this.escapeSequence.append(newByte);
                    String check = this.escapeSequence.toString();
                    if (check.equals("\u001b)0")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b(B")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?1h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?1l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?2h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?2l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?3h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?3l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?4h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?4l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?5h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?5l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?6h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?6l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?7h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?7l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?8h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?8l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?9h")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[?9l")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b>")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b=")) {
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[m")) {
                        this.currentTextMode = (char)78;
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[1m")) {
                        this.currentTextMode = (char)66;
                        this.state = 0;
                        break;
                    }
                    if (check.equals("\u001b[7m")) {
                        this.currentTextMode = (char)82;
                        this.state = 0;
                        break;
                    }
                    if (this.escapeSequence.charAt(1) != '[' || this.escapeSequence.charAt(this.escapeSequence.length() - 1) != 'H') break;
                    int semi = check.indexOf(";");
                    if (semi > 1) {
                        String lineStr = this.escapeSequence.substring(2, semi);
                        String colStr = this.escapeSequence.substring(semi + 1, this.escapeSequence.length() - 1);
                        try {
                            this.line = Integer.parseInt(lineStr) - 1;
                            this.col = Integer.parseInt(colStr) - 1;
                        }
                        catch (NumberFormatException e) {
                            this.state = 0;
                            this.network.getLogger().severe("detected illegal cursor move escape sequence:" + this.escapeSequence);
                            break;
                        }
                        this.screenBuffer.getPos().setLine(this.line);
                        this.screenBuffer.getPos().setCol(this.col);
                        CursorPosition newPosition = new CursorPosition(this.line, this.col);
                        if (newPosition.line != this.oldPosition.line) {
                            this.readyToCheckForInsertMoves = false;
                            this.insertMovesCount = 0;
                        } else if (this.readyToCheckForInsertMoves) {
                            this.insertMovesCount = newPosition.col == this.oldPosition.col + 1 ? ++this.insertMovesCount : 0;
                        } else {
                            this.readyToCheckForInsertMoves = true;
                        }
                        if (this.insertMovesCount > 3) {
                            if (!this.insertMode) {
                                this.network.getLogger().fine("detected insert mode");
                            }
                            System.out.println("detected insert mode");
                            this.insertMode = true;
                        }
                        if (this.receivedNullCharacter) {
                            System.out.println("newPosition:" + newPosition);
                            if (newPosition.equals(this.insertModeCursorPosition)) {
                                System.out.println("setting insert mode true");
                                if (!this.insertMode) {
                                    this.network.getLogger().fine("detected insert mode");
                                }
                                this.insertMode = true;
                            }
                        }
                        if (!newPosition.equals(this.oldPosition)) {
                            this.network.fireTerminalUpdated((BValue)new BInfinityLine(this.oldPosition.line, this.oldPosition.col, newPosition.line, newPosition.col, this.getFullLine(this.oldPosition.line), this.getFormatLine(this.oldPosition.line)));
                        }
                        this.oldPosition = newPosition;
                    }
                    this.state = 0;
                }
            }
        }
    }

    public boolean isStateReadingText() {
        return this.state == 0;
    }

    public String getFullLine(int line) {
        if (line < 0 || line > 23) {
            return "";
        }
        return this.screenBuffer.stringBuffers[line].toString();
    }

    public String getTextLine(int line) {
        if (line < 0 || line > 23) {
            return "";
        }
        String text = this.screenBuffer.stringBuffers[line].toString();
        int stop = text.lastIndexOf("|");
        if (stop > 1) {
            return text.substring(1, stop).trim();
        }
        return "";
    }

    public String getFormatLine(int line) {
        if (line < 0 || line > 23) {
            return "";
        }
        return this.screenBuffer.formatBuffers[line].toString();
    }

    private static boolean checkForCharacterInBuffer(StringBuffer sb, int col, char charToCheckFor) {
        return sb.charAt(col) == charToCheckFor;
    }

    public int getCursorLine() {
        return this.getCursorPosition().getLine();
    }

    public int getCursorCol() {
        return this.getCursorPosition().getCol();
    }

    public int lastNonBlankLine() {
        int lastNonBlank = 2;
        for (int i = 2; i < 21; ++i) {
            if (this.getTextLine(i).length() <= 0) continue;
            lastNonBlank = i;
        }
        return lastNonBlank;
    }

    public int findLastPromptLine() {
        for (int i = 21; i > 2; --i) {
            if (!this.getTextLine(i).equals("R>")) continue;
            return i;
        }
        return -1;
    }

    public boolean isCursorOnPrompt() {
        String line = this.getFullLine(this.getCursorLine());
        return line.startsWith("|R>") && this.getCursorCol() == 3;
    }

    public boolean isLineEmpty(int lineNum) {
        String line = this.getTextLine(lineNum);
        return line.length() == 0;
    }

    public void doDumpScreen() {
        this.screenBuffer.dump();
    }

    public int getMode() {
        int mode = 0;
        mode = this.validateSelectionBox();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateViewEditConnectLogout();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateFileEditSearchCheckTools();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateViewSummaryNoneDefinedDialog();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateBuildingListPleaseWait();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateCursorIsInCommandLineArea();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateOpenAConnectionDialog();
        if (mode > 0) {
            return mode;
        }
        int[] modesToVerify = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
        for (int i = 0; i < modesToVerify.length; ++i) {
            mode = this.validateView(modesToVerify[i]);
            if (mode <= 0) continue;
            return mode;
        }
        mode = this.validateViewMessages();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateLogoutWarningDialog();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateLoginDialog();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateEditUser();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateEditPoint();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateEditFile();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateOpenDialog();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateYesNoDialogBox();
        if (mode > 0) {
            if (this.isLine0ViewEditConnectLogout()) {
                try {
                    if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                        if (mode == 18) {
                            return 108;
                        }
                        return 109;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
                return mode;
            }
            if (mode == 18) {
                return 75;
            }
            return 76;
        }
        mode = this.validateOKDialogBox();
        if (mode > 0) {
            if (this.isLine0ViewEditConnectLogout()) {
                return mode;
            }
            int modea = this.validateSearch();
            if (modea != 0) {
                return modea;
            }
            return 77;
        }
        mode = this.validateEditPerson();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateSearch();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateEditController();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateControllerOptions();
        if (mode > 0) {
            return mode;
        }
        mode = this.validateSaveOrReloadInfinet();
        if (mode > 0) {
            return mode;
        }
        return 0;
    }

    public void setContentLine(int line, String contents) {
        this.screenBuffer.setContentLine(line, contents);
    }

    public void setFormatLine(int line, String contents) {
        this.screenBuffer.setFormatLine(line, contents);
    }

    public void setPosition(CursorPosition pos) {
        this.screenBuffer.setPos(pos);
    }

    public String screenBufferToString() {
        return this.screenBuffer.toString();
    }

    private boolean checkForSpaces(int line, int col) {
        while (col < 79) {
            if (this.screenBuffer.stringBuffers[line].charAt(col) != ' ') {
                System.out.println("col" + col + ":expecting space, but instead found " + this.screenBuffer.stringBuffers[line].charAt(col));
                return false;
            }
            ++col;
        }
        return true;
    }

    public boolean integrityCheck() {
        if (this.getMode() == 4) {
            for (int i = 2; i < 21; ++i) {
                if (this.screenBuffer.stringBuffers[i].charAt(0) != '|') {
                    return false;
                }
                if (this.screenBuffer.stringBuffers[i].charAt(79) != '|') {
                    return false;
                }
                if (i == this.getCursorLine() && !this.checkForSpaces(i, this.getCursorCol())) {
                    return false;
                }
                if (i <= this.getCursorLine() || this.checkForSpaces(i, 1)) continue;
                return false;
            }
        }
        return true;
    }

    public ScreenBuffer screenBuffer() {
        return this.screenBuffer;
    }

    public String parseInfinetControllerNameFromLine1() {
        if (this.getMode() != 4) {
            return null;
        }
        String line1 = this.getFullLine(1);
        String lineFormat = this.getFormatLine(1);
        int startOfHeaderText = lineFormat.indexOf("B");
        int endOfHeaderText = lineFormat.lastIndexOf("B");
        if (startOfHeaderText == -1) {
            return null;
        }
        String headerText = line1.substring(startOfHeaderText, endOfHeaderText + 1);
        if (headerText.indexOf("Command Window") == -1) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(headerText.substring(17).trim());
        if (st.countTokens() == 1) {
            return "";
        }
        if (st.countTokens() == 2) {
            st.nextToken();
            return st.nextToken();
        }
        return null;
    }

    public String parseNetworkControllerNameFromLine1() {
        if (this.getMode() != 4) {
            return null;
        }
        String line1 = this.getFullLine(1);
        String lineFormat = this.getFormatLine(1);
        int startOfHeaderText = lineFormat.indexOf("B");
        int endOfHeaderText = lineFormat.lastIndexOf("B");
        if (startOfHeaderText == -1) {
            return null;
        }
        String headerText = line1.substring(startOfHeaderText, endOfHeaderText + 1);
        if (headerText.indexOf("Command Window") == -1) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(headerText.substring(17).trim());
        if (st.countTokens() > 0) {
            return st.nextToken();
        }
        return null;
    }

    public boolean isRootController() throws Exception {
        if (this.getMode() != 4) {
            throw new Exception("Not in command line mode");
        }
        String formatLine = this.getFormatLine(1);
        int startOfTitle = formatLine.indexOf("B");
        int endOfTitle = formatLine.lastIndexOf("B");
        if (startOfTitle < 0 || endOfTitle < 0) {
            throw new Exception("can't determine title area");
        }
        String text = this.getFullLine(1).substring(startOfTitle, endOfTitle + 1).trim();
        StringTokenizer tok = new StringTokenizer(text.substring(17));
        return tok.countTokens() == 1;
    }

    private boolean isLine0ViewEditConnectLogout() {
        String line0 = this.getFullLine(0);
        return line0.indexOf("View") == 0 && line0.indexOf("Edit") != -1 && line0.indexOf("Connect") != -1 && line0.indexOf("Logout") != -1;
    }

    private boolean isLine0FileEditSearchCheckTools() {
        String line0 = this.getFullLine(0);
        return line0.indexOf("File") == 0 && line0.indexOf("Edit") != -1 && line0.indexOf("Search") != -1 && line0.indexOf("Check") != -1 && line0.indexOf("Tools") != -1;
    }

    private boolean isLine1Command() {
        String boxTitle;
        try {
            boxTitle = this.getBoxTitleText(1, 0, 79);
        }
        catch (Exception e) {
            return false;
        }
        return boxTitle.indexOf("Command Window - ") != -1;
    }

    private boolean isLine2Point() throws Exception {
        String boxTitle;
        try {
            boxTitle = this.getBoxTitleText(2, 2, 79);
            if (boxTitle.indexOf("Point - ") != -1) {
                return true;
            }
            if (boxTitle.indexOf("System Variable - ") != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boxTitle = this.getBoxTitleText(2, 0, 79);
        if (boxTitle.indexOf("Point - ") != -1) {
            return true;
        }
        return boxTitle.indexOf("System Variable - ") != -1;
    }

    private boolean isLine2Logs() throws Exception {
        String boxTitle = this.getBoxTitleText(2, 0, 79);
        return boxTitle.indexOf("Logs - ") != -1;
    }

    private boolean isLine2File() throws Exception {
        String boxTitle = this.getBoxTitleText(2, 0, 79);
        return boxTitle.indexOf("File - ") != -1;
    }

    private boolean isLine2Triggers() throws Exception {
        String boxTitle = this.getBoxTitleText(2, 0, 79);
        return boxTitle.indexOf("Triggers - ") != -1;
    }

    private boolean isLine2Messages() {
        String line2 = this.getFullLine(2);
        String line2Format = this.getFormatLine(2);
        int startOfHeaderText = line2Format.indexOf("B");
        int endOfHeaderText = line2Format.lastIndexOf("B");
        if (startOfHeaderText == -1) {
            return false;
        }
        String headerText = line2.substring(startOfHeaderText, endOfHeaderText + 1);
        if (headerText.indexOf("Messages") == -1) {
            return false;
        }
        if (line2Format.startsWith("l-")) {
            StringBuffer sb = new StringBuffer(line2);
            for (int i = 2; i < startOfHeaderText; ++i) {
                if (sb.charAt(i) == '-') continue;
                return false;
            }
            for (int j = endOfHeaderText + 1; j < 79; ++j) {
                if (sb.charAt(j) == '-') continue;
                return false;
            }
            if (!line2.endsWith("-|")) {
                return false;
            }
        }
        return true;
    }

    private boolean isLineAllGraphics(int line, int startCol, int endCol) throws Exception {
        String boxTitle = this.getBoxTitleText(line, startCol, endCol);
        return boxTitle.length() == 0;
    }

    private MarkerPosition[] findSurroundingBox() throws Exception {
        return this.findSurroundingBox(this.getCursorLine(), this.getCursorCol());
    }

    private MarkerPosition[] findSurroundingBox(int startingLine, int startingCol) throws Exception {
        int topLine = -1;
        int bottomLine = -1;
        int leftCol = -1;
        int rightCol = -1;
        if (startingLine == 0) {
            startingLine = 2;
            startingCol = 2;
        }
        rightCol = (leftCol = this.lookForLeftSide(startingLine, startingCol)) == 0 ? 79 : this.lookForRightSide(startingLine, startingCol);
        if (leftCol == -1 || rightCol == -1 || leftCol >= rightCol) {
            throw new Exception("Box Not Found");
        }
        topLine = this.lookForTopLine(startingLine, leftCol);
        bottomLine = this.lookForBottomLine(startingLine, leftCol);
        if (topLine == -1 || bottomLine == -1) {
            throw new Exception("Box Not Found");
        }
        if (topLine >= bottomLine) {
            throw new Exception("Invalid Box Coordinate");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[topLine], leftCol, 'l')) {
            throw new Exception("upper left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[topLine], rightCol, 'k')) {
            throw new Exception("upper right corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[bottomLine], leftCol, 'm')) {
            throw new Exception("bottom left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[bottomLine], rightCol, 'j')) {
            throw new Exception("bottom right corner invalid");
        }
        String boxTitleText = this.getBoxTitleText(topLine, leftCol, rightCol);
        if (boxTitleText.length() == 0 && (leftCol != 0 || rightCol != 79)) {
            return this.findSurroundingBox(topLine - 1, startingCol);
        }
        MarkerPosition upperLeftCorner = new MarkerPosition(topLine, leftCol);
        MarkerPosition upperRightCorner = new MarkerPosition(topLine, rightCol);
        MarkerPosition lowerLeftCorner = new MarkerPosition(bottomLine, leftCol);
        MarkerPosition lowerRightCorner = new MarkerPosition(bottomLine, rightCol);
        return new MarkerPosition[]{upperLeftCorner, upperRightCorner, lowerLeftCorner, lowerRightCorner};
    }

    private String getBoxTitleText(int line, int start, int end) throws Exception {
        if (line < 0 || line > 23) {
            throw new Exception("line number out of range");
        }
        if (BVt100.firstIndexOf(this.screenBuffer.formatBuffers[line], start, 'l') == start && BVt100.firstIndexOf(this.screenBuffer.formatBuffers[line], start, 'k') == end) {
            int endOfHeader;
            int startOfHeader = BVt100.firstIndexOf(this.screenBuffer.formatBuffers[line], start + 1, 'B');
            if (startOfHeader == -1 || startOfHeader > end) {
                return "";
            }
            for (endOfHeader = startOfHeader; BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[line], endOfHeader, 'B') && endOfHeader < 80; ++endOfHeader) {
            }
            return this.screenBuffer.stringBuffers[line].substring(startOfHeader, endOfHeader);
        }
        throw new Exception("not a box header line");
    }

    private static int firstIndexOf(StringBuffer sb, int start, char charToFind) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != charToFind) continue;
            return i;
        }
        return -1;
    }

    private String getButtonName() throws Exception {
        int cursorLine = this.getCursorLine();
        int cursorCol = this.getCursorCol();
        int topLine = -1;
        int bottomLine = -1;
        int leftCol = -1;
        int rightCol = -1;
        if (cursorLine == 0) {
            cursorLine = 2;
            cursorCol = 2;
        }
        rightCol = (leftCol = this.lookForLeftSide(cursorLine, cursorCol)) == 0 ? 79 : this.lookForRightSide(cursorLine, cursorCol);
        if (leftCol == -1 || rightCol == -1 || leftCol >= rightCol) {
            throw new Exception("Left/Right of button box Not Found");
        }
        topLine = this.lookForTopLine(cursorLine, leftCol);
        bottomLine = this.lookForBottomLine(cursorLine, leftCol);
        if (topLine == -1 || bottomLine == -1) {
            throw new Exception("Top/Bottom of button box Not Found");
        }
        if (topLine >= bottomLine) {
            throw new Exception("Invalid Box Coordinate");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[topLine], leftCol, 'l')) {
            throw new Exception("upper left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[topLine], rightCol, 'k')) {
            throw new Exception("upper right corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[bottomLine], leftCol, 'm')) {
            throw new Exception("bottom left corner invalid");
        }
        if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[bottomLine], rightCol, 'j')) {
            throw new Exception("bottom right corner invalid");
        }
        String title = this.getBoxTitleText(topLine, leftCol, rightCol);
        if (title.length() != 0) {
            throw new Exception("button has a title");
        }
        String buttonName = this.getFullLine(cursorLine);
        buttonName = buttonName.substring(leftCol + 1, rightCol).trim();
        return buttonName;
    }

    private int lookForLeftSide(int startingLine, int startingCol) {
        if (startingLine == -1 || startingCol == -1) {
            return -1;
        }
        for (int col = startingCol; col > -1; --col) {
            if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[startingLine], col, '|')) continue;
            for (int line = startingLine; line > 0; --line) {
                if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[line], col, 'l')) continue;
                int indexOfUrc = col;
                for (int i = col; i < 80; ++i) {
                    indexOfUrc = i;
                    if (BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[line], i, 'k')) break;
                }
                if (indexOfUrc < startingCol) continue;
                return col;
            }
        }
        return -1;
    }

    private int lookForRightSide(int startingLine, int startingCol) {
        if (startingLine == -1 || startingCol == -1 || startingCol > 79) {
            return -1;
        }
        for (int col = startingCol; col < 80; ++col) {
            if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[startingLine], col, '|')) continue;
            for (int line = startingLine; line > 0; --line) {
                if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[line], col, 'k')) continue;
                return col;
            }
        }
        return -1;
    }

    private int lookForTopLine(int startingLine, int leftCol) {
        if (startingLine == -1 || leftCol == -1) {
            return -1;
        }
        for (int line = startingLine; line > 0; --line) {
            if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[line], leftCol, 'l')) continue;
            return line;
        }
        return -1;
    }

    private int lookForBottomLine(int startingLine, int leftCol) {
        if (startingLine == -1 || leftCol == -1) {
            return -1;
        }
        for (int line = startingLine; line < 24; ++line) {
            if (!BVt100.checkForCharacterInBuffer(this.screenBuffer.formatBuffers[line], leftCol, 'm')) continue;
            return line;
        }
        return -1;
    }

    private int getNextNonBlankLine(int fromLine) {
        if (fromLine > this.screenBuffer.stringBuffers.length - 1) {
            return -1;
        }
        for (int i = fromLine + 1; i < this.screenBuffer.stringBuffers.length; ++i) {
            if (this.getFullLine(i).substring(1, 79).trim().length() <= 0) continue;
            return i;
        }
        return -1;
    }

    private int validateViewEditConnectLogout() {
        if (this.isLine0ViewEditConnectLogout()) {
            int indexOfCategoryEnd;
            int cursorLine = this.getCursorPosition().getLine();
            if (cursorLine == 0) {
                return 2;
            }
            String formatLine0 = this.getFormatLine(0);
            int indexOfCategoryStart = formatLine0.indexOf(78);
            if (indexOfCategoryStart == -1) {
                return 0;
            }
            for (indexOfCategoryEnd = indexOfCategoryStart; formatLine0.charAt(indexOfCategoryEnd) == 'N' && indexOfCategoryEnd < 80; ++indexOfCategoryEnd) {
            }
            String categoryName = this.getFullLine(0).substring(indexOfCategoryStart, indexOfCategoryEnd);
            if (categoryName.equals("View")) {
                return 12;
            }
            if (categoryName.equals("Edit")) {
                return 13;
            }
        }
        return 0;
    }

    private int validateFileEditSearchCheckTools() {
        if (this.isLine0FileEditSearchCheckTools()) {
            int indexOfCategoryEnd;
            int cursorLine = this.getCursorPosition().getLine();
            if (cursorLine == 0) {
                return 3;
            }
            String formatLine0 = this.getFormatLine(0);
            int indexOfCategoryStart = formatLine0.indexOf(78);
            if (indexOfCategoryStart == -1) {
                return 0;
            }
            for (indexOfCategoryEnd = indexOfCategoryStart; indexOfCategoryEnd < 80 && formatLine0.charAt(indexOfCategoryEnd) == 'N'; ++indexOfCategoryEnd) {
            }
            String categoryName = this.getFullLine(0).substring(indexOfCategoryStart, indexOfCategoryEnd);
            if (categoryName.equals("File")) {
                return 62;
            }
            if (categoryName.equals("Edit")) {
                return 63;
            }
            if (categoryName.equals("Search")) {
                return 64;
            }
            if (categoryName.equals("Tools")) {
                return 65;
            }
        }
        return 0;
    }

    private int validateCursorIsInCommandLineArea() {
        try {
            if (!this.isLine1Command()) {
                return 0;
            }
            MarkerPosition[] corners = this.findSurroundingBox();
            if (this.isLine0ViewEditConnectLogout() && corners[0].line == 1 && corners[0].column == 0 && corners[1].line == 1 && corners[1].column == 79 && corners[2].line == 21 && corners[2].column == 0 && corners[3].line == 21 && corners[3].column == 79) {
                return 4;
            }
            if (corners[0].line == 1 && corners[0].column == 0 && corners[1].line == 1 && corners[1].column == 79 && corners[2].line == 8 && corners[2].column == 0 && corners[3].line == 8 && corners[3].column == 79) {
                return 73;
            }
            if (corners[0].line == 9 && corners[0].column == 0 && corners[1].line == 9 && corners[1].column == 79 && corners[2].line == 21 && corners[2].column == 0 && corners[3].line == 21 && corners[3].column == 79) {
                return 74;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    private int validateOpenDialog() {
        String dialogTitle;
        try {
            MarkerPosition[] corners = this.findSurroundingBox();
            dialogTitle = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
        }
        catch (Exception e) {
            return 0;
        }
        if (dialogTitle.indexOf("Open a User") != -1) {
            try {
                if (this.getBoxTitleText(2, 0, 79).startsWith("User - ")) {
                    if (this.isLine0ViewEditConnectLogout()) {
                        return 40;
                    }
                    return 0;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return 38;
        }
        if (dialogTitle.indexOf("Open a Point") != -1) {
            if (this.isLine0ViewEditConnectLogout()) {
                try {
                    if (this.getBoxTitleText(2, 2, 79).startsWith("Point - ")) {
                        return 49;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return 48;
            }
            try {
                if (this.getBoxTitleText(2, 2, 79).startsWith("Point - ")) {
                    return 85;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return 67;
        }
        if (dialogTitle.indexOf("Open a System Variable") != -1) {
            if (this.isLine0ViewEditConnectLogout()) {
                return 58;
            }
            return 69;
        }
        if (dialogTitle.indexOf("Open a File") != -1) {
            try {
                if (this.getBoxTitleText(2, 0, 79).startsWith("File - ")) {
                    return 60;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.isLine0ViewEditConnectLogout()) {
                return 59;
            }
            return 91;
        }
        if (dialogTitle.indexOf("Open a Commport") != -1) {
            return 92;
        }
        if (dialogTitle.indexOf("Open a Controller") != -1) {
            return 93;
        }
        if (dialogTitle.indexOf("Open an Infinet Controller") != -1) {
            return 94;
        }
        if (dialogTitle.equals("Controller")) {
            return 93;
        }
        if (dialogTitle.indexOf("System Time") != -1) {
            try {
                if (this.getButtonName().equals("OK")) {
                    return 96;
                }
                if (this.getButtonName().equals("CANCEL")) {
                    return 97;
                }
            }
            catch (Exception e) {
                return 95;
            }
        }
        if (dialogTitle.indexOf("ERROR : Invalid Time Value") != -1) {
            try {
                if (this.getButtonName().equals("OK")) {
                    return 134;
                }
                if (this.getButtonName().equals("CANCEL")) {
                    return 135;
                }
            }
            catch (Exception e) {
                return 95;
            }
        }
        if (dialogTitle.indexOf("Open a Person") != -1) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                    return 104;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 98;
        }
        if (dialogTitle.indexOf("Open an Area") != -1) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Area - ")) {
                    return 105;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 99;
        }
        if (dialogTitle.indexOf("Open a Door") != -1) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Door - ")) {
                    return 106;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 100;
        }
        return 0;
    }

    private int validateControllerOptions() {
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        try {
            if (!this.isLineAllGraphics(1, 3, 79)) {
                return 0;
            }
        }
        catch (Exception e1) {
            return 0;
        }
        String dialogTitle = this.getFullLine(2).substring(4, 79).trim();
        if (dialogTitle.startsWith("Controller Options")) {
            return 128;
        }
        return 0;
    }

    private int validateEditUser() {
        String dialogTitle;
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        try {
            MarkerPosition[] corners = this.findSurroundingBox();
            dialogTitle = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
        }
        catch (Exception e) {
            return 0;
        }
        if (dialogTitle.indexOf("User - ") != -1) {
            return 39;
        }
        if (dialogTitle.indexOf("Security Level") != -1) {
            return 39;
        }
        if (dialogTitle.indexOf("Delete a User") != -1) {
            try {
                String buttonName = this.getButtonName();
                if (buttonName.indexOf("OK") != -1) {
                    return 42;
                }
                if (buttonName.indexOf("CANCEL") != -1) {
                    return 43;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 41;
        }
        if (dialogTitle.indexOf("Teach") != -1) {
            try {
                String buttonName = this.getButtonName();
                if (buttonName.indexOf("OK") != -1) {
                    return 45;
                }
                if (buttonName.indexOf("CANCEL") != -1) {
                    return 46;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 44;
        }
        return 0;
    }

    private int validateEditController() {
        String dialogTitle;
        MarkerPosition[] corners;
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        try {
            corners = this.findSurroundingBox();
            dialogTitle = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
        }
        catch (Exception e) {
            return 0;
        }
        if (dialogTitle.indexOf("Controller - ") != -1) {
            return 129;
        }
        if (dialogTitle.indexOf("Commport - ") != -1 || dialogTitle.indexOf("DefaultMode") != -1 || dialogTitle.indexOf("Baud") != -1 || dialogTitle.indexOf("FlowControl") != -1) {
            return 133;
        }
        if (dialogTitle.indexOf("Details") != -1) {
            try {
                dialogTitle = this.getBoxTitleText(corners[0].line - 1, corners[0].column, corners[1].column);
                if (dialogTitle.indexOf("Controller - ") != -1) {
                    return 130;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dialogTitle.indexOf("TCP/IP") != -1) {
            try {
                dialogTitle = this.getBoxTitleText(2, 0, 79);
                if (dialogTitle.indexOf("Controller - ") != -1) {
                    return 131;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private int validateEditPerson() {
        String dialogTitle;
        MarkerPosition[] corners;
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        try {
            corners = this.findSurroundingBox();
            dialogTitle = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
        }
        catch (Exception e) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                    return 107;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        if (dialogTitle.startsWith("State")) {
            try {
                if (this.getBoxTitleText(1, 0, 79).startsWith("Person - ")) {
                    return 101;
                }
                if (this.getBoxTitleText(1, 0, 79).startsWith("Area - ")) {
                    return 102;
                }
                if (this.getBoxTitleText(1, 0, 79).startsWith("Door - ")) {
                    return 103;
                }
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (dialogTitle.startsWith("Person - ")) {
            return 101;
        }
        if (dialogTitle.startsWith("Area - ")) {
            return 102;
        }
        if (dialogTitle.startsWith("AntiPassback Action")) {
            return 102;
        }
        if (dialogTitle.startsWith("Door - ")) {
            return 103;
        }
        if (dialogTitle.startsWith("Access Validation")) {
            if (this.getFullLine(3).indexOf("Exit Reader") != -1) {
                return 116;
            }
            return 113;
        }
        if (dialogTitle.startsWith("Reader Options")) {
            if (this.getFullLine(3).indexOf("Exit Reader") != -1) {
                return 117;
            }
            return 114;
        }
        if (dialogTitle.startsWith("Card Format")) {
            return 120;
        }
        if (dialogTitle.length() == 0) {
            try {
                dialogTitle = this.getBoxTitleText(corners[0].line - 1, corners[0].column, corners[1].column);
                if (dialogTitle.startsWith("Person - ")) {
                    String line3 = this.getFullLine(3);
                    if (line3.indexOf("Details 1") != -1) {
                        return 110;
                    }
                    if (line3.indexOf("Details 2") != -1) {
                        return 111;
                    }
                    if (line3.indexOf("Details 3") != -1) {
                        return 112;
                    }
                    return 107;
                }
                if (dialogTitle.startsWith("Door - ")) {
                    StringTokenizer tkn;
                    String line3 = this.getFullLine(3);
                    if (line3.indexOf("Entry Reader Details1") != -1) {
                        return 114;
                    }
                    if (line3.indexOf("Entry Reader Details2") != -1) {
                        return 115;
                    }
                    if (line3.indexOf("Entry Reader") != -1) {
                        return 113;
                    }
                    if (line3.indexOf("Exit Reader Details1") != -1) {
                        return 117;
                    }
                    if (line3.indexOf("Exit Reader Details2") != -1) {
                        return 118;
                    }
                    if (line3.indexOf("Exit Reader") != -1) {
                        return 116;
                    }
                    if (line3.indexOf("Details1") != -1) {
                        return 119;
                    }
                    if (line3.indexOf("Details2") != -1) {
                        return 120;
                    }
                    if (line3.indexOf("Details3") != -1) {
                        return 121;
                    }
                    if (line3.indexOf("Details 3") != -1) {
                        return 121;
                    }
                    if (line3.substring(1, 79).trim().length() == 0 && (tkn = new StringTokenizer(this.getFullLine(5).substring(1, 79))).nextToken().equals("Port")) {
                        return 122;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private int validateEditPoint() {
        boolean fileMenus;
        block43: {
            fileMenus = false;
            if (this.isLine0FileEditSearchCheckTools()) {
                fileMenus = true;
            } else {
                if (!this.isLine1Command()) {
                    return 0;
                }
                fileMenus = false;
            }
            try {
                if (this.isLineAllGraphics(2, 0, 79)) {
                    StringTokenizer tkn;
                    MarkerPosition[] corners = this.findSurroundingBox();
                    if (corners[0].line == 2 && corners[0].column == 0 && (tkn = new StringTokenizer(this.getFullLine(5).substring(1, 79))).nextToken().equals("Port")) {
                        if (fileMenus) {
                            return 79;
                        }
                        return 51;
                    }
                }
            }
            catch (Exception corners) {
                // empty catch block
            }
            try {
                if (this.isLine2Logs()) {
                    if (fileMenus) {
                        return 80;
                    }
                    return 55;
                }
            }
            catch (Exception corners) {
                // empty catch block
            }
            try {
                if (!this.isLine2Triggers()) break block43;
                try {
                    if (this.getButtonName().equals("OK")) {
                        if (fileMenus) {
                            return 81;
                        }
                        return 57;
                    }
                }
                catch (Exception corners) {
                    // empty catch block
                }
                if (fileMenus) {
                    return 82;
                }
                return 56;
            }
            catch (Exception corners) {
                // empty catch block
            }
        }
        boolean line2Point = false;
        try {
            line2Point = this.isLine2Point();
        }
        catch (Exception tkn) {
            // empty catch block
        }
        if (line2Point) {
            String buttonName;
            String dialogTitle;
            try {
                if (this.isLineAllGraphics(3, 0, 79)) {
                    int nonBlankLine = this.getNextNonBlankLine(3);
                    StringTokenizer tkn = new StringTokenizer(this.getFullLine(nonBlankLine).substring(1, 79));
                    if (tkn.nextToken().equals("Description")) {
                        int dialogMode = this.validateYesNoDialogBox();
                        if (dialogMode == 18) {
                            if (fileMenus) {
                                return 83;
                            }
                            return 52;
                        }
                        if (dialogMode == 19) {
                            if (fileMenus) {
                                return 84;
                            }
                            return 53;
                        }
                    }
                    if (fileMenus) {
                        return 78;
                    }
                    return 50;
                }
            }
            catch (Exception nonBlankLine) {
                // empty catch block
            }
            try {
                MarkerPosition[] corners = this.findSurroundingBox();
                dialogTitle = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
            }
            catch (Exception e) {
                return 0;
            }
            if (dialogTitle.startsWith("Point - ") || dialogTitle.startsWith("System Variable - ")) {
                if (fileMenus) {
                    return 68;
                }
                return 47;
            }
            if (dialogTitle.indexOf("Type") != -1 || dialogTitle.indexOf("State") != -1 || dialogTitle.indexOf("Electrical Type") != -1) {
                if (fileMenus) {
                    return 68;
                }
                return 47;
            }
            if (dialogTitle.indexOf("Open a Point") != -1) {
                if (fileMenus) {
                    return 85;
                }
                return 49;
            }
            try {
                buttonName = this.getButtonName();
            }
            catch (Exception e) {
                return 0;
            }
            if (buttonName.equals("OK")) {
                if (fileMenus) {
                    return 86;
                }
                return 54;
            }
        }
        return 0;
    }

    private int validateSearch() {
        String buttonName;
        String title = "";
        if (!this.isLine0FileEditSearchCheckTools()) {
            return 0;
        }
        try {
            MarkerPosition[] corners = this.findSurroundingBox();
            title = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
        }
        catch (Exception e) {
            return 0;
        }
        if (title.startsWith("Search :")) {
            try {
                buttonName = this.getButtonName();
                if (buttonName.equals("OK")) {
                    return 124;
                }
                if (buttonName.equals("CANCEL")) {
                    return 125;
                }
            }
            catch (Exception e) {
                return 123;
            }
        }
        if (title.startsWith("COPY ERROR") || title.startsWith("CLEAR ERROR") || title.startsWith("CUT ERROR")) {
            try {
                buttonName = this.getButtonName();
                if (buttonName.equals("OK")) {
                    return 126;
                }
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    private int validateEditFile() {
        if (this.isLine0ViewEditConnectLogout()) {
            try {
                if (this.isLine1Command() && this.isLine2File()) {
                    return 61;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        if (this.isLine0FileEditSearchCheckTools()) {
            MarkerPosition[] corners;
            try {
                corners = this.findSurroundingBox();
            }
            catch (Exception e) {
                return 0;
            }
            if (corners[0].line == 1 && corners[0].column == 0 && corners[1].line == 1 && corners[1].column == 79 && corners[2].line == 21 && corners[2].column == 0 && corners[3].line == 21 && corners[3].column == 79) {
                if (this.getFullLine(22).startsWith("SPACE =")) {
                    return 127;
                }
                return 66;
            }
        }
        return 0;
    }

    private int validateBuildingListPleaseWait() {
        if (this.getFullLine(22).substring(1).trim().startsWith("Building list - please wait")) {
            return 139;
        }
        return 0;
    }

    private int validateSelectionBox() {
        if (this.getFullLine(22).trim().startsWith("Cursor keys scroll")) {
            return 132;
        }
        return 0;
    }

    private int validateOpenAConnectionDialog() {
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        int startCol = -1;
        int endCol = -1;
        int startRow = -1;
        int endRow = -1;
        for (int lineNum = 2; lineNum < 21; ++lineNum) {
            String formatLine = this.getFormatLine(lineNum);
            String textLine = this.getFullLine(lineNum);
            if (textLine.indexOf("Open a Connection") != -1 && (startCol = formatLine.indexOf(108, 10)) != -1 && (endCol = formatLine.indexOf(107, startCol)) != -1) {
                startRow = lineNum;
            }
            if (startRow <= 0 || formatLine.indexOf(109, startCol) != startCol || formatLine.indexOf(106, startCol) != endCol) continue;
            endRow = lineNum;
        }
        if (endRow == -1 || startRow == -1 || startCol == -1 || endCol == -1) {
            return 0;
        }
        if (this.getCursorLine() > startRow && this.getCursorLine() < endRow && this.getCursorCol() > startCol && this.getCursorCol() < endCol) {
            return 14;
        }
        return 0;
    }

    private int validateViewMessages() {
        boolean line3graphics;
        if (!this.isLine2Messages()) {
            return 0;
        }
        try {
            line3graphics = this.isLineAllGraphics(3, 1, 78);
        }
        catch (Exception e) {
            return 0;
        }
        if (!line3graphics) {
            return 0;
        }
        String line18Format = this.getFormatLine(18);
        int startOfClearBox = line18Format.indexOf(108);
        if (startOfClearBox == -1) {
            return 0;
        }
        int endOfClearBox = line18Format.indexOf(107, startOfClearBox + 1);
        if (endOfClearBox == -1) {
            return 0;
        }
        int startOfExitBox = line18Format.indexOf(108, endOfClearBox + 1);
        if (startOfExitBox == -1) {
            return 0;
        }
        int endOfExitBox = line18Format.indexOf(107, startOfExitBox + 1);
        if (endOfExitBox == -1) {
            return 0;
        }
        String line19 = this.getFullLine(19);
        if (line19.substring(startOfClearBox + 1, endOfClearBox).indexOf("CLEAR") == -1) {
            return 0;
        }
        if (line19.substring(startOfExitBox + 1, endOfExitBox).indexOf("EXIT") == -1) {
            return 0;
        }
        int cursorLine = this.getCursorLine();
        int cursorCol = this.getCursorCol();
        if (cursorLine > 3 && cursorLine < 17) {
            if (cursorCol > 1 && cursorCol < 78) {
                if (this.isLine0ViewEditConnectLogout()) {
                    return 21;
                }
                return 70;
            }
        } else if (cursorLine == 19) {
            if (cursorCol > startOfClearBox && cursorCol < endOfClearBox) {
                if (this.isLine0ViewEditConnectLogout()) {
                    return 22;
                }
                return 71;
            }
            if (cursorCol > startOfExitBox && cursorCol < endOfExitBox) {
                if (this.isLine0ViewEditConnectLogout()) {
                    return 23;
                }
                return 72;
            }
        }
        return 0;
    }

    private int validateViewSummaryNoneDefinedDialog() {
        if (!this.isLine0ViewEditConnectLogout()) {
            return 0;
        }
        if (!this.isLine1Command()) {
            return 0;
        }
        String dialogTitle = "";
        try {
            MarkerPosition[] corners = this.findSurroundingBox();
            dialogTitle = this.getBoxTitleText(corners[0].line, corners[0].column, corners[1].column);
            if (dialogTitle.indexOf("View Summary") != -1 && this.getButtonName().equals("OK")) {
                return 17;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private int validateLogoutWarningDialog() {
        int mode = 0;
        if (!this.isLine0ViewEditConnectLogout()) {
            return mode;
        }
        if (!this.isLine1Command()) {
            return mode;
        }
        int startCol = -1;
        int endCol = -1;
        int startOfYesBox = -1;
        int endOfYesBox = -1;
        int startOfNoBox = -1;
        int endOfNoBox = -1;
        for (int lineNum = 8; lineNum < 16; ++lineNum) {
            String lineToCheck = this.getFormatLine(lineNum);
            if (lineNum == 8) {
                startCol = lineToCheck.indexOf(108, 1);
                if (startCol == -1) {
                    return 0;
                }
                endCol = lineToCheck.indexOf(107, startCol + 1);
                if (endCol == -1) {
                    return 0;
                }
                if (this.getFullLine(lineNum).substring(startCol + 1, endCol).indexOf("Logout WARNING") == -1) {
                    return 0;
                }
            }
            if (lineNum > 8 && lineNum < 15) {
                if (lineToCheck.charAt(startCol) != '|') {
                    return 0;
                }
                if (lineToCheck.charAt(endCol) != '|') {
                    return 0;
                }
                if (lineToCheck.indexOf(108, startCol + 1) != -1) {
                    startOfYesBox = lineToCheck.indexOf(108, startCol + 1);
                    endOfYesBox = lineToCheck.indexOf(107, startOfYesBox + 1);
                    startOfNoBox = lineToCheck.indexOf(108, endOfYesBox + 1);
                    endOfNoBox = lineToCheck.indexOf(107, startOfNoBox + 1);
                }
            }
            if (lineNum == 15) {
                if (lineToCheck.charAt(startCol) != 'm') {
                    return 0;
                }
                if (lineToCheck.charAt(endCol) != 'j') {
                    return 0;
                }
            }
            if (lineNum != this.getCursorLine()) continue;
            if (startOfYesBox == -1 || endOfYesBox == -1 || startOfNoBox == -1 || endOfNoBox == -1) {
                return 0;
            }
            if (this.getFullLine(lineNum).substring(startOfYesBox, endOfYesBox).indexOf("YES") == -1) {
                return 0;
            }
            if (this.getFullLine(lineNum).substring(startOfNoBox, endOfNoBox).indexOf("NO") == -1) {
                return 0;
            }
            if (this.getCursorCol() > startOfYesBox && this.getCursorCol() < endOfYesBox) {
                mode = 15;
                continue;
            }
            if (this.getCursorCol() <= startOfNoBox || this.getCursorCol() >= endOfNoBox) continue;
            mode = 16;
        }
        return mode;
    }

    private int validateYesNoDialogBox() {
        String buttonName;
        try {
            buttonName = this.getButtonName();
        }
        catch (Exception e) {
            return 0;
        }
        if (buttonName.equalsIgnoreCase("YES")) {
            return 18;
        }
        if (buttonName.equalsIgnoreCase("NO")) {
            return 19;
        }
        return 0;
    }

    private int validateOKDialogBox() {
        MarkerPosition[] corners;
        try {
            corners = this.findSurroundingBox();
        }
        catch (Exception e) {
            return 0;
        }
        int mode = 0;
        int startOfOKBox = -1;
        int endOfOKBox = -1;
        for (int lineNum = 8; lineNum < 16; ++lineNum) {
            String formatLine = this.getFormatLine(lineNum);
            if (lineNum > corners[0].line && lineNum < corners[2].line) {
                if (formatLine.charAt(corners[0].column) != '|') {
                    return 0;
                }
                if (formatLine.charAt(corners[1].column) != '|') {
                    return 0;
                }
                if (formatLine.indexOf(108, corners[0].column + 1) != -1 && formatLine.indexOf(108, (endOfOKBox = formatLine.indexOf(107, (startOfOKBox = formatLine.indexOf(108, corners[0].column + 1)) + 1)) + 1) != -1) {
                    return 0;
                }
            }
            if (lineNum != this.getCursorLine()) continue;
            if (startOfOKBox == -1 || endOfOKBox == -1) {
                return 0;
            }
            if (this.getFullLine(lineNum).substring(startOfOKBox, endOfOKBox).indexOf("OK") == -1) {
                return 0;
            }
            if (this.getCursorCol() <= startOfOKBox || this.getCursorCol() >= endOfOKBox) continue;
            mode = 20;
        }
        return mode;
    }

    private int validateView(int modeToVerify) {
        String displayName;
        int mode = 0;
        try {
            displayName = this.getBoxTitleText(1, 0, 79);
        }
        catch (Exception e) {
            return 0;
        }
        String emptyLine = this.getFullLine(2);
        emptyLine = emptyLine.substring(1, emptyLine.length() - 2).trim();
        if (emptyLine.length() != 0) {
            return mode;
        }
        try {
            MarkerPosition[] corners = this.findSurroundingBox();
            if (corners[0].line != 1 || corners[0].column != 0 || corners[1].line != 1 || corners[1].column != 79 || corners[2].line != 21 || corners[2].column != 0 || corners[3].line != 21 || corners[3].column != 79) {
                return 0;
            }
        }
        catch (Exception e) {
            return 0;
        }
        String line4 = this.getFormatLine(4);
        for (int i = 1; i < 79; ++i) {
            if (line4.charAt(i) == '-') continue;
            return 0;
        }
        String header = this.getFullLine(3);
        switch (modeToVerify) {
            case 24: {
                if (displayName.indexOf("Point Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("Units") == -1) {
                    return 0;
                }
                if (header.indexOf("Type") == -1) {
                    return 0;
                }
                if (header.indexOf("C") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 24;
                }
                return 87;
            }
            case 25: {
                if (displayName.indexOf("Input Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("Units") == -1) {
                    return 0;
                }
                if (header.indexOf("C") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                return 25;
            }
            case 26: {
                if (displayName.indexOf("Output Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("Units") == -1) {
                    return 0;
                }
                if (header.indexOf("C") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                return 26;
            }
            case 27: {
                if (displayName.indexOf("Numeric Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("Units") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                return 27;
            }
            case 28: {
                if (displayName.indexOf("String Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                return 28;
            }
            case 29: {
                if (displayName.indexOf("System Variable Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 29;
                }
                return 90;
            }
            case 30: {
                if (displayName.indexOf("Date Time Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                return 30;
            }
            case 31: {
                if (displayName.indexOf("File Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Description") == -1) {
                    return 0;
                }
                if (header.indexOf("Type") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 31;
                }
                return 88;
            }
            case 32: {
                if (displayName.indexOf("Program Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Current Line") == -1) {
                    return 0;
                }
                if (header.indexOf("TD") == -1) {
                    return 0;
                }
                if (header.indexOf("TH") == -1) {
                    return 0;
                }
                if (header.indexOf("TM") == -1) {
                    return 0;
                }
                if (header.indexOf("TS") == -1) {
                    return 0;
                }
                if (header.indexOf("State") == -1) {
                    return 0;
                }
                if (this.isLine0ViewEditConnectLogout()) {
                    return 32;
                }
                return 89;
            }
            case 33: {
                if (displayName.indexOf("Infinet Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Port") == -1) {
                    return 0;
                }
                if (header.indexOf("Model") == -1) {
                    return 0;
                }
                if (header.indexOf("Serial Number") == -1) {
                    return 0;
                }
                if (header.indexOf("ID") == -1) {
                    return 0;
                }
                if (header.indexOf("Status") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                return 33;
            }
            case 34: {
                if (displayName.indexOf("Controller Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Model") == -1) {
                    return 0;
                }
                if (header.indexOf("ID") == -1) {
                    return 0;
                }
                if (header.indexOf("Status") == -1) {
                    return 0;
                }
                return 34;
            }
            case 35: {
                if (displayName.indexOf("Disabled Point Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                if (header.indexOf("Units") == -1) {
                    return 0;
                }
                if (header.indexOf("Type") == -1) {
                    return 0;
                }
                if (header.indexOf("C") == -1) {
                    return 0;
                }
                return 35;
            }
            case 36: {
                if (displayName.indexOf("Disabled System Variable Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Value") == -1) {
                    return 0;
                }
                return 36;
            }
            case 37: {
                if (displayName.indexOf("Disabled File Summary") == -1) {
                    return 0;
                }
                if (header.indexOf("Name") == -1) {
                    return 0;
                }
                if (header.indexOf("Description") == -1) {
                    return 0;
                }
                if (header.indexOf("Type") == -1) {
                    return 0;
                }
                return 37;
            }
        }
        return 0;
    }

    private int validateLoginDialog() {
        MarkerPosition[] corners;
        int mode = 0;
        if (!this.isLine0ViewEditConnectLogout()) {
            return mode;
        }
        if (this.getFullLine(1).trim().length() != 0) {
            return mode;
        }
        try {
            corners = this.findSurroundingBox();
        }
        catch (Exception e) {
            return 0;
        }
        String line = this.getFullLine(this.getCursorLine()).substring(corners[0].column + 1, corners[1].column).trim();
        if (line.startsWith("User Name")) {
            return 10;
        }
        if (line.startsWith("Password")) {
            return 11;
        }
        return 0;
    }

    private int validateSaveOrReloadInfinet() {
        if (this.getFullLine(0).toUpperCase().indexOf("reload -o".toUpperCase()) != -1 && this.getFullLine(1).startsWith(" Enter any key within 60 seconds to start.") && this.getFullLine(2).startsWith(" [<ESC> at any point aborts]") && this.getCursorLine() < 20) {
            return 140;
        }
        if (this.getFullLine(0).toUpperCase().indexOf("save infinet".toUpperCase()) != -1 && this.getFullLine(1).startsWith(" Enter any key within 60 seconds to start.") && this.getFullLine(2).startsWith(" [<ESC> at any point aborts]")) {
            if (this.getCursorLine() == 3) {
                return 136;
            }
            return 138;
        }
        if (this.getFullLine(this.getCursorLine() - 1).startsWith(" EndOfReload")) {
            return 137;
        }
        for (int i = 0; i < 80; ++i) {
            if (this.getFormatLine(0).charAt(i) == 'N' || this.getFormatLine(23).charAt(i) == 'N') continue;
            return 0;
        }
        boolean foundchar = false;
        for (int i = 0; i < 23; ++i) {
            String line = this.getFullLine(i);
            if (line.startsWith("---")) {
                this.network.getLogger().severe(line);
                this.network.pingFail(line);
                return 1;
            }
            if (line.charAt(0) == '|' || line.charAt(79) == '|') {
                return 0;
            }
            for (int j = 0; j < 80; ++j) {
                if (line.charAt(j) == ' ') continue;
                foundchar = true;
            }
        }
        if (!foundchar) {
            return 1;
        }
        return 138;
    }

    public String getRecovery() {
        return this.getRecovery(this.getMode());
    }

    public String getRecovery(int mode) {
        switch (mode) {
            case 0: {
                return "\u001a";
            }
            case 2: {
                return "\u001bOS";
            }
            case 4: {
                return "";
            }
            case 10: {
                return "\u001b6" + this.network.getNetworkDevice().getUserName() + "\t" + this.network.getNetworkDevice().getPassword() + "\r" + "\u001bOS";
            }
            case 11: {
                return "\u001b6\u001b[A\u001b6" + this.network.getNetworkDevice().getUserName() + "\t" + this.network.getNetworkDevice().getPassword() + "\r" + "\u001bOS";
            }
            case 19: {
                return "\u001b[D\r\u001bOS\u001bOS";
            }
            case 15: 
            case 22: {
                return "\t\r\u001bOS";
            }
            case 16: 
            case 17: 
            case 23: {
                return "\r\u001bOS";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 47: 
            case 48: 
            case 58: 
            case 59: 
            case 61: {
                return "\u001bOS\u001bOS";
            }
            case 40: 
            case 41: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 60: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 42: 
            case 45: {
                return "\t\r\u001bOS\u001bOS";
            }
            case 18: 
            case 20: {
                return "\r";
            }
            case 43: 
            case 46: {
                return "\r\u001bOS\u001bOS";
            }
            case 52: {
                return "\r\u001bOS\u001bOS\u001bOS";
            }
            case 53: {
                return "\u001b[D\r\u001bOS\u001bOS\u001bOS";
            }
            case 55: 
            case 56: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 57: {
                return "\r\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 3: {
                return "FQ";
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                return "\u001bOSFQ";
            }
            case 74: {
                return "\u001bOS\u001bOSFQ";
            }
            case 75: {
                return "\t\r\u001bOS";
            }
            case 76: {
                return "\r\u001bOS";
            }
            case 77: {
                return "\rFQ";
            }
            case 78: 
            case 79: {
                return "\u001bOS\u001bOSFQ";
            }
            case 80: 
            case 82: {
                return "\u001bOS\u001bOS\u001bOSFQ";
            }
            case 81: {
                return "\r\u001bOS\u001bOS\u001bOSFQ";
            }
            case 83: {
                return "\r\u001bOS\u001bOSFQ";
            }
            case 84: {
                return "\u001b[D\r\u001bOS\u001bOSFQ";
            }
            case 85: {
                return "\u001bOS\u001bOS\u001bOSFQ";
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return "\u001bOSFQ";
            }
            case 86: {
                return "\r\u001bOSFQ";
            }
            case 68: {
                return "\u001bOSFQ";
            }
            case 91: {
                return "\u001bOS\u001bOSFQ";
            }
            case 92: 
            case 93: 
            case 94: {
                return "\u001bOS\u001bOS";
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return "\u001bOS\u001bOS";
            }
            case 134: {
                return "\t\r\u001bOS";
            }
            case 135: {
                return "\r\u001bOS";
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 108: {
                if (this.getFullLine(3).indexOf("Card Information") != -1) {
                    return "\r\u001bOS\u001bOS\u001bOS";
                }
                return "\r\u001bOS\u001bOS";
            }
            case 109: {
                if (this.getFullLine(3).indexOf("Card Information") != -1) {
                    return "\t\r\u001bOS\u001bOS\u001bOS";
                }
                return "\t\r\u001bOS\u001bOS";
            }
            case 110: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 111: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 112: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 113: 
            case 116: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 114: 
            case 117: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 115: 
            case 118: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 119: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 120: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 121: {
                return "\u001bOS\u001bOS\u001bOS\u001bOS\u001bOS";
            }
            case 122: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 123: 
            case 124: 
            case 125: {
                return "\u001bOS\u001bOSFQ";
            }
            case 126: {
                return "\r\u001bOSFQ";
            }
            case 127: {
                return "\u001bOS\u001bOSFQ";
            }
            case 1: {
                return "window";
            }
            case 129: 
            case 133: {
                return "\u001bOS\u001bOS";
            }
            case 128: 
            case 130: 
            case 131: {
                return "\u001bOS\u001bOS\u001bOS";
            }
            case 132: {
                return "\u001bOS";
            }
            case 136: 
            case 138: {
                return String.valueOf('\u001b');
            }
            case 137: {
                return "\r";
            }
            case 139: {
                return "";
            }
        }
        return "\t\u001bOS";
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void resetInsertMode() {
        this.insertMode = false;
    }

    public void clearScreenBuffer() {
        this.screenBuffer.clearBuffer();
    }

    public boolean isBell() {
        return this.bell;
    }

    class ScreenBuffer {
        CursorPosition pos = new CursorPosition(0, 0);
        StringBuffer[] stringBuffers = new StringBuffer[24];
        StringBuffer[] formatBuffers = new StringBuffer[24];

        ScreenBuffer() {
            for (int i = 0; i < this.stringBuffers.length; ++i) {
                this.stringBuffers[i] = new StringBuffer();
                this.formatBuffers[i] = new StringBuffer();
                for (int j = 0; j < 80; ++j) {
                    this.stringBuffers[i].append(' ');
                    this.formatBuffers[i].append('N');
                }
            }
        }

        public void clearBuffer() {
            for (int i = 0; i < this.stringBuffers.length; ++i) {
                this.clearLine(i);
            }
            this.pos.setCol(0);
            this.pos.setLine(0);
            BVt100.this.getNetwork().refresh();
        }

        public void clearLine(int line) {
            for (int j = 0; j < this.stringBuffers[line].length(); ++j) {
                this.stringBuffers[line].setCharAt(j, ' ');
                this.formatBuffers[line].setCharAt(j, 'N');
            }
        }

        public void setContentLine(int line, String text) {
            for (int i = 0; i < 80; ++i) {
                try {
                    this.stringBuffers[line].setCharAt(i, text.charAt(i));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.stringBuffers[line].setCharAt(i, ' ');
                }
            }
        }

        public void setFormatLine(int line, String text) {
            for (int i = 0; i < 80; ++i) {
                try {
                    this.formatBuffers[line].setCharAt(i, text.charAt(i));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    this.formatBuffers[line].setCharAt(i, 'N');
                }
            }
        }

        public void scrollBufferUp() {
            for (int i = 1; i < this.stringBuffers.length; ++i) {
                this.stringBuffers[i - 1] = this.stringBuffers[i];
                this.formatBuffers[i - 1] = this.formatBuffers[i];
            }
            this.stringBuffers[this.stringBuffers.length - 1] = new StringBuffer();
            this.formatBuffers[this.formatBuffers.length - 1] = new StringBuffer();
            for (int j = 0; j < 80; ++j) {
                this.stringBuffers[this.stringBuffers.length - 1].append(' ');
                this.formatBuffers[this.formatBuffers.length - 1].append('N');
            }
        }

        public void write(char newChar, int line, int col) {
            if (line < 0) {
                return;
            }
            if (line > 23) {
                return;
            }
            if (col < 0) {
                return;
            }
            if (col > 79) {
                return;
            }
            this.stringBuffers[line].setCharAt(col, newChar);
        }

        public void writeFormat(char newChar, int line, int col) {
            if (line < 0) {
                return;
            }
            if (line > 23) {
                return;
            }
            if (col < 0) {
                return;
            }
            if (col > 79) {
                return;
            }
            this.formatBuffers[line].setCharAt(col, newChar);
        }

        public void dump() {
            System.out.println();
            System.out.println(this);
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < this.stringBuffers.length; ++i) {
                sb.append(this.stringBuffers[i].toString() + ":" + i + "\r\n");
            }
            for (i = 0; i < this.formatBuffers.length; ++i) {
                sb.append(this.formatBuffers[i].toString() + ":" + i + "\r\n");
            }
            sb.append("Cursor:" + this.pos).append("\r\n");
            sb.append("Mode:" + Vt100Const.cursorModes[BVt100.this.getMode()]);
            return sb.toString();
        }

        public CursorPosition getPos() {
            return this.pos;
        }

        public void setPos(CursorPosition pos) {
            this.pos = pos;
        }

        public void moveCursorToStartOfNextLine() {
            this.pos.setLine(this.pos.getLine() + 1);
            this.pos.setCol(0);
        }
    }
}

