/*
 * Decompiled with CFR 0.152.
 */
package tools.net.sourceforge.jtds.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import tools.net.sourceforge.jtds.tools.PacketLogger;

public class SqlForwarder {
    String host = "localhost";
    String logfile = null;
    int port = 1433;
    int listenPort = 1444;
    int lognum = 0;

    byte[] readPacket(InputStream input) throws IOException {
        byte[] hdr = new byte[8];
        int len = input.read(hdr);
        if (len < 8) {
            return null;
        }
        int packetlen = ((hdr[2] & 0xFF) << 8) + (hdr[3] & 0xFF);
        byte[] data = new byte[packetlen];
        while (len < packetlen) {
            len += input.read(data, len, packetlen - len);
        }
        for (int i = 0; i < 8; ++i) {
            data[i] = hdr[i];
        }
        return data;
    }

    SqlForwarder() {
    }

    void run() throws IOException {
        System.out.println("Listening on port " + this.listenPort + "; Connecting to " + this.host + " at port " + this.port);
        ServerSocket srv = new ServerSocket(this.listenPort);
        while (true) {
            Socket client = srv.accept();
            Socket server = new Socket(this.host, this.port);
            ConnectionThread t = new ConnectionThread(client, server);
            t.start();
        }
    }

    void parseArgs(String[] args) throws NumberFormatException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-server")) {
                this.host = args[++i];
                continue;
            }
            if (arg.equals("-port")) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-listen")) {
                this.listenPort = Integer.parseInt(args[++i]);
                continue;
            }
            if (!arg.equals("-log")) continue;
            this.logfile = args[++i];
        }
    }

    public static void main(String[] args) throws IOException {
        SqlForwarder app = new SqlForwarder();
        app.parseArgs(args);
        app.run();
    }

    class ConnectionThread
    extends Thread {
        Socket client;
        Socket server;

        ConnectionThread(Socket client, Socket server) {
            this.client = client;
            this.server = server;
        }

        @Override
        public void run() {
            try {
                byte[] data;
                InputStream[] input = new InputStream[]{this.client.getInputStream(), this.server.getInputStream()};
                OutputStream[] output = new OutputStream[]{this.server.getOutputStream(), this.client.getOutputStream()};
                PacketLogger log = SqlForwarder.this.logfile == null ? new PacketLogger("filter" + SqlForwarder.this.lognum++ + ".log") : new PacketLogger(SqlForwarder.this.logfile + SqlForwarder.this.lognum++ + ".log");
                int direction = 0;
                while ((data = SqlForwarder.this.readPacket(input[direction])) != null) {
                    output[direction].write(data);
                    log.log(data);
                    if (data[1] == 0) continue;
                    direction = 1 - direction;
                }
                this.client.close();
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

