/*
 * Decompiled with CFR 0.152.
 */
package tools.net.sourceforge.jtds.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class PacketLogger {
    PrintStream out;
    static String hexstring = "0123456789ABCDEF";

    static String hex(byte b) {
        int ln = b & 0xF;
        int hn = (b & 0xF0) >> 4;
        return "" + hexstring.charAt(hn) + hexstring.charAt(ln);
    }

    static String hex(short b) {
        byte lb = (byte)(b & 0xFF);
        byte hb = (byte)((b & 0xFF00) >> 8);
        return PacketLogger.hex(hb) + PacketLogger.hex(lb);
    }

    public PacketLogger(String filename) throws IOException {
        this.out = new PrintStream(new FileOutputStream(new File(filename)));
    }

    public void log(byte[] packet) {
        short pos = 0;
        while (pos < packet.length) {
            short i;
            this.out.print(PacketLogger.hex(pos) + ": ");
            short startpos = pos;
            pos = (short)(pos + 16);
            if (pos > packet.length) {
                pos = (short)packet.length;
            }
            for (i = startpos; i < pos; i = (short)(i + 1)) {
                this.out.print(PacketLogger.hex(packet[i]) + " ");
            }
            for (i = pos; i < startpos + 16; i = (short)(i + 1)) {
                this.out.print("   ");
            }
            this.out.print("    ");
            for (i = startpos; i < startpos + 16; i = (short)(i + 1)) {
                if (i >= pos) {
                    this.out.print(" ");
                    continue;
                }
                if (packet[i] < 32) {
                    this.out.print(".");
                    continue;
                }
                this.out.print((char)packet[i]);
            }
            this.out.println("");
        }
        this.out.println("");
    }
}

