/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.ui.point;

import com.tridium.ndriver.ui.point.BNPointManager;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridiumemea.micros.point.BMicrosProxyExt;
import com.tridiumemea.micros.ui.point.MicrosPointManagerController;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BHtmlFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"micros:MicrosPointDeviceExt", "micros:MicrosPointFolder"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public final class BMicrosPointManager
extends BNPointManager {
    public static final Type TYPE = Sys.loadType(BMicrosPointManager.class);
    static final Lexicon lex = Lexicon.make(BMicrosPointManager.class);
    private static final String WORD_OUT = lex.getText("pm.out");
    private static final String ROOM_NUMBER = lex.getText("pm.roomNumber");
    private static final String PRE_ARRIVAL = lex.getText("pm.preArrival");
    private static final String GUEST_RESERVATION_NUM = lex.getText("pm.guestReservationNumber");
    private final MgrColumn colPath = new MgrColumn.Path(2);
    private final MgrColumn colName = new MgrColumn.Name();
    private final MgrColumn colType = new MgrColumn.Type(4);
    private final MgrColumn colToString = new MgrColumn.ToString(WORD_OUT, 0);
    private final MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    private final MgrColumn colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    private final MgrColumn colReadValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    private final MgrColumn colRoomNumber = new MgrColumn.PropPath(ROOM_NUMBER, new Property[]{BControlPoint.proxyExt, BMicrosProxyExt.roomNumber}, 1);
    private final MgrColumn colGuestNumber = new MgrColumn.PropPath(GUEST_RESERVATION_NUM, new Property[]{BControlPoint.proxyExt, BMicrosProxyExt.guestReservationNumber}, 4);
    private final MgrColumn colRoomEquipmentStatus = new MgrColumn.PropPath(PRE_ARRIVAL, new Property[]{BControlPoint.proxyExt, BMicrosProxyExt.preArrival}, 4);
    private final MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colToString, this.colRoomNumber, this.colGuestNumber, this.colRoomEquipmentStatus, this.colFacets, this.colFaultCause, this.colReadValue};
    static final Logger LOG = Logger.getLogger(TYPE.getModule().getModuleName());

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model((BPointManager)this);
    }

    protected MgrController makeController() {
        return new MicrosPointManagerController(this);
    }

    public void help() {
        FilePath path = TYPE.getModule().getRootFilePath().merge("help.html");
        BHtmlFile file = (BHtmlFile)BOrd.make((OrdQuery)path).get();
        BWebBrowser browser = new BWebBrowser();
        browser.load((BObject)file, this.getCurrentContext());
        BConstrainedPane cons = new BConstrainedPane((BWidget)browser);
        cons.setMinSize(500.0, 400.0);
        cons.setMaxSize(500.0, 400.0);
        BDialog.open((BWidget)this, (String)TYPE.getDisplayName(null), (Object)cons, (int)1);
    }

    private final class Model
    extends PointModel {
        Model(BPointManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BMicrosPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList list = new ArrayList();
            Model.addBooleanPointTypes(list, (boolean)false);
            return list.toArray(new MgrTypeInfo[list.size()]);
        }
    }
}

