/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoMigrator;

import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceExt;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.videoDriver.camera.BIVideoCamera;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.baja.io.ValueDocDecoder;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BMilestoneNetworkConverter
extends BComponent
implements BIBogElementConverter {
    public static final Type TYPE = Sys.loadType(BMilestoneNetworkConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();
    private static Lexicon lex;
    private static final String CAMERA_ID = "cameraId";
    private static final String VIDEO_DEVICE_ID = "videoDeviceId";
    private AtomicInteger cameraIdNumber;

    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) {
        if (!"nmilestone:MilestoneCameraDeviceExt".equalsIgnoreCase(typeSpecName)) {
            log.warning("MilestoneNetworkConverter.convertXElem() should not have been called on " + typeSpecName);
            return null;
        }
        log.fine("x = " + x + "\t typeSpecName = " + typeSpecName + "\t sourceVersion = " + sourceVersion);
        this.cameraIdNumber = new AtomicInteger(0);
        for (XElem ptag : x.elems()) {
            if ("nms:MilestoneCamera".equalsIgnoreCase(ptag.get("t"))) {
                this.setCameraIdValue(ptag);
                continue;
            }
            if (!"nvideo:CameraFolder".equalsIgnoreCase(ptag.get("t"))) continue;
            for (XElem ptagChild : ptag.elems()) {
                if (!"nms:MilestoneCamera".equalsIgnoreCase(ptagChild.get("t"))) continue;
                this.setCameraIdValue(ptagChild);
            }
        }
        return x;
    }

    private void setCameraIdValue(XElem ptag) {
        for (XElem ptagChild : ptag.elems()) {
            if (!VIDEO_DEVICE_ID.equalsIgnoreCase(ptagChild.get("n"))) continue;
            for (XElem childElement : ptagChild.elems()) {
                if (!CAMERA_ID.equalsIgnoreCase(childElement.get("n"))) continue;
                String cameraName = childElement.get("v");
                childElement.setAttr("v", String.valueOf(this.cameraIdNumber));
                log.info("Property cameraId is set to new value : " + this.cameraIdNumber + " for MilestoneCamera : " + cameraName);
                this.cameraIdNumber.incrementAndGet();
            }
        }
    }

    public void convertComplex(BComponent root, ValueDocDecoder.ITypeResolver resolver, BComplex toConvert, Version sourceVersion) {
        BIVideoCamera[] cameras;
        if (!(toConvert instanceof BMilestoneCameraDeviceExt)) {
            log.warning("MilestoneNetworkConverter.convertComplex() should not have been called on " + toConvert);
            return;
        }
        BMilestoneCameraDeviceExt cameraDeviceExt = (BMilestoneCameraDeviceExt)toConvert;
        log.info("MilestoneNetworkConverter.convertComplex() called on MilestoneCameraDeviceExt");
        for (BIVideoCamera camera : cameras = cameraDeviceExt.getAllCameras()) {
            ((BMilestoneCameraDeviceId)((BMilestoneCamera)camera).getVideoDeviceId()).setCameraGuid(((BMilestoneCamera)camera).getMilestoneGuid());
            log.info(lex.getText("MilestoneCamera.UpdatedCameraGuid", new Object[]{camera.getCameraDescription()}));
        }
    }

    static {
        convertTypes.add("nmilestone:MilestoneCameraDeviceExt");
        lex = Lexicon.make((String)"videoMigrator");
    }
}

