/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.win32;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.timezone.BDstSupportLevel;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSystemPlatformServiceWin32
extends BSystemPlatformService {
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceWin32.class);
    protected String[] fileSystems;
    protected Property[] filesystemProps;
    private static long lastFileCheck = 0L;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformServiceWin32() {
        this.setTimezoneDayModeSupport(BDstSupportLevel.nthWeekday);
    }

    @Override
    public boolean isValidPlatform() {
        return false;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        IPlatformProvider platformProvider = BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE;
        this.fileSystems = platformProvider.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        for (int i = 0; i < this.fileSystems.length; ++i) {
            BFilesystemAttributes attrs = new BFilesystemAttributes(platformProvider.getTotalBytes(this.fileSystems[i]) / 1024L, platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L);
            this.filesystemProps[i] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[i]), (BValue)attrs, 3);
        }
        this.setTotalPhysicalMemory((int)(platformProvider.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        this.setNumCpus(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public String makeRootName(String rootDirName) {
        return rootDirName + "\\";
    }

    @Override
    public void doPoll(Context cx) {
        if (!this.isRunning()) {
            return;
        }
        IPlatformProvider platformProvider = BSystemPlatformService.PlatformProviderHolder._PLATFORM_PROVIDER_INSTANCE;
        this.setFreePhysicalMemory((int)(platformProvider.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(platformProvider.getCurrentCPUUtilization());
        this.setOverallCpuUsage(platformProvider.getOverallCPUUtilization());
        if (cx != null && cx.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(cx);
        long fileCheck = Clock.ticks();
        if (fileCheck - lastFileCheck > 15000L) {
            lastFileCheck = fileCheck;
            for (int i = 0; i < this.fileSystems.length; ++i) {
                BFilesystemAttributes attrs = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[i]);
                attrs.setFreeSpace(platformProvider.getFreeBytes(this.fileSystems[i]) / 1024L);
            }
        }
    }
}

