/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.win32;

import com.tridium.platform.ntp.BNtpMode;
import com.tridium.platform.ntp.BNtpServer;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNtpServerWin32
extends BNtpServer {
    public static final Property useSpecialPollInterval = BNtpServerWin32.newProperty((int)3, (boolean)false, null);
    public static final Property fallbackOnly = BNtpServerWin32.newProperty((int)3, (boolean)false, null);
    public static final Property peerMode = BNtpServerWin32.newProperty((int)3, (BValue)BNtpMode.unspecified, null);
    public static final Type TYPE = Sys.loadType(BNtpServerWin32.class);
    protected String serverString = null;
    protected static final int FLAG_USE_SPECIAL_POLL_INTERVAL = 1;
    protected static final int FLAG_FALLBACK_ONLY = 2;
    protected static final int FLAG_SYMMETRIC_ACTIVE_MODE = 4;
    protected static final int FLAG_CLIENT_MODE = 8;

    public boolean getUseSpecialPollInterval() {
        return this.getBoolean(useSpecialPollInterval);
    }

    public void setUseSpecialPollInterval(boolean v) {
        this.setBoolean(useSpecialPollInterval, v, null);
    }

    public boolean getFallbackOnly() {
        return this.getBoolean(fallbackOnly);
    }

    public void setFallbackOnly(boolean v) {
        this.setBoolean(fallbackOnly, v, null);
    }

    public BNtpMode getPeerMode() {
        return (BNtpMode)this.get(peerMode);
    }

    public void setPeerMode(BNtpMode v) {
        this.set(peerMode, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNtpServerWin32() {
    }

    public BNtpServerWin32(String serverString) {
        this.updateServerString(serverString);
    }

    @Override
    public BNtpServer makeServer(String serverString) {
        return new BNtpServerWin32(serverString);
    }

    @Override
    public void updateServerString(String serverString) {
        this.serverString = serverString;
        int ixComma = serverString.indexOf(44);
        if (ixComma < 0) {
            this.setAddress(serverString);
        } else {
            this.setAddress(serverString.substring(0, ixComma));
            int flags = TextUtil.hexCharToInt((char)serverString.charAt(serverString.length() - 1));
            this.setUseSpecialPollInterval((flags & 1) > 0);
            this.setFallbackOnly((flags & 2) > 0);
            if ((flags & 4) > 0) {
                this.setPeerMode(BNtpMode.symmetricActive);
            } else if ((flags & 8) > 0) {
                this.setPeerMode(BNtpMode.client);
            } else {
                this.setPeerMode(BNtpMode.unspecified);
            }
        }
    }

    @Override
    public String getServerString() {
        if (this.serverString == null) {
            this.serverString = this.getServerString(this.getAddress(), this.getUseSpecialPollInterval(), this.getFallbackOnly(), this.getPeerMode());
        }
        return this.serverString;
    }

    public String getServerString(String address, boolean useSpecialPollInterval, boolean fallbackOnly, BNtpMode peerMode) {
        StringBuilder result = new StringBuilder(address);
        int flags = 0;
        if (useSpecialPollInterval) {
            flags |= 1;
        }
        if (fallbackOnly) {
            flags |= 2;
        }
        if (peerMode == BNtpMode.symmetricActive) {
            flags |= 4;
        } else if (peerMode == BNtpMode.client) {
            flags |= 8;
        }
        if (flags != 0) {
            result.append(",0x");
            result.append(TextUtil.byteToHexString((int)flags).charAt(1));
        }
        return result.toString().trim();
    }

    @Override
    public String getPropertyName(String serverString) {
        int ixComma = serverString.indexOf(44);
        if (ixComma < 0) {
            return SlotPath.escape((String)serverString);
        }
        return SlotPath.escape((String)serverString.substring(0, ixComma));
    }

    public synchronized boolean equivalent(Object o) {
        if (o instanceof String) {
            return this.getServerString().equals(o);
        }
        if (o instanceof BNtpServerWin32) {
            return ((BNtpServerWin32)((Object)o)).getServerString().equals(this.getServerString());
        }
        return false;
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == address || prop == useSpecialPollInterval || prop == fallbackOnly || prop == peerMode) {
            this.serverString = null;
        }
    }
}

