/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.timezone;

import com.tridium.platform.timezone.BDstSupportLevel;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneException;

public class TimeZoneUtil {
    public static boolean isEquivalent(BTimeZone tz1, BTimeZone tz2) {
        int thisUtc = 0;
        int thisAdj = 0;
        int RHSUtc = 0;
        int RHSAdj = 0;
        DstRule thisStart = null;
        DstRule thisEnd = null;
        DstRule RHSStart = null;
        DstRule RHSEnd = null;
        if (tz1.isJavaTimeZone()) {
            thisUtc = tz1.getUtcOffset();
            thisAdj = tz1.getDaylightAdjustment();
            thisStart = (DstRule)DstRule.fw((int)1104, (Object)tz1.getJavaTimeZone(), (Object)Boolean.TRUE, null, null);
            thisEnd = (DstRule)DstRule.fw((int)1104, (Object)tz1.getJavaTimeZone(), (Object)Boolean.FALSE, null, null);
        } else {
            thisUtc = tz1.getUtcOffset();
            thisAdj = tz1.getDaylightAdjustment();
            thisStart = tz1.getDaylightStartRule();
            thisEnd = tz1.getDaylightEndRule();
        }
        if (tz2.isJavaTimeZone()) {
            RHSUtc = tz2.getUtcOffset();
            RHSAdj = tz2.getDaylightAdjustment();
            RHSStart = (DstRule)DstRule.fw((int)1104, (Object)tz2.getJavaTimeZone(), (Object)Boolean.TRUE, null, null);
            RHSEnd = (DstRule)DstRule.fw((int)1104, (Object)tz2.getJavaTimeZone(), (Object)Boolean.FALSE, null, null);
        } else {
            RHSUtc = tz2.getUtcOffset();
            RHSAdj = tz2.getDaylightAdjustment();
            RHSStart = tz2.getDaylightStartRule();
            RHSEnd = tz2.getDaylightEndRule();
        }
        if (thisUtc != RHSUtc) {
            return false;
        }
        if (thisAdj != RHSAdj) {
            return false;
        }
        if (thisAdj == 0) {
            return true;
        }
        DstRule rule1Norm = null;
        DstRule rule2Norm = null;
        try {
            rule1Norm = DstRule.asWeekdayRule((DstRule)thisStart);
        }
        catch (TimeZoneException e) {
            rule1Norm = thisStart;
        }
        try {
            rule2Norm = DstRule.asWeekdayRule((DstRule)RHSStart);
        }
        catch (TimeZoneException e) {
            rule2Norm = RHSStart;
        }
        if (TimeZoneUtil.isSupported(rule1Norm, tz1, 0, BDstSupportLevel.full)) {
            rule1Norm = DstRule.getWallTimeRule((DstRule)rule1Norm, (int)0, (BTimeZone)tz1);
        }
        if (TimeZoneUtil.isSupported(rule2Norm, tz2, 0, BDstSupportLevel.full)) {
            rule2Norm = DstRule.getWallTimeRule((DstRule)rule2Norm, (int)0, (BTimeZone)tz2);
        }
        if (!DstRule.equals((DstRule)rule1Norm, (DstRule)rule2Norm)) {
            return false;
        }
        try {
            rule1Norm = DstRule.asWeekdayRule((DstRule)thisEnd);
        }
        catch (TimeZoneException e) {
            rule1Norm = thisEnd;
        }
        try {
            rule2Norm = DstRule.asWeekdayRule((DstRule)RHSEnd);
        }
        catch (TimeZoneException e) {
            rule2Norm = RHSEnd;
        }
        if (TimeZoneUtil.isSupported(rule1Norm, tz1, 1, BDstSupportLevel.full)) {
            rule1Norm = DstRule.getWallTimeRule((DstRule)rule1Norm, (int)1, (BTimeZone)tz1);
        }
        if (TimeZoneUtil.isSupported(rule2Norm, tz2, 1, BDstSupportLevel.full)) {
            rule2Norm = DstRule.getWallTimeRule((DstRule)rule2Norm, (int)1, (BTimeZone)tz2);
        }
        return DstRule.equals((DstRule)rule1Norm, (DstRule)rule2Norm);
    }

    public static boolean isSupported(BTimeZone tz, BDstSupportLevel dstSupportLevel) {
        return TimeZoneUtil.isSupported(System.currentTimeMillis(), tz, dstSupportLevel);
    }

    public static boolean isSupported(long millis, BTimeZone tz, BDstSupportLevel dstSupportLevel) {
        return TimeZoneUtil.isSupported(tz.getDaylightStartRule(), tz, 0, dstSupportLevel) && TimeZoneUtil.isSupported(tz.getDaylightEndRule(), tz, 1, dstSupportLevel);
    }

    public static boolean isSupported(DstRule rule, BTimeZone tz, int boundary, BDstSupportLevel dstSupportLevel) {
        if (rule == null) {
            return true;
        }
        if (dstSupportLevel == BDstSupportLevel.none) {
            return false;
        }
        switch (dstSupportLevel.getOrdinal()) {
            case 0: {
                return false;
            }
            case 1: {
                if (rule.getDayMode() == 1 || rule.getDayMode() == 2) {
                    try {
                        rule = DstRule.asWeekdayRule((DstRule)rule);
                        break;
                    }
                    catch (TimeZoneException e) {
                        return false;
                    }
                }
                if (rule.getDayMode() == -1) break;
                return false;
            }
            case 2: {
                if (rule.getDayMode() == 1 || rule.getDayMode() == 2) {
                    try {
                        rule = DstRule.asWeekdayRule((DstRule)rule);
                        break;
                    }
                    catch (TimeZoneException e) {
                        return false;
                    }
                }
                if (rule.getDayMode() == -1 || rule.getDayMode() == 0) break;
                return false;
            }
        }
        if (rule.getTimeMode() == 2) {
            BAbsTime time = BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)rule.getMonth(), (int)2, (int)rule.getTime().getHour(), (int)rule.getTime().getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
            if ((time = BAbsTime.make((long)time.getMillis(), (BTimeZone)tz)).getDay() != 2) {
                return false;
            }
        } else if (rule.getTimeMode() == 1 && boundary == 1) {
            BAbsTime time = BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)rule.getMonth(), (int)2, (int)rule.getTime().getHour(), (int)rule.getTime().getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.makeIgnoringCache((String)(tz.getId() + "-std"), (int)tz.getUtcOffset()));
            if ((time = BAbsTime.make((long)time.getMillis(), (BTimeZone)tz)).getDay() != 2) {
                return false;
            }
        }
        return true;
    }

    public static BTimeZone makeCompatible(BTimeZone zone, BDstSupportLevel supportLevel) {
        return TimeZoneUtil.makeCompatible(System.currentTimeMillis(), zone, supportLevel);
    }

    public static BTimeZone makeCompatible(long millis, BTimeZone zone, BDstSupportLevel supportLevel) {
        DstRule startRule = zone.getDaylightStartRule();
        DstRule endRule = zone.getDaylightEndRule();
        boolean changedARule = false;
        if (startRule != null && (startRule.getDayMode() == 1 || startRule.getDayMode() == 2) && supportLevel.getOrdinal() != 3) {
            changedARule = true;
            startRule = DstRule.asWeekdayRule((DstRule)startRule);
        }
        if (endRule != null && (endRule.getDayMode() == 1 || endRule.getDayMode() == 2) && supportLevel.getOrdinal() != 3) {
            changedARule = true;
            endRule = DstRule.asWeekdayRule((DstRule)endRule);
        }
        if (changedARule) {
            return BTimeZone.makeIgnoringCache((String)zone.getId(), (String)zone.getDisplayName(false, null), (String)zone.getShortDisplayName(false, null), (String)zone.getDisplayName(true, null), (String)zone.getShortDisplayName(true, null), (int)zone.getUtcOffset(), (int)zone.getDaylightAdjustment(), (DstRule)startRule, (DstRule)endRule);
        }
        return zone;
    }
}

