/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip.link;

import com.tridium.platform.BPlatform;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.daemon.message.GetLinkCfgMessage;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.link.BBridgePriority;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BIsolatedLinkSettings;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.BLinkMode;
import com.tridium.platform.tcpip.link.BPortPriority;
import com.tridium.platform.tcpip.link.BTcpIpLinkSettings;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class LinkCfgUtil {
    public static final String LINKCFG_SLOT_NAME_MODES_SUPPORTED = "linkModesSupported";
    public static final String LINKCFG_SLOT_NAME_LINK_SETTINGS = "linkModeSettings";
    public static final String LINKCFG_FILE_NAME = "link.cfg";
    public static final String LINKCFG_SERVLET_NAME = "linkcfg";
    private static final String LINK_SERVLET_LINK_FILE_PATH = "link_file_path";
    private static final String LINK_SERVLET_LINK_MODES_SUPPORTED_ELEM = "linkmodes";
    private static final String LINK_SERVLET_LINK_MODE_SUPPORTED_ELEM = "linkmode";
    private static final String LINK_SERVLET_LINK_MODE_NAME = "name";
    private static final String LINK_SERVLET_LINK_MODE_STANDARD = "standard";
    private static final String LINK_SERVLET_LINK_MODE_DAISYCHAIN = "daisychain";
    private static final String LINKCFG_MARKER_NEWLINE = "\n";
    private static final String LINKCFG_MARKER_SPACE = " ";
    private static final String LINKCFG_HEADER_START = "[";
    private static final String LINKCFG_HEADER_END = "]";
    private static final String LINKCFG_LINK_MODE_KEY = "mode";
    private static final String LINKCFG_LINK_MODE_STANDARD = "standard";
    private static final String LINKCFG_LINK_MODE_DAISYCHAIN = "daisychain";
    private static final String LINKCFG_STP_HEADER = "[stp]";
    private static final String LINKCFG_ENABLED_KEY = "enabled";
    private static final String LINKCFG_ENABLED_TRUE = "true";
    private static final String LINKCFG_ENABLED_FALSE = "false";
    private static final String LINKCFG_BRIDGE_PRIORITY_KEY = "bridge_priority";
    private static final String LINKCFG_PORT_PRIORITY_1_KEY = "port_priority_1";
    private static final String LINKCFG_PORT_PRIORITY_2_KEY = "port_priority_2";
    private static final String LINKCFG_HELLO_TIME_KEY = "hello_time";
    private static final String LINKCFG_FORWARD_DELAY_TIME_KEY = "forward_delay_time";
    private static final String LINKCFG_MAXIMUM_AGING_TIME_KEY = "maximum_aging_time";
    private static final String LINKCFG_PORT_PRIORITY_1_KEY_LEGACY = "port_priority1";
    private static final String LINKCFG_PORT_PRIORITY_2_KEY_LEGACY = "port_priority2";

    public static void loadFromSession(BLinkCfgHostSettings settings, BDaemonSession session) throws Exception {
        if (!session.getHostProperties().supportsServlet(LINKCFG_SERVLET_NAME)) {
            return;
        }
        InputStream xmlStream = session.getInputStream(new GetLinkCfgMessage());
        XElem rootElem = XParser.make((InputStream)xmlStream).parse();
        LinkCfgUtil.linkCfgXmlToSettings(settings, rootElem);
    }

    private static void linkCfgXmlToSettings(BLinkCfgHostSettings settings, XElem rootElem) {
        String filePath = rootElem.get(LINK_SERVLET_LINK_FILE_PATH);
        settings.setLinkConfPath(filePath);
        settings.getLinkModesSupported().removeAll();
        XElem linkmodesElem = rootElem.elem(LINK_SERVLET_LINK_MODES_SUPPORTED_ELEM);
        if (linkmodesElem != null) {
            XElem[] linkmodeElems;
            for (XElem eachLinkmodeElem : linkmodeElems = linkmodesElem.elems(LINK_SERVLET_LINK_MODE_SUPPORTED_ELEM)) {
                String name = eachLinkmodeElem.get(LINK_SERVLET_LINK_MODE_NAME, null);
                if (name == null) continue;
                if (name.equals("daisychain")) {
                    settings.getLinkModesSupported().add(BLinkMode.daisyChain.getTag(), (BValue)BLinkMode.daisyChain);
                    continue;
                }
                if (!name.equals("standard")) continue;
                settings.getLinkModesSupported().add(BLinkMode.isolated.getTag(), (BValue)BLinkMode.isolated);
            }
        }
    }

    public static void loadLinkCfgFile(BLinkCfgHostSettings linkHostSettings, BDaemonSession session) throws Exception {
        String filePath = linkHostSettings.getLinkConfPath();
        FilePath confFilePath = new FilePath(filePath);
        InputStream confFileStream = session.getInputStream(new GetFileMessage(confFilePath, session.getFileSpace()));
        if (confFileStream == null) {
            throw new NullPointerException("Missing link configuration file at specified path '" + filePath + "'");
        }
        LinkCfgUtil.linkCfgToSettings(linkHostSettings, confFileStream);
    }

    public static void linkCfgToSettings(BLinkCfgHostSettings settings, InputStream in) throws Exception {
        String[] allLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        BTcpIpLinkSettings currentLinkSettings = new BDaisyChainSettings();
        for (int i = 0; i < allLines.length; ++i) {
            String line = allLines[i].trim();
            if (!line.startsWith(LINKCFG_LINK_MODE_KEY)) continue;
            String[] words = line.split(LINKCFG_MARKER_SPACE);
            if (!words[1].equals("daisychain")) continue;
            currentLinkSettings = new BDaisyChainSettings();
            currentLinkSettings.setIsDaisyChainEnabled(true);
        }
        settings.setLinkModeSettings(currentLinkSettings);
    }

    private static int linkCfgStpToSettings(BDaisyChainSettings settings, String[] allLines, int i) {
        boolean endOfProtocolBlock = false;
        if (settings == null) {
            return i;
        }
        while (i < allLines.length && !endOfProtocolBlock) {
            String line = allLines[i].trim();
            String[] words = line.split(LINKCFG_MARKER_SPACE);
            if (line.startsWith(LINKCFG_HEADER_START) && line.endsWith(LINKCFG_HEADER_END)) {
                endOfProtocolBlock = true;
            } else {
                switch (words[0].trim()) {
                    case "enabled": {
                        settings.setIsStpEnabled(Boolean.valueOf(words[1].toLowerCase()));
                        break;
                    }
                    case "bridge_priority": {
                        settings.setBridgePriority(BBridgePriority.make(Integer.parseInt(words[1])));
                        break;
                    }
                    case "port_priority_1": 
                    case "port_priority1": {
                        settings.setPortPriority1(BPortPriority.make(Integer.parseInt(words[1])));
                        break;
                    }
                    case "port_priority_2": 
                    case "port_priority2": {
                        settings.setPortPriority2(BPortPriority.make(Integer.parseInt(words[1])));
                        break;
                    }
                    case "hello_time": {
                        settings.setHelloTime(BRelTime.makeSeconds((int)Integer.parseInt(words[1])));
                        break;
                    }
                    case "forward_delay_time": {
                        settings.setForwardDelayTime(BRelTime.makeSeconds((int)Integer.parseInt(words[1])));
                        break;
                    }
                    case "maximum_aging_time": {
                        settings.setMaxAgingTime(BRelTime.makeSeconds((int)Integer.parseInt(words[1])));
                        break;
                    }
                    default: {
                        BPlatform.log.warning("Unrecognized key value pair '" + line + "' present in platform link configuration file, ignoring");
                    }
                }
            }
            ++i;
        }
        return i;
    }

    public static void saveToSession(BLinkCfgHostSettings settings, BDaemonSession session) throws Exception {
        if (!session.getHostProperties().supportsServlet(LINKCFG_SERVLET_NAME)) {
            return;
        }
        FileTransferMessage msg = new FileTransferMessage(session.getFileSpace());
        String fileContent = LinkCfgUtil.settingsToLinkCfgFile(settings, session);
        FilePath hostsPath = new FilePath(settings.getLinkConfPath());
        msg.addElement(new ByteArrayFileTransferElement(hostsPath, fileContent.getBytes(), session.getFileSpace()));
        DaemonFileUtil.transfer(session, msg, null);
    }

    private static String settingsToLinkCfgFile(BLinkCfgHostSettings linkCfgSettings, BDaemonSession session) {
        BDaisyChainSettings daisyChainSettings;
        StringBuilder newFileContent = new StringBuilder();
        BTcpIpLinkSettings settings = linkCfgSettings.getLinkModeSettings();
        String activeMode = "daisychain";
        if (settings instanceof BDaisyChainSettings) {
            activeMode = "daisychain";
        } else if (settings instanceof BIsolatedLinkSettings) {
            activeMode = "standard";
        }
        newFileContent.append(LINKCFG_LINK_MODE_KEY).append(LINKCFG_MARKER_SPACE).append(activeMode).append(LINKCFG_MARKER_NEWLINE);
        if (settings instanceof BDaisyChainSettings && (daisyChainSettings = (BDaisyChainSettings)settings).getIsStpSupported()) {
            newFileContent.append(LINKCFG_MARKER_NEWLINE).append(LINKCFG_STP_HEADER).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_ENABLED_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getIsStpEnabled() ? LINKCFG_ENABLED_TRUE : LINKCFG_ENABLED_FALSE).append(LINKCFG_MARKER_NEWLINE);
            int bridgePriority = daisyChainSettings.getBridgePriority().getOrdinal();
            try {
                if (new Version(session.getHostProperties().getDaemonVersion()).compareTo(new Version("4.8.0.0")) < 0) {
                    bridgePriority = BBridgePriority.getLegacyOrdinal(bridgePriority);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            newFileContent.append(LINKCFG_BRIDGE_PRIORITY_KEY).append(LINKCFG_MARKER_SPACE).append(bridgePriority).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_PORT_PRIORITY_1_KEY).append(LINKCFG_MARKER_SPACE).append((Object)daisyChainSettings.getPortPriority1()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_PORT_PRIORITY_2_KEY).append(LINKCFG_MARKER_SPACE).append((Object)daisyChainSettings.getPortPriority2()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_HELLO_TIME_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getHelloTime().getSeconds()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_FORWARD_DELAY_TIME_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getForwardDelayTime().getSeconds()).append(LINKCFG_MARKER_NEWLINE);
            newFileContent.append(LINKCFG_MAXIMUM_AGING_TIME_KEY).append(LINKCFG_MARKER_SPACE).append(daisyChainSettings.getMaxAgingTime().getSeconds()).append(LINKCFG_MARKER_NEWLINE);
        }
        return newFileContent.toString();
    }

    public static void copyLinkCfgSlotToHost(BLinkCfgHostSettings linkCfgHostSettings, BTcpIpHostSettings hostSettings) {
        BTcpIpLinkSettings providedLinkSettings = linkCfgHostSettings.getLinkModeSettings();
        if (hostSettings.get(LINKCFG_SLOT_NAME_LINK_SETTINGS) != null) {
            BTcpIpLinkSettings currentSettings = (BTcpIpLinkSettings)hostSettings.get(LINKCFG_SLOT_NAME_LINK_SETTINGS);
            if (currentSettings instanceof BDaisyChainSettings && providedLinkSettings instanceof BDaisyChainSettings) {
                BDaisyChainSettings currentDaisyChainSettings = (BDaisyChainSettings)currentSettings;
                BDaisyChainSettings providedDaisyChainSettings = (BDaisyChainSettings)providedLinkSettings;
                currentDaisyChainSettings.copyFrom((BComplex)providedDaisyChainSettings);
            } else if (currentSettings instanceof BIsolatedLinkSettings && providedLinkSettings instanceof BIsolatedLinkSettings) {
                BIsolatedLinkSettings currentIsolatedSettings = (BIsolatedLinkSettings)currentSettings;
                BIsolatedLinkSettings providedIsolatedSettings = (BIsolatedLinkSettings)providedLinkSettings;
                currentIsolatedSettings.copyFrom((BComplex)providedIsolatedSettings);
            } else {
                hostSettings.set(LINKCFG_SLOT_NAME_LINK_SETTINGS, providedLinkSettings.newCopy());
            }
        } else {
            hostSettings.add(LINKCFG_SLOT_NAME_LINK_SETTINGS, providedLinkSettings.newCopy(), 3);
        }
        BVector providedLinkModesSupported = linkCfgHostSettings.getLinkModesSupported();
        if (hostSettings.get(LINKCFG_SLOT_NAME_MODES_SUPPORTED) != null) {
            BVector currentSupportedModes = (BVector)hostSettings.get(LINKCFG_SLOT_NAME_MODES_SUPPORTED);
            currentSupportedModes.removeAll();
            SlotCursor c = providedLinkModesSupported.getProperties();
            while (c.next(BLinkMode.class)) {
                BLinkMode supportedMode = (BLinkMode)c.get();
                currentSupportedModes.add(supportedMode.getTag(), (BValue)supportedMode);
            }
        } else {
            hostSettings.add(LINKCFG_SLOT_NAME_MODES_SUPPORTED, providedLinkModesSupported.newCopy(), 3);
        }
    }

    public static void copyLinkCfgSlotFromHost(BLinkCfgHostSettings linkCfgHostSettings, BTcpIpHostSettings hostSettings) {
        BTcpIpLinkSettings hostLinkSettings = (BTcpIpLinkSettings)hostSettings.get(LINKCFG_SLOT_NAME_LINK_SETTINGS);
        if (hostLinkSettings != null) {
            linkCfgHostSettings.setLinkModeSettings((BTcpIpLinkSettings)hostLinkSettings.newCopy());
        }
    }

    public static void setReadOnly(BLinkCfgHostSettings settings) {
        settings.getLinkModeSettings().setIsReadOnly(true);
    }
}

