/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip.dhcpd;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDhcpdMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdLeaseSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUnsupportedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DhcpdUtil {
    public static final String DHCPD_FILE_PATH_WIFI = "/opt/niagara/platform/wifi/dhcpd_ti18xx.conf";
    private static final String DHCPD_DEFAULT_LEASE_TIMEVALUE = "21600";
    private static final String DHCPD_MAX_LEASE_TIMEVALUE = "43200";
    public static final String DHCPD_ADAPTER_SAP_OSNAME = "tiw_sap0";
    private static final String DHCPD_ADAPTER_PREFIX_ID = "en";
    private static final String DHCPD_ADAPTER_PREFIX_OSNAME = "dm";
    public static final String DHCPD_SLOT_NAME = "dhcpdAdapterSettings";
    public static final String DHCPD_SERVLET_NAME = "dhcpd";
    public static final int DHCPD_MAX_CLIENTS = 240;
    public static final int DHCPD_MAX_CLIENTS_WIFI = 16;
    private static final String DHCPDCONF_COMMENT = "#";
    private static final String DHCPDCONF_MARKER_WIFI = "WIFI";
    private static final String DHCPDCONF_MARKER_SUBNET = " SUBNET";
    private static final String DHCPDCONF_MARKER_SITELOCAL = "site-local-options";
    private static final String DHCPDCONF_MARKER_WARN = " MARKER - DO NOT REMOVE THIS COMMENT";
    private static final String DHCPDCONF_MARKER_NEWLINE = "\n";
    private static final String DHCPDCONF_SUBNET = "subnet";
    private static final String DHCPDCONF_NETMASK = "netmask";
    private static final String DHCPDCONF_DEFAULT_LEASE_TIME = "default-lease-time";
    private static final String DHCPDCONF_MAX_LEASE_TIME = "max-lease-time";
    private static final String DHCPDCONF_RANGE = "range";
    private static final String DHCPDCONF_DEFAULT_SUBNETMASK = "255.255.255.0";
    private static final String DHCPDCONF_DEFAULT_SUBNET = "1.1.1.0";
    private static final String DHCPDCONF_DEFAULT_CLIENT_STARTIP = "1.1.1.10";
    private static final String DHCPDCONF_DEFAULT_SUBNET_WIFI = "192.168.11.0";
    private static final String DHCPDCONF_DEFAULT_CLIENT_STARTIP_WIFI = "192.168.11.10";
    private static final String DHCPDLEASES_LEASE = "lease";
    private static final String DHCPDLEASES_HOSTID = "set hostid";
    private static final String DHCPDLEASES_PLATFORMPORT = "set platform-port";
    private static final String DHCPDLEASES_PLATFORMSPORT = "set platforms-port";
    private static final String DHCPDLEASES_USEPLATFORMS = "set usePlatforms";
    private static final String DHCPDLEASES_FOXPORT = "set fox-port";
    private static final String DHCPDLEASES_FOXSPORT = "set foxs-port";
    private static final String DHCPDLEASES_USEFOXS = "set useFoxs";
    private static final String DHCPDLEASES_STATIONNAME = "set station-name";
    private static Logger log = Logger.getLogger("plat.dhcpd");

    public static void dhcpdConfToSettings(BDhcpdHostSettings dhcpdHostSettings, InputStream in) throws Exception {
        String[] dhcpdLines = FileUtil.readLines((Reader)new InputStreamReader(in));
        int subNetCount = 0;
        String previousLine = null;
        for (int i = 0; i < dhcpdLines.length; ++i) {
            String line = dhcpdLines[i].trim();
            if (line.startsWith(DHCPDCONF_SUBNET) && line.endsWith("{")) {
                String[] words = previousLine.split(" ");
                String name = words[0].substring(1);
                String adapterId = null;
                if (DhcpdUtil.isAdapterOsName(name)) {
                    adapterId = DhcpdUtil.adapterOsNameToId(name);
                } else if (DhcpdUtil.isAdapterId(name)) {
                    adapterId = name;
                }
                BDhcpdAdapterSettings dhcpd = DhcpdUtil.getDhcpdData(dhcpdHostSettings, adapterId);
                i = DhcpdUtil.dhcpdConfSubnetToSettings(dhcpd, dhcpdLines, line, i);
                ++subNetCount;
                ++i;
            }
            previousLine = line;
        }
    }

    public static int dhcpdConfSubnetToSettings(BDhcpdAdapterSettings dhcpSettings, String[] dhcpdLines, String line, int i) {
        if (dhcpSettings == null) {
            return i;
        }
        String[] subnetWords = line.split(" ");
        dhcpSettings.setSubnet(subnetWords[1]);
        dhcpSettings.setSubnetMask(subnetWords[3]);
        line = dhcpdLines[i].trim();
        while (!line.startsWith("}")) {
            String rangeLine;
            String[] rangeWords;
            String tmpStr;
            if (line.startsWith(DHCPDCONF_DEFAULT_LEASE_TIME) && line.endsWith(";")) {
                tmpStr = line.substring(0, line.indexOf(";"));
                String intStr = tmpStr.split(" ")[1];
                dhcpSettings.setDefaultLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
            } else if (line.startsWith(DHCPDCONF_MAX_LEASE_TIME)) {
                tmpStr = line.substring(0, line.indexOf(";"));
                String intStr = tmpStr.split(" ")[1];
                dhcpSettings.setMaxLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
            } else if (line.startsWith(DHCPDCONF_RANGE) && line.endsWith(";") && IPAddressUtil.isIpv4Address((String)(rangeWords = (rangeLine = line.substring(0, line.indexOf(";"))).split(" "))[1]) && IPAddressUtil.isIpv4Address((String)rangeWords[2])) {
                int range = DhcpdUtil.getIpRange(rangeWords[1], rangeWords[2]);
                dhcpSettings.setRange(range);
                dhcpSettings.setStartClientAddress(rangeWords[1]);
            }
            line = dhcpdLines[++i].trim();
        }
        return i;
    }

    public static int getIpRange(String start, String end) {
        int startByte = IPAddressUtil.numericStringToByteArray((String)start)[3] & 0xFF;
        int endByte = IPAddressUtil.numericStringToByteArray((String)end)[3] & 0xFF;
        return endByte - startByte + 1;
    }

    public static String getNextIpAddress(String ipAddress) {
        return DhcpdUtil.getEndIpAddress(2, ipAddress);
    }

    public static String getEndIpAddress(int range, String startAddressAsString) {
        BString endAddress = null;
        byte[] startIpBytes = IPAddressUtil.numericStringToByteArray((String)startAddressAsString);
        int startLastOctet = startIpBytes[3] & 0xFF;
        int endLastOctet = startLastOctet + range - 1;
        if (endLastOctet > 255) {
            endLastOctet = 254;
        }
        endAddress = BString.make((String)("" + (startIpBytes[0] & 0xFF) + "." + (startIpBytes[1] & 0xFF) + "." + (startIpBytes[2] & 0xFF) + "." + endLastOctet));
        return endAddress.getString();
    }

    public static int fixDhcpdRangeSetting(int range, int min, int max) {
        if (min < 1) {
            min = 1;
        }
        if (max > 240) {
            max = 240;
        }
        if (range < min) {
            range = min;
        }
        if (range > max) {
            range = max;
        }
        return range;
    }

    protected static boolean fixDhcpdSettings(BDhcpdAdapterSettings dhcpdSettings, String adapterIP, String adapterNetmask) {
        try {
            int fixRange;
            if (adapterIP.trim().length() == 0 || adapterNetmask.trim().length() == 0) {
                return false;
            }
            boolean needToUpdateDhcpdConf = false;
            String net = IPAddressUtil.getIPv4NetworkPrefix((String)adapterIP, (String)adapterNetmask);
            if (IPAddressUtil.compare((Object)net, (Object)dhcpdSettings.getSubnet()) != 0) {
                dhcpdSettings.setSubnet(net);
                needToUpdateDhcpdConf = true;
            }
            if (IPAddressUtil.compare((Object)adapterNetmask, (Object)dhcpdSettings.getSubnetMask()) != 0) {
                dhcpdSettings.setSubnetMask(adapterNetmask);
                needToUpdateDhcpdConf = true;
            }
            if (dhcpdSettings.getStartClientAddress().trim().isEmpty()) {
                dhcpdSettings.setStartClientAddress(DhcpdUtil.getNextIpAddress(adapterIP));
                needToUpdateDhcpdConf = true;
            }
            byte[] startAddress = IPAddressUtil.numericStringToByteArray((String)dhcpdSettings.getStartClientAddress());
            int range = dhcpdSettings.getRange();
            if (range != (fixRange = DhcpdUtil.fixDhcpdRangeSetting(range, 1, 240))) {
                dhcpdSettings.setRange(fixRange);
                needToUpdateDhcpdConf = true;
            }
            byte[] mask = IPAddressUtil.numericStringToByteArray((String)dhcpdSettings.getSubnetMask());
            byte[] netBytes = IPAddressUtil.numericStringToByteArray((String)net);
            StringBuilder startAsString = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                int startQuartet = (startAddress[i] & ~mask[i] | netBytes[i]) & 0xFF;
                startAsString.append(startQuartet);
                if (i == 3) continue;
                startAsString.append('.');
            }
            dhcpdSettings.setStartClientAddress(startAsString.toString());
            return needToUpdateDhcpdConf;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static String settingsToDhcpdConf(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession session) throws Exception {
        StringBuilder dhcpdContents = new StringBuilder();
        DhcpdUtil.settingsToDhcpdConfPreamble(dhcpdContents);
        DhcpdUtil.settingsToDhcpdConfGlobalOptions(dhcpdContents);
        DhcpdUtil.settingsToDhcpdConfHelper(dhcpdHostSettings, dhcpdContents);
        String dhcpdConfPath = dhcpdHostSettings.getDhcpdConfPath();
        FilePath optionsFile = new FilePath(dhcpdConfPath);
        InputStream optionsStream = session.getInputStream(new GetFileMessage(optionsFile, session.getFileSpace()));
        if (optionsStream == null) {
            throw new NullPointerException("Missing file : " + dhcpdConfPath);
        }
        DhcpdUtil.settingsToDhcpdConfAppendSiteOptions(dhcpdHostSettings, dhcpdContents, optionsStream);
        return dhcpdContents.toString();
    }

    private static void settingsToDhcpdConfAppendSiteOptions(BDhcpdHostSettings dhcpdHostSettings, StringBuilder dhcpdContents, InputStream in) {
        dhcpdContents.append(DHCPDCONF_MARKER_NEWLINE);
        try {
            String[] allLines = FileUtil.readLines((Reader)new InputStreamReader(in));
            Boolean appendLines = false;
            for (int i = 0; i < allLines.length; ++i) {
                if (allLines[i].startsWith("#site-local-options")) {
                    appendLines = true;
                    dhcpdContents.append(DHCPDCONF_COMMENT).append(DHCPDCONF_MARKER_SITELOCAL).append(DHCPDCONF_MARKER_WARN).append(DHCPDCONF_MARKER_NEWLINE);
                    continue;
                }
                if (!appendLines.booleanValue()) continue;
                dhcpdContents.append(allLines[i]).append(DHCPDCONF_MARKER_NEWLINE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void settingsToDhcpdConfHelper(BDhcpdHostSettings dhcpdHostSettings, StringBuilder dhcpdContents) {
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpd = (BDhcpdAdapterSettings)c.get();
            String name = DhcpdUtil.settingsToDhcpdConfAdapterMarkerName(dhcpd);
            dhcpdContents.append(DHCPDCONF_COMMENT).append(name).append(DHCPDCONF_MARKER_SUBNET).append(DHCPDCONF_MARKER_WARN).append(DHCPDCONF_MARKER_NEWLINE);
            DhcpdUtil.settingsToDhcpdConfSubnet(dhcpdContents, dhcpd);
        }
    }

    private static String settingsToDhcpdConfAdapterMarkerName(BDhcpdAdapterSettings dhcpd) {
        if (dhcpd == null) {
            return null;
        }
        String name = DhcpdUtil.adapterIdToOsName(dhcpd.getName());
        if (name.equals(DHCPD_ADAPTER_SAP_OSNAME)) {
            name = DHCPDCONF_MARKER_WIFI;
        }
        return name.toUpperCase();
    }

    private static void settingsToDhcpdConfPreamble(StringBuilder dhcpdContents) {
        dhcpdContents.append("# Niagara DHCPD Configuration File").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("# Use the DHCPD editor under the respective Ethernet Adapter to modify this file").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("# Created ").append(BAbsTime.now()).append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append(DHCPDCONF_MARKER_NEWLINE);
    }

    private static void settingsToDhcpdConfGlobalOptions(StringBuilder dhcpdContents) {
        dhcpdContents.append("# DHCP server should send DHCPNAK messages to mis-configured clients").append(DHCPDCONF_MARKER_NEWLINE).append("authoritative;").append(DHCPDCONF_MARKER_NEWLINE).append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("# DHCP server should not handle dynamic DNS change after start").append(DHCPDCONF_MARKER_NEWLINE).append("ddns-update-style none;").append(DHCPDCONF_MARKER_NEWLINE).append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append(DHCPDCONF_DEFAULT_LEASE_TIME).append(" ").append(DHCPD_DEFAULT_LEASE_TIMEVALUE).append(";").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append(DHCPDCONF_MAX_LEASE_TIME).append(" ").append(DHCPD_MAX_LEASE_TIMEVALUE).append(";").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append(DHCPDCONF_MARKER_NEWLINE);
    }

    private static boolean settingsToDhcpdConfSubnet(StringBuilder dhcpdContents, BDhcpdAdapterSettings dhcpSettings) {
        if (dhcpSettings == null) {
            return false;
        }
        String startClientAddress = dhcpSettings.getStartClientAddress();
        String endClientAddress = DhcpdUtil.getEndIpAddress(dhcpSettings.getRange(), startClientAddress);
        dhcpdContents.append(DHCPDCONF_SUBNET).append(" ").append(dhcpSettings.getSubnet()).append(" ").append(DHCPDCONF_NETMASK).append(" ").append(dhcpSettings.getSubnetMask()).append(" ").append("{").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("  default-lease-time").append(" ").append(dhcpSettings.getDefaultLeaseTime().getSeconds()).append(";").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("  max-lease-time").append(" ").append(dhcpSettings.getMaxLeaseTime().getSeconds()).append(";").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("  range").append(" ").append(startClientAddress).append(" ").append(endClientAddress).append(";").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append("}").append(DHCPDCONF_MARKER_NEWLINE);
        dhcpdContents.append(DHCPDCONF_MARKER_NEWLINE);
        return true;
    }

    public static boolean supportsDhcpd(BDaemonSession session) {
        return session.getHostProperties().supportsServlet(DHCPD_SERVLET_NAME);
    }

    public static void loadFromSession(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession session) throws Exception {
        if (!DhcpdUtil.supportsDhcpd(session)) {
            throw new DhcpdUnsupportedException("DHCPD is unsupported by this platform");
        }
        InputStream dhcpdXmlStream = session.getInputStream(new GetDhcpdMessage());
        XElem dhcpdRootElem = XParser.make((InputStream)dhcpdXmlStream).parse();
        DhcpdUtil.dhcpdXmlToSettings(dhcpdHostSettings, dhcpdRootElem);
    }

    public static List<DhcpdLeaseSettings> getDhcpdLeases(BDaemonSession session, boolean onlyNiagaraDevices) throws Exception {
        BDhcpdHostSettings dhcpdHostSettings = new BDhcpdHostSettings();
        DhcpdUtil.loadFromSession(dhcpdHostSettings, session);
        DhcpdUtil.loadDhcpdConfFile(dhcpdHostSettings, session);
        String[] allLines = DhcpdUtil.loadDhcpdLeaseFile(dhcpdHostSettings);
        List<DhcpdLeaseSettings> leaseList = DhcpdUtil.parseDhcpdLeases(dhcpdHostSettings, allLines, onlyNiagaraDevices);
        return leaseList;
    }

    public static List<DhcpdLeaseSettings> parseDhcpdLeases(BDhcpdHostSettings dhcpdHostSettings, String[] allLines, boolean onlyNiagaraDevices) {
        HashMap<String, DhcpdLeaseSettings> leaseMap = new HashMap<String, DhcpdLeaseSettings>();
        int i = 0;
        while (i < allLines.length) {
            String line = allLines[i].trim();
            ++i;
            DhcpdLeaseSettings leaseElement = null;
            if (!line.startsWith(DHCPDLEASES_LEASE) || !line.endsWith("{")) continue;
            String[] words = line.split(" ");
            String leaseIp = words[1];
            leaseElement = new DhcpdLeaseSettings();
            leaseElement.setIgnoreLease(false);
            leaseElement.setIp(leaseIp);
            DhcpdUtil.setDhcpdSubnetOfIp(leaseElement, dhcpdHostSettings);
            i = DhcpdUtil.dhcpdLeaseToSettings(leaseElement, allLines, i);
            boolean ignoreLeaseFlag = leaseElement.getIgnoreLease();
            if (leaseElement != null && !ignoreLeaseFlag) {
                String hostid = leaseElement.getHostid();
                if (onlyNiagaraDevices) {
                    if (hostid != null && hostid.trim().length() > 0) {
                        leaseMap.put(leaseIp, leaseElement);
                    }
                } else {
                    leaseMap.put(leaseIp, leaseElement);
                }
            }
            leaseElement = null;
        }
        Collection leases = leaseMap.values();
        ArrayList<DhcpdLeaseSettings> leaseList = new ArrayList<DhcpdLeaseSettings>(leases);
        return leaseList;
    }

    private static void setDhcpdSubnetOfIp(DhcpdLeaseSettings leaseElement, BDhcpdHostSettings dhcpdHostSettings) {
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpdSetting = (BDhcpdAdapterSettings)c.get();
            String net = IPAddressUtil.getIPv4NetworkPrefix((String)leaseElement.getIp(), (String)dhcpdSetting.getSubnetMask());
            if (IPAddressUtil.compare((Object)net, (Object)dhcpdSetting.getSubnet()) != 0) continue;
            leaseElement.setSubnet(net);
        }
    }

    private static int dhcpdLeaseToSettings(DhcpdLeaseSettings leaseElement, String[] allLines, int i) {
        boolean endOfLeaseBlock = false;
        boolean ignoreLease = false;
        while (!endOfLeaseBlock) {
            String line = allLines[i].trim();
            ++i;
            String[] words = line.split(" ");
            try {
                if (line.startsWith("}")) {
                    endOfLeaseBlock = true;
                } else if (line.startsWith("hardware ethernet")) {
                    String macId = words[2].substring(0, words[2].indexOf(";"));
                    leaseElement.setMacId(macId);
                } else if (line.startsWith(DHCPDLEASES_HOSTID)) {
                    String hostid = words[3].substring(1, words[3].lastIndexOf("\""));
                    leaseElement.setHostid(hostid);
                } else if (line.startsWith(DHCPDLEASES_PLATFORMPORT)) {
                    String platformPort = words[3].substring(1, words[3].lastIndexOf("\""));
                    leaseElement.setPlatformPort(Integer.parseInt(platformPort));
                } else if (line.startsWith(DHCPDLEASES_PLATFORMSPORT)) {
                    String platformsPort = words[3].substring(1, words[3].lastIndexOf("\""));
                    leaseElement.setPlatformsPort(Integer.parseInt(platformsPort));
                } else if (line.startsWith(DHCPDLEASES_USEPLATFORMS)) {
                    if ("true".equals(words[3].substring(1, words[3].lastIndexOf("\"")))) {
                        leaseElement.setUsePlatforms(true);
                    } else if ("false".equals(words[3].substring(1, words[3].lastIndexOf("\"")))) {
                        leaseElement.setUsePlatforms(false);
                    } else {
                        ignoreLease = true;
                    }
                } else if (line.startsWith(DHCPDLEASES_FOXPORT)) {
                    String foxPort = words[3].substring(1, words[3].lastIndexOf("\""));
                    leaseElement.setFoxPort(Integer.parseInt(foxPort));
                } else if (line.startsWith(DHCPDLEASES_FOXSPORT)) {
                    String foxsPort = words[3].substring(1, words[3].lastIndexOf("\""));
                    leaseElement.setFoxsPort(Integer.parseInt(foxsPort));
                } else if (line.startsWith(DHCPDLEASES_USEFOXS)) {
                    if ("true".equals(words[3].substring(1, words[3].lastIndexOf("\"")))) {
                        leaseElement.setUseFoxs(true);
                    } else if ("false".equals(words[3].substring(1, words[3].lastIndexOf("\"")))) {
                        leaseElement.setUseFoxs(false);
                    } else {
                        ignoreLease = true;
                    }
                } else if (line.startsWith(DHCPDLEASES_STATIONNAME)) {
                    String stationName = words[3].substring(1, words[3].lastIndexOf("\""));
                    leaseElement.setStationName(stationName);
                }
            }
            catch (Exception e) {
                ignoreLease = true;
                log.log(Level.FINE, "Bad dhcpd lease data: ", e);
            }
            if (!ignoreLease) continue;
            leaseElement.setIgnoreLease(true);
            ignoreLease = false;
            if (!log.isLoggable(Level.WARNING)) continue;
            log.warning("Bad dhcpd lease data from IP: " + leaseElement.getIp() + " mac: " + leaseElement.getMacId() + " line: " + i);
        }
        return i;
    }

    public static String[] loadDhcpdLeaseFile(BDhcpdHostSettings dhcpdHostSettings) {
        String[] fileContent = null;
        String filePath = dhcpdHostSettings.getDhcpdLeasePath();
        fileContent = AccessController.doPrivileged(() -> DhcpdUtil.getDhcpdLeaseFile(filePath));
        return fileContent;
    }

    private static synchronized String[] getDhcpdLeaseFile(String filePath) {
        File inFile = new File(filePath);
        String[] fileContent = null;
        try {
            fileContent = FileUtil.readLines((File)inFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileContent;
    }

    public static void loadDhcpdConfFile(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession session) throws Exception {
        String dhcpdConfPath = dhcpdHostSettings.getDhcpdConfPath();
        FilePath dhcpdConfFile = new FilePath(dhcpdConfPath);
        InputStream dhcpdConfStream = session.getInputStream(new GetFileMessage(dhcpdConfFile, session.getFileSpace()));
        if (dhcpdConfStream == null) {
            throw new NullPointerException("Missing dhcpd.conf file at: " + dhcpdConfPath);
        }
        DhcpdUtil.dhcpdConfToSettings(dhcpdHostSettings, dhcpdConfStream);
    }

    public static void fixDhcpdSettingWithAdapterInfo(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings hostSettings, BDaemonSession session) throws Exception {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            String propName = SlotPath.escape((String)adapter.getAdapterId());
            BDhcpdAdapterSettings dhcpdSetting = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
            if (dhcpdSetting == null || !DhcpdUtil.fixDhcpdSettings(dhcpdSetting, adapter.getIpAddress(), adapter.getSubnetMask())) continue;
            DhcpdUtil.saveToSession(dhcpdHostSettings, session);
        }
    }

    public static void fixDhcpdSettings(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings hostSettings) {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            String propName = SlotPath.escape((String)adapter.getAdapterId());
            BDhcpdAdapterSettings dhcpdSetting = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
            if (dhcpdSetting == null) continue;
            DhcpdUtil.fixDhcpdSettings(dhcpdSetting, adapter.getIpAddress(), adapter.getSubnetMask());
        }
    }

    public static void loadFromSessionWifi(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession session) throws Exception {
        InputStream dhcpdXmlStream = session.getInputStream(new GetDhcpdMessage());
        XElem dhcpdRootElem = XParser.make((InputStream)dhcpdXmlStream).parse();
        DhcpdUtil.dhcpdXmlToSettings(dhcpdHostSettings, dhcpdRootElem);
        String dhcpdConfPath = dhcpdHostSettings.getDhcpdConfPath();
        FilePath dhcpdConfFile = new FilePath(dhcpdConfPath);
        InputStream dhcpdConfStream = session.getInputStream(new GetFileMessage(dhcpdConfFile, session.getFileSpace()));
        if (dhcpdConfStream == null) {
            throw new NullPointerException("Missing dhcpd.conf file at: " + dhcpdConfPath);
        }
        DhcpdUtil.dhcpdConfToSettings(dhcpdHostSettings, dhcpdConfStream);
    }

    public static void saveToSession(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession session) throws Exception {
        if (!session.getHostProperties().supportsServlet(DHCPD_SERVLET_NAME)) {
            return;
        }
        FileTransferMessage msg = new FileTransferMessage(session.getFileSpace());
        String dhcpdConf = DhcpdUtil.settingsToDhcpdConf(dhcpdHostSettings, session);
        FilePath hostsPath = new FilePath(dhcpdHostSettings.getDhcpdConfPath());
        msg.addElement(new ByteArrayFileTransferElement(hostsPath, dhcpdConf.getBytes(), session.getFileSpace()));
        String adapterList = DhcpdUtil.saveToDhcpdAdaptersList(dhcpdHostSettings);
        hostsPath = new FilePath(dhcpdHostSettings.getDhcpdAdaptersListPath());
        msg.addElement(new ByteArrayFileTransferElement(hostsPath, adapterList.getBytes(), session.getFileSpace()));
        DaemonFileUtil.transfer(session, msg, null);
    }

    private static String saveToDhcpdAdaptersList(BDhcpdHostSettings dhcpdHostSettings) {
        StringBuilder adapterList = new StringBuilder();
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            if (adapterList.length() > 0) {
                adapterList.append(",");
            }
            BDhcpdAdapterSettings dhcpd = (BDhcpdAdapterSettings)c.get();
            String osname = DhcpdUtil.adapterIdToOsName(dhcpd.getName());
            if (!dhcpd.getIsDhcpdIpv4Enabled()) continue;
            adapterList.append(osname);
        }
        return adapterList.toString();
    }

    public static void saveToSessionNoTransfer(BDhcpdHostSettings dhcpdHostSettings, BDaemonSession session, FileTransferMessage msg) throws Exception {
        String dhcpdConf = DhcpdUtil.settingsToDhcpdConf(dhcpdHostSettings, session);
        FilePath dhcpdConfFile = new FilePath(dhcpdHostSettings.getDhcpdConfPath());
        msg.addElement(new ByteArrayFileTransferElement(dhcpdConfFile, dhcpdConf.getBytes(), session.getFileSpace()));
    }

    public static void dhcpdXmlToSettings(BDhcpdHostSettings dhcpdHostSettings, XElem dhcpdRootElem) {
        String dhcpdConfLocation = dhcpdRootElem.get("conf_file_path");
        dhcpdHostSettings.setDhcpdConfPath(dhcpdConfLocation);
        String leaseFilePath = dhcpdRootElem.get("lease_file_path");
        dhcpdHostSettings.setDhcpdLeasePath(leaseFilePath);
        String adaptersListPath = dhcpdRootElem.get("adapters_list_file_path");
        dhcpdHostSettings.setDhcpdAdaptersListPath(adaptersListPath);
        XElem adaptersElem = dhcpdRootElem.elem("adapters");
        HashSet<String> keyNames = new HashSet<String>();
        if (adaptersElem == null) {
            dhcpdHostSettings.getDhcpdSubnets().removeAll();
        } else {
            Property[] props;
            XElem[] adapterElems;
            for (XElem adapterElem : adapterElems = adaptersElem.elems("adapter")) {
                String propName = null;
                String adapterName = adapterElem.get("name");
                String adapterId = adapterElem.get("id");
                if (adapterId.trim().length() > 0) {
                    propName = SlotPath.escape((String)adapterId);
                }
                keyNames.add(propName);
                BDhcpdAdapterSettings dhcpdSetting = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
                if (dhcpdSetting == null) {
                    dhcpdSetting = new BDhcpdAdapterSettings();
                    dhcpdHostSettings.getDhcpdSubnets().add(propName, (BValue)dhcpdSetting);
                }
                DhcpdUtil.fillUpSubnetWithDefaults(dhcpdSetting);
                dhcpdSetting.setIsDhcpdIpv4Supported(adapterElem.getb("supported", false));
                dhcpdSetting.setIsDhcpdIpv4Enabled(adapterElem.getb("enabled", false));
            }
            for (Property eachProp : props = dhcpdHostSettings.getDhcpdSubnets().getPropertiesArray()) {
                if (keyNames.contains(eachProp.getName())) continue;
                dhcpdHostSettings.getDhcpdSubnets().remove(eachProp.getName());
            }
        }
    }

    private static void fillUpSubnetWithDefaults(BDhcpdAdapterSettings dhcpdSetting) {
        dhcpdSetting.setDefaultLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(DHCPD_DEFAULT_LEASE_TIMEVALUE)));
        dhcpdSetting.setMaxLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(DHCPD_MAX_LEASE_TIMEVALUE)));
        if (dhcpdSetting.getName().equals(DHCPD_ADAPTER_SAP_OSNAME)) {
            dhcpdSetting.setSubnetMask(DHCPDCONF_DEFAULT_SUBNETMASK);
            dhcpdSetting.setSubnet(DHCPDCONF_DEFAULT_SUBNET_WIFI);
            dhcpdSetting.setStartClientAddress(DHCPDCONF_DEFAULT_CLIENT_STARTIP_WIFI);
        } else {
            dhcpdSetting.setSubnetMask(DHCPDCONF_DEFAULT_SUBNETMASK);
            dhcpdSetting.setSubnet(DHCPDCONF_DEFAULT_SUBNET);
            dhcpdSetting.setStartClientAddress(DHCPDCONF_DEFAULT_CLIENT_STARTIP);
        }
        dhcpdSetting.setRange(16);
    }

    public static BDhcpdAdapterSettings getDhcpdDataSAP(BDhcpdHostSettings dhcpdHostSettings) {
        return (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(DHCPD_ADAPTER_SAP_OSNAME);
    }

    public static BDhcpdAdapterSettings getDhcpdData(BDhcpdHostSettings dhcpdHostSettings, String adapterName) {
        if (dhcpdHostSettings == null) {
            return null;
        }
        if (adapterName == null) {
            return null;
        }
        String propName = SlotPath.escape((String)adapterName);
        return (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
    }

    public static void copyDhcpdSlotToAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings hostSettings) {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            DhcpdUtil.adapterDhcpdSlotCopy(dhcpdHostSettings, adapter);
        }
    }

    private static void adapterDhcpdSlotCopy(BDhcpdHostSettings dhcpdHostSettings, BTcpIpAdapterSettings adapter) {
        String propName = SlotPath.escape((String)adapter.getAdapterId());
        BDhcpdAdapterSettings dhcpdSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
        if (dhcpdSettings != null) {
            if (adapter.get(DHCPD_SLOT_NAME) != null) {
                BDhcpdAdapterSettings currentSlot = (BDhcpdAdapterSettings)adapter.get(DHCPD_SLOT_NAME);
                currentSlot.copyFrom((BComplex)dhcpdSettings);
            } else {
                adapter.add(DHCPD_SLOT_NAME, dhcpdSettings.newCopy(), 3);
            }
        }
    }

    public static void copyDhcpdSlotFromAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings hostSettings) {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            DhcpdUtil.copyFromAdapterToDhcpdHostSettings(dhcpdHostSettings, adapter);
        }
    }

    private static void copyFromAdapterToDhcpdHostSettings(BDhcpdHostSettings dhcpdHostSetting, BTcpIpAdapterSettings adapter) {
        BDhcpdAdapterSettings adapterDhcpdSetting = (BDhcpdAdapterSettings)adapter.get(DHCPD_SLOT_NAME);
        if (adapterDhcpdSetting != null) {
            BDhcpdAdapterSettings dhcpdHostSettingsInstance = DhcpdUtil.getDhcpdData(dhcpdHostSetting, adapter.getAdapterId());
            dhcpdHostSettingsInstance.copyFrom((BComplex)adapterDhcpdSetting);
        }
    }

    public static void attachDhcpdSlotToAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings hostSettings) {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            DhcpdUtil.adapterDhcpdSlotAdd(dhcpdHostSettings, adapter);
        }
    }

    private static void adapterDhcpdSlotAdd(BDhcpdHostSettings dhcpdHostSettings, BTcpIpAdapterSettings adapter) {
        String propName = SlotPath.escape((String)adapter.getAdapterId());
        BDhcpdAdapterSettings dhcpdSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(propName);
        if (dhcpdSettings != null) {
            dhcpdHostSettings.getDhcpdSubnets().remove((BComplex)dhcpdSettings);
            if (adapter.get(DHCPD_SLOT_NAME) != null) {
                BDhcpdAdapterSettings currentSlot = (BDhcpdAdapterSettings)adapter.get(DHCPD_SLOT_NAME);
                currentSlot.copyFrom((BComplex)dhcpdSettings);
            } else {
                adapter.add(DHCPD_SLOT_NAME, (BValue)dhcpdSettings, 3);
            }
        }
    }

    public static void detachDhcpdSlotFromAdapters(BDhcpdHostSettings dhcpdHostSettings, BTcpIpHostSettings hostSettings) {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            DhcpdUtil.adapterDhcpdSlotRemove(dhcpdHostSettings, adapter);
        }
    }

    private static void adapterDhcpdSlotRemove(BDhcpdHostSettings dhcpdHostSetting, BTcpIpAdapterSettings adapter) {
        BDhcpdAdapterSettings dhcpdSetting = (BDhcpdAdapterSettings)adapter.get(DHCPD_SLOT_NAME);
        if (dhcpdSetting != null) {
            adapter.remove((BComplex)dhcpdSetting);
            String propName = SlotPath.escape((String)adapter.getAdapterId());
            dhcpdHostSetting.getDhcpdSubnets().add(propName, (BValue)dhcpdSetting);
        }
    }

    public static void setReadOnly(BDhcpdHostSettings dhcpdHostSettings) {
        SlotCursor c = dhcpdHostSettings.getDhcpdSubnets().loadSlots().getProperties();
        while (c.next()) {
            BDhcpdAdapterSettings dhcpd = (BDhcpdAdapterSettings)c.get();
            dhcpd.setIsReadOnly(true);
        }
    }

    protected static String getAdapterIdForSubnet(BTcpIpHostSettings hostSettings, String subnetWord) {
        SlotCursor c = hostSettings.getAdapters().loadSlots().getProperties();
        while (c.next()) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            String subnet = IPAddressUtil.getIPv4NetworkPrefix((String)adapter.getIpAddress(), (String)adapter.getSubnetMask());
            if (IPAddressUtil.compare((Object)subnet, (Object)subnetWord) != 0) continue;
            return adapter.getAdapterId();
        }
        return null;
    }

    public static String adapterIdToOsName(String adapterId) {
        String adapterOsName = null;
        StringBuilder genName = new StringBuilder();
        if (adapterId.equals(DHCPD_ADAPTER_SAP_OSNAME)) {
            adapterOsName = DHCPD_ADAPTER_SAP_OSNAME.trim();
        } else if (adapterId.toLowerCase().startsWith(DHCPD_ADAPTER_PREFIX_ID)) {
            genName.append(DHCPD_ADAPTER_PREFIX_OSNAME).append(adapterId.substring(2));
            adapterOsName = genName.toString().trim();
        }
        return adapterOsName;
    }

    public static String adapterOsNameToId(String adapterOsName) {
        String adapterId = null;
        StringBuilder genName = new StringBuilder();
        if (adapterOsName.equals(DHCPD_ADAPTER_SAP_OSNAME) || adapterOsName.equals(DHCPDCONF_MARKER_WIFI)) {
            adapterId = DHCPD_ADAPTER_SAP_OSNAME.trim();
        } else if (adapterOsName.toLowerCase().startsWith(DHCPD_ADAPTER_PREFIX_OSNAME)) {
            genName.append(DHCPD_ADAPTER_PREFIX_ID).append(adapterOsName.substring(2));
            adapterId = genName.toString().trim();
        }
        return adapterId;
    }

    private static boolean isAdapterOsName(String name) {
        return name.toLowerCase().startsWith(DHCPD_ADAPTER_PREFIX_OSNAME) || name.startsWith(DHCPDCONF_MARKER_WIFI);
    }

    private static boolean isAdapterId(String name) {
        return name.toLowerCase().startsWith(DHCPD_ADAPTER_PREFIX_ID);
    }

    public static void checkAdapterIpInDhcpdSubnet(BDhcpdAdapterSettings dhcpdSettings, String adapterIp, String adapterNetmask) throws Exception {
        if (IPAddressUtil.compare((Object)adapterNetmask, (Object)dhcpdSettings.getSubnetMask()) != 0) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.tcpipDhcpdv4InvalidMask");
        }
        String net = IPAddressUtil.getIPv4NetworkPrefix((String)adapterIp, (String)adapterNetmask);
        if (IPAddressUtil.compare((Object)net, (Object)dhcpdSettings.getSubnet()) != 0) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.dhcpdSubnetMismatchWithAdapterIp");
        }
    }

    public static void checkAdapterInDhcpdRange(BDhcpdAdapterSettings dhcpdSettings, String adapterIp, String adapterId) throws Exception {
        String ipAddressStr;
        String startDhcpStr = dhcpdSettings.getStartClientAddress();
        int range = dhcpdSettings.getRange();
        String endDhcpStr = DhcpdUtil.getEndIpAddress(range, startDhcpStr);
        if (adapterIp != null && IPAddressUtil.compare((Object)(ipAddressStr = adapterIp.trim()), (Object)startDhcpStr) != -1 && IPAddressUtil.compare((Object)ipAddressStr, (Object)endDhcpStr) != 1) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.adapterInClientRange");
        }
    }

    public static void checkAdapterDhcpdSetting(BDhcpdAdapterSettings dhcpdSettings, String adapterIpAddress, String adapterSubnetMask, String adapterId, int max) throws Exception {
        String dhcpdMask = dhcpdSettings.getSubnetMask();
        if (!IPAddressUtil.isIpv4SubnetMask((String)dhcpdMask)) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.invalidMask");
        }
        int r = dhcpdSettings.getRange();
        if (r < 1) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.rangeLessThanOne");
        }
        if (r > max) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.rangeTooBig");
        }
        String startDhcpStr = dhcpdSettings.getStartClientAddress();
        byte[] ipBytes = IPAddressUtil.numericStringToByteArray((String)startDhcpStr);
        int lastOctet = ipBytes[3] & 0xFF;
        int endLastOctet = lastOctet + r - 1;
        if (endLastOctet > 255) {
            throw new Exception("TcpIpAdapterEditorDhcpdError.endAddrTooBig");
        }
        if (dhcpdSettings.getIsDhcpdIpv4Enabled()) {
            DhcpdUtil.checkAdapterIpInDhcpdSubnet(dhcpdSettings, adapterIpAddress, adapterSubnetMask);
            DhcpdUtil.checkAdapterInDhcpdRange(dhcpdSettings, adapterIpAddress, adapterId);
        }
    }
}

