/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.platform.qnx.QnxCmdPage;
import com.tridium.sys.NreLib;
import java.security.AccessController;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;

class QnxDiagnosticsPage
extends SpyDir {
    QnxDiagnosticsPage() {
        this.add("df -k", (Spy)new QnxCmdPage("df -k", "/proc/boot/df -k"));
        this.add("ifconfig -a", (Spy)new QnxCmdPage("ifconfig -a", "/proc/boot/ifconfig -a"));
        String hostModel = NreLib.getHostModel();
        if (hostModel.equalsIgnoreCase("NPM3") || hostModel.equalsIgnoreCase("NPM6") || hostModel.equalsIgnoreCase("NPM6E")) {
            this.add("ndio status", (Spy)new QnxCmdPage("ndio status", "/proc/boot/ndioc status"));
        }
        this.add("netstat -A", (Spy)new QnxCmdPage("netstat -A", "/proc/boot/netstat -A"));
        this.add("nicinfo", (Spy)new QnxCmdPage("nicinfo", "/proc/boot/nicinfo"));
        this.add("pidin", (Spy)new QnxCmdPage("pidin", "/proc/boot/pidin"));
        this.add("pidin arg", (Spy)new QnxCmdPage("pidin arg", "/proc/boot/pidin arg"));
        this.add("pidin env", (Spy)new QnxCmdPage("pidin env", "/proc/boot/pidin env"));
        this.add("pidin family", (Spy)new QnxCmdPage("pidin family", "/proc/boot/pidin family"));
        this.add("pidin fds", (Spy)new QnxCmdPage("pidin fds", "/proc/boot/pidin fds"));
        this.add("pidin in", (Spy)new QnxCmdPage("pidin in", "/proc/boot/pidin in"));
        this.add("pidin mem", (Spy)new QnxCmdPage("pidin mem", "/proc/boot/pidin mem"));
        this.add("pidin pmem", (Spy)new QnxCmdPage("pidin pmem", "/proc/boot/pidin pmem"));
        this.add("pidin times", (Spy)new QnxCmdPage("pidin times", "/proc/boot/pidin times"));
        this.add("pidin ttimes", (Spy)new QnxCmdPage("pidin ttimes", "/proc/boot/pidin ttimes"));
        this.add("fd usage", (Spy)new QnxCmdPage("fd usage", "/proc/boot/fdcount -a"));
        this.add("flash disk usage", (Spy)new QnxCmdPage("flash disk usage", "/proc/boot/du -k /"));
        if (AccessController.doPrivileged(() -> System.getProperty("os.arch")).equalsIgnoreCase("ppc")) {
            this.add("flash statistics", (Spy)new QnxCmdPage("flash statistics", "/proc/boot/etfsctl -i"));
        }
        this.add("JMX Info", (Spy)new QnxCmdPage("JMX info", "jmxinfo"));
        if (hostModel.equalsIgnoreCase("NPM3") || hostModel.equalsIgnoreCase("NPM6") || hostModel.equalsIgnoreCase("NPM6E") || hostModel.equalsIgnoreCase("JVLN")) {
            this.add("etfs-watch", (Spy)new QnxCmdPage("etfs-watch", "/proc/boot/cat /tmp/etfs-watch-stats.txt"));
        }
    }

    public void write(SpyWriter out) throws Exception {
        String[] list;
        out.startTable(false);
        out.trTitle((Object)"Platform Diagnostics", 1);
        for (String name : list = this.list()) {
            String title = this.find(name).getTitle();
            if (title == null) {
                title = name;
            }
            out.w((Object)"<tr><td>").a(name, (Object)title).w((Object)"</td></tr>\n");
        }
        out.endTable();
    }
}

