/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.posix.BNtpHostMode;
import com.tridium.platform.posix.NtpConfUtil;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.sys.station.Station;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import javax.baja.file.BajaFileUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNtpPlatformServiceQnx
extends BNtpPlatformService {
    public static final Property timeServers = BNtpPlatformServiceQnx.newProperty((int)3, (BValue)new BNtpServerVector(), (BFacets)BFacets.make((String)"elementType", (String)"platform:NtpServerQnx"));
    public static final Property statistics = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property ntp = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)true, null);
    public static final Property localBackup = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)true, null);
    public static final Property panic = BNtpPlatformServiceQnx.newProperty((int)7, (int)0, null);
    public static final Property syncAtBoot = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property hostMode = BNtpPlatformServiceQnx.newProperty((int)3, (BValue)BNtpHostMode.server, null);
    public static final Action syncRTC = BNtpPlatformServiceQnx.newAction((int)4, null);
    public static final Action syncNow = BNtpPlatformServiceQnx.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BNtpPlatformServiceQnx.class);
    public static final String _NTP_CONF_PATH = Sys.getNiagaraUserHome() + "/etc/ntp.conf";
    public static final String _NTP_DRIFT_PATH = "/var/run/ntp.drift";
    public static final String _NTP_STATS_PATH = "/var/run/ntpdstats";
    public static final String _PERSISTENT_NTP_DRIFT_PATH = "/var/cookies/ntp.drift";
    private final NtpServiceSaveListener saveListener = new NtpServiceSaveListener();

    public boolean getStatistics() {
        return this.getBoolean(statistics);
    }

    public void setStatistics(boolean v) {
        this.setBoolean(statistics, v, null);
    }

    public boolean getNtp() {
        return this.getBoolean(ntp);
    }

    public void setNtp(boolean v) {
        this.setBoolean(ntp, v, null);
    }

    public boolean getLocalBackup() {
        return this.getBoolean(localBackup);
    }

    public void setLocalBackup(boolean v) {
        this.setBoolean(localBackup, v, null);
    }

    public int getPanic() {
        return this.getInt(panic);
    }

    public void setPanic(int v) {
        this.setInt(panic, v, null);
    }

    public boolean getSyncAtBoot() {
        return this.getBoolean(syncAtBoot);
    }

    public void setSyncAtBoot(boolean v) {
        this.setBoolean(syncAtBoot, v, null);
    }

    public BNtpHostMode getHostMode() {
        return (BNtpHostMode)this.get(hostMode);
    }

    public void setHostMode(BNtpHostMode v) {
        this.set(hostMode, (BValue)v, null);
    }

    public BInteger syncRTC() {
        return (BInteger)this.invoke(syncRTC, null, null);
    }

    public BInteger syncNow(BString args) {
        return (BInteger)this.invoke(syncNow, (BValue)args, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public final void stationStarted() throws Exception {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        if (this.isServiceStarted()) {
            Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)6), (Action)syncRTC, null);
        }
    }

    @Override
    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    @Override
    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    @Override
    public int getSlotFlags() {
        return 0;
    }

    @Override
    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.refreshProperties();
    }

    @Override
    public void doPoll(Context cx) {
        super.doPoll(cx);
        if (!this.isRunning()) {
            return;
        }
        this.checkPropertiesLoaded();
    }

    private synchronized void refreshProperties() {
        NtpConfUtil.loadFromFile(this);
    }

    @Override
    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        NtpConfUtil.saveToFile(this);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        NtpConfUtil.spyHelper(this, out);
    }

    public BInteger doSyncNow(BString defaultServer) {
        String targetServer;
        String preferredServer = null;
        String firstServerOrPeer = null;
        if (defaultServer != null && defaultServer.toString().trim().length() > 0) {
            targetServer = defaultServer.toString().trim();
        } else {
            SlotCursor c = this.getTimeServers().getProperties();
            while (c.next()) {
                if (!((BNtpServerQnx)c.get()).getServerPreferred()) continue;
                preferredServer = ((BNtpServerQnx)c.get()).getAddress().trim();
                break;
            }
            if (preferredServer == null) {
                c = this.getTimeServers().getProperties();
                while (c.next()) {
                    if (((BNtpServerQnx)c.get()).getPeerMode().getOrdinal() != 2 && ((BNtpServerQnx)c.get()).getPeerMode().getOrdinal() != 1) continue;
                    firstServerOrPeer = ((BNtpServerQnx)c.get()).getAddress().trim();
                    break;
                }
            }
            if (preferredServer != null) {
                targetServer = preferredServer;
            } else if (firstServerOrPeer != null) {
                targetServer = firstServerOrPeer;
            } else {
                return BInteger.make((int)1);
            }
        }
        if (!IPAddressUtil.isNumericAddr((String)targetServer) && !IPAddressUtil.isHostname((String)targetServer)) {
            throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{targetServer});
        }
        DoSyncThread doSyncThread = new DoSyncThread();
        DoSyncThread.targetServer = targetServer;
        doSyncThread.setDaemon(true);
        doSyncThread.start();
        return BInteger.make((int)0);
    }

    public BInteger doSyncRTC() {
        if (this.getEnabled()) {
            try {
                BSystemPlatformServiceQnx service = (BSystemPlatformServiceQnx)Sys.getService((Type)BSystemPlatformService.TYPE);
                if (!service.getIsSystemTimeReadonly()) {
                    service.setPlatformSystemTime(0L);
                }
            }
            catch (ServiceNotFoundException e) {
                e.printStackTrace();
                return BInteger.make((int)-1);
            }
        }
        return BInteger.make((int)0);
    }

    private final class NtpServiceSaveListener
    implements Station.SaveListener {
        private NtpServiceSaveListener() {
        }

        public final void stationSave() {
            AccessController.doPrivileged(() -> {
                try {
                    File etcNtpDrift = new File(BNtpPlatformServiceQnx._PERSISTENT_NTP_DRIFT_PATH);
                    File ntpDriftTEMP = new File("/var/run/ntp.drift.TEMP");
                    File ntpDrift = new File(BNtpPlatformServiceQnx._NTP_DRIFT_PATH);
                    if (etcNtpDrift.exists()) {
                        BajaFileUtil.delete((File)etcNtpDrift);
                    }
                    if (ntpDriftTEMP.exists()) {
                        BajaFileUtil.copy((File)ntpDriftTEMP, (File)etcNtpDrift);
                    } else if (ntpDrift.exists()) {
                        BajaFileUtil.copy((File)ntpDrift, (File)etcNtpDrift);
                    }
                    BNtpPlatformServiceQnx.this.syncRTC();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            });
        }

        public final void stationSaveOk() {
        }

        public final void stationSaveFail(String cause) {
        }

        public final String toString() {
            return "NtpServiceSaveListener " + BNtpPlatformServiceQnx.this.getNavOrd();
        }
    }

    private static class DoSyncThread
    extends Thread {
        private static String targetServer;

        private DoSyncThread() {
            super("NtpPlatformService:DoSyncThread");
        }

        @Override
        public void run() {
            if (!IPAddressUtil.isNumericAddr((String)targetServer) && !IPAddressUtil.isHostname((String)targetServer)) {
                throw new LocalizableRuntimeException("platform", "NtpServerFE.invalidHost", new Object[]{targetServer});
            }
            String command = "/proc/boot/ntpdate -u -s " + targetServer;
            AccessController.doPrivileged(() -> {
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            });
        }
    }
}

