/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.posix;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.npsdk.BNtpPlatformServiceNpsdk;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.posix.BNtpHostMode;
import com.tridium.platform.qnx.BNtpPlatformServiceQnx;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.SlotCursor;

public final class NtpConfUtil {
    private static final String MONITOR = "MONITOR";
    private static String versionString = null;
    private static final Logger log = Logger.getLogger("plat.ntp");

    private NtpConfUtil() {
    }

    public static synchronized void saveToFile(BNtpPlatformService service) throws Exception {
        String ntpConfigurationFilePath;
        if (service instanceof BNtpPlatformServiceQnx) {
            ntpConfigurationFilePath = BNtpPlatformServiceQnx._NTP_CONF_PATH;
        } else if (service instanceof BNtpPlatformServiceNpsdk) {
            ntpConfigurationFilePath = BNtpPlatformServiceNpsdk._NTP_CONF_PATH;
        } else {
            return;
        }
        NtpConfUtil.saveToFile(service, ntpConfigurationFilePath);
    }

    private static synchronized void saveToFile(BNtpPlatformService service, String ntpConfPath) throws Exception {
        BufferedWriter ntpConfOut;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Saving NTP settings to " + ntpConfPath + "...");
        }
        try {
            ntpConfOut = AccessController.doPrivileged(() -> {
                File ntpConfFile = new File(ntpConfPath);
                if (!ntpConfFile.exists()) {
                    if (!ntpConfFile.getParentFile().exists() && !ntpConfFile.getParentFile().mkdirs()) {
                        throw new Exception("Failed to create ntp configuration file at \"" + ntpConfPath + "\", could not make parent");
                    }
                    if (!ntpConfFile.createNewFile()) {
                        throw new Exception("Failed to create ntp configuration file at \"" + ntpConfPath + "\"");
                    }
                }
                return new BufferedWriter(new FileWriter(ntpConfPath));
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        ntpConfOut.write("#" + ntpConfPath + ": Niagara Network Time Protocol Configuration File\n");
        ntpConfOut.write("#Use the NtpPlatformService UI to modify this file.\n");
        ntpConfOut.write("#Created: " + BAbsTime.now() + "\n");
        ntpConfOut.write("#\n");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Write NTP enabled: " + service.getEnabled());
        }
        ntpConfOut.write("#Niagara NtpPlatformService variable, do not modify\n");
        ntpConfOut.write("#ntpEnabled " + service.getEnabled() + "\n");
        if (service instanceof BNtpPlatformServiceQnx) {
            BNtpPlatformServiceQnx serviceQnx = (BNtpPlatformServiceQnx)service;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Write sync at boot: " + serviceQnx.getSyncAtBoot());
            }
            ntpConfOut.write("#syncAtBoot " + serviceQnx.getSyncAtBoot() + "\n");
        }
        ntpConfOut.write("\n");
        ArrayList<String> servers = new ArrayList<String>();
        ArrayList<String> serverAddresses = new ArrayList<String>();
        if (service.getTimeServers().getPropertyCount() > 0) {
            ntpConfOut.write("#server list\n");
            SlotCursor c = service.getTimeServers().getProperties();
            while (c.next()) {
                BNtpServer ntpServer = (BNtpServer)c.get();
                String host = ntpServer.getAddress();
                if (!IPAddressUtil.isNumericAddr((String)host) && !IPAddressUtil.isHostname((String)host)) {
                    throw new Exception("Invalid NTP host specification \"" + host + "\"");
                }
                servers.add(ntpServer.getServerString());
                serverAddresses.add(host);
            }
            for (String serverString : servers) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Write server: " + serverString);
                }
                ntpConfOut.write(serverString + "\n");
            }
            ntpConfOut.write("\n");
        }
        boolean useLocalBackup = false;
        BNtpHostMode hostMode = BNtpHostMode.server;
        int panicValue = 1000;
        StringBuilder enabledString = new StringBuilder("enable");
        StringBuilder disabledString = new StringBuilder("disable");
        if (service instanceof BNtpPlatformServiceQnx) {
            BNtpPlatformServiceQnx serviceQnx = (BNtpPlatformServiceQnx)service;
            useLocalBackup = serviceQnx.getLocalBackup();
            panicValue = serviceQnx.getPanic();
            hostMode = serviceQnx.getHostMode();
            (serviceQnx.getNtp() ? enabledString : disabledString).append(" ntp");
            (serviceQnx.getStatistics() ? enabledString : disabledString).append(" stats");
        } else if (service instanceof BNtpPlatformServiceNpsdk) {
            BNtpPlatformServiceNpsdk serviceNpsdk = (BNtpPlatformServiceNpsdk)service;
            useLocalBackup = serviceNpsdk.getLocalBackup();
            panicValue = serviceNpsdk.getPanic();
            hostMode = serviceNpsdk.getHostMode();
            (serviceNpsdk.getNtp() ? enabledString : disabledString).append(" ntp");
            (serviceNpsdk.getStatistics() ? enabledString : disabledString).append(" stats");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Write use local backup: " + useLocalBackup);
        }
        if (useLocalBackup) {
            ntpConfOut.write("#local backup clock\n");
            ntpConfOut.write("server 127.127.1.0\n");
            ntpConfOut.write("fudge 127.127.1.0 stratum 10\n");
            ntpConfOut.write("\n");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Write host mode: " + (Object)((Object)hostMode));
        }
        if (hostMode == BNtpHostMode.serverTimeOnly) {
            ntpConfOut.write("#server (timeonly), restrict all non-time remote access\n");
            ntpConfOut.write("restrict default limited kod nomodify notrap nopeer noquery\n");
            ntpConfOut.write("restrict -6 default limited kod nomodify notrap nopeer noquery\n");
            ntpConfOut.write("\n");
            ntpConfOut.write("#localhost exemptions\n");
            ntpConfOut.write("restrict 127.0.0.1\n");
            ntpConfOut.write("restrict -6 ::1\n");
            ntpConfOut.write("\n");
        } else if (hostMode == BNtpHostMode.client) {
            ntpConfOut.write("#client only, restrict all remote access\n");
            ntpConfOut.write("restrict default ignore\n");
            ntpConfOut.write("restrict -6 default ignore\n");
            ntpConfOut.write("\n");
            ntpConfOut.write("#time server exemptions\n");
            for (String serverAddress : serverAddresses) {
                if (!IPAddressUtil.isIpv6Address((String)serverAddress)) {
                    ntpConfOut.write("restrict " + serverAddress + " nomodify notrap nopeer noquery\n");
                    continue;
                }
                ntpConfOut.write("restrict -6 " + serverAddress + " nomodify notrap nopeer noquery\n");
            }
            ntpConfOut.write("\n");
            ntpConfOut.write("#localhost exemptions\n");
            ntpConfOut.write("restrict 127.0.0.1\n");
            ntpConfOut.write("restrict -6 ::1\n");
            ntpConfOut.write("\n");
        }
        String enabledFeatures = enabledString.toString().trim();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Write enable features: " + enabledFeatures);
        }
        if (!enabledFeatures.equals("enable")) {
            ntpConfOut.write("#ntp features enabled\n");
            ntpConfOut.write(enabledFeatures + "\n");
            ntpConfOut.write("\n");
        }
        String disabledFeatures = disabledString.toString().trim();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Write disable features: " + disabledFeatures);
        }
        if (!disabledFeatures.equals("disable")) {
            ntpConfOut.write("#ntp features disabled\n");
            ntpConfOut.write(disabledFeatures + "\n");
            ntpConfOut.write("\n");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Write panic value: " + panicValue);
        }
        if (panicValue != 1000) {
            ntpConfOut.write("#ntp panic value, if offset exceeds this, ntpd should exit (disabled if 0)\n");
            ntpConfOut.write("tinker panic " + panicValue + "\n");
            ntpConfOut.write("\n");
        }
        ntpConfOut.write("#gather information about statistics\n");
        ntpConfOut.write("statistics clockstats loopstats\n");
        ntpConfOut.write("filegen clockstats file clockstats type none nolink enable\n");
        ntpConfOut.write("filegen loopstats file loopstats type none nolink enable\n");
        ntpConfOut.flush();
        ntpConfOut.close();
    }

    public static synchronized void loadFromFile(BNtpPlatformService service) {
        String ntpConfigurationFilePath;
        if (service instanceof BNtpPlatformServiceQnx) {
            ntpConfigurationFilePath = BNtpPlatformServiceQnx._NTP_CONF_PATH;
        } else if (service instanceof BNtpPlatformServiceNpsdk) {
            ntpConfigurationFilePath = BNtpPlatformServiceNpsdk._NTP_CONF_PATH;
        } else {
            return;
        }
        NtpConfUtil.loadFromFile(service, ntpConfigurationFilePath);
    }

    private static synchronized void loadFromFile(BNtpPlatformService service, String ntpConfPath) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading NTP settings from " + ntpConfPath + "...");
        }
        Array fileContents = new Array(String.class);
        AccessController.doPrivileged(() -> {
            try (BufferedReader fin2 = new BufferedReader(new FileReader(ntpConfPath));){
                String buf;
                while ((buf = fin2.readLine()) != null) {
                    fileContents.add((Object)buf.trim());
                }
            }
            catch (FileNotFoundException fin2) {
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Exception loading NTP settings, returning unmodified settings", ioe);
                ioe.printStackTrace();
            }
            return null;
        });
        boolean isEnabled = false;
        boolean checkConfFile = false;
        if (service instanceof BNtpPlatformServiceQnx) {
            checkConfFile = true;
        } else if (service instanceof BNtpPlatformServiceNpsdk) {
            checkConfFile = true;
        }
        if (checkConfFile) {
            for (Object line : fileContents) {
                if (!((String)line).startsWith("#ntpEnabled")) continue;
                int space = ((String)line).indexOf(" ");
                isEnabled = Boolean.valueOf(((String)line).substring(space).trim());
                break;
            }
        }
        service.setEnabled(isEnabled);
        if (service instanceof BNtpPlatformServiceQnx) {
            boolean syncAtBoot = false;
            for (String line : fileContents) {
                if (!line.startsWith("#syncAtBoot")) continue;
                int space = line.indexOf(" ");
                syncAtBoot = Boolean.valueOf(line.substring(space).trim());
                break;
            }
            ((BNtpPlatformServiceQnx)service).setSyncAtBoot(syncAtBoot);
        }
        Array ntpServers = new Array(String.class);
        for (String line : fileContents) {
            if (line.startsWith("server 127.127.1.0") || line.startsWith("server 127.127.1.1") || !line.startsWith("server") && !line.startsWith("peer") && !line.startsWith("broadcast") && !line.startsWith("manycastclient")) continue;
            ntpServers.add((Object)line);
        }
        service.getTimeServers().sync((String[])ntpServers.trim());
        boolean useLocalBackup = false;
        for (String line : fileContents) {
            if (!line.startsWith("server 127.127.1")) continue;
            useLocalBackup = true;
            break;
        }
        BNtpHostMode hostMode = BNtpHostMode.server;
        for (Object line : fileContents) {
            if (((String)line).startsWith("restrict default ignore")) {
                hostMode = BNtpHostMode.client;
                break;
            }
            if (!((String)line).startsWith("restrict default limited")) continue;
            hostMode = BNtpHostMode.serverTimeOnly;
            break;
        }
        int panicValue = service instanceof BNtpPlatformServiceQnx ? 0 : 1000;
        block5: for (String line : fileContents) {
            if (!line.startsWith("tinker")) continue;
            Iterator tok = new StringTokenizer(line);
            while (((StringTokenizer)((Object)tok)).hasMoreTokens()) {
                String buf = ((StringTokenizer)((Object)tok)).nextToken();
                if (!buf.equals("panic")) continue;
                panicValue = Integer.valueOf(((StringTokenizer)((Object)tok)).nextToken());
                break block5;
            }
            break block5;
        }
        StringBuilder enabledFeatures = new StringBuilder("enable");
        ArrayList<String> enableLines = new ArrayList<String>();
        for (String line : fileContents) {
            if (!line.startsWith("enable")) continue;
            enableLines.add(line.substring("enable".length()));
        }
        if (enableLines.size() != 0) {
            for (String enableLine : enableLines) {
                Iterator tokenizer = new StringTokenizer(enableLine);
                while (((StringTokenizer)((Object)tokenizer)).hasMoreTokens()) {
                    String token = ((StringTokenizer)((Object)tokenizer)).nextToken();
                    if (enabledFeatures.indexOf(token) != -1) continue;
                    enabledFeatures.append(" ").append(token);
                }
            }
        }
        StringBuilder disabledFeatures = new StringBuilder("disable");
        ArrayList<String> disableLines = new ArrayList<String>();
        for (String line : fileContents) {
            if (!line.startsWith("disable")) continue;
            disableLines.add(line.substring("disable".length()));
        }
        if (disableLines.size() != 0) {
            for (String disableLine : disableLines) {
                StringTokenizer tokenizer = new StringTokenizer(disableLine);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (disabledFeatures.indexOf(token) != -1) continue;
                    disabledFeatures.append(" ").append(token);
                }
            }
        }
        if (service instanceof BNtpPlatformServiceQnx) {
            BNtpPlatformServiceQnx serviceQnx = (BNtpPlatformServiceQnx)service;
            serviceQnx.setLocalBackup(useLocalBackup);
            serviceQnx.setPanic(panicValue);
            serviceQnx.setHostMode(hostMode);
            serviceQnx.setNtp(disabledFeatures.indexOf("ntp") == -1);
            serviceQnx.setStatistics(enabledFeatures.indexOf("stats") != -1);
        } else if (service instanceof BNtpPlatformServiceNpsdk) {
            BNtpPlatformServiceNpsdk serviceNpsdk = (BNtpPlatformServiceNpsdk)service;
            serviceNpsdk.setLocalBackup(useLocalBackup);
            serviceNpsdk.setPanic(panicValue);
            serviceNpsdk.setHostMode(hostMode);
            serviceNpsdk.setNtp(disabledFeatures.indexOf("ntp") == -1);
            serviceNpsdk.setStatistics(disabledFeatures.indexOf("stats") == -1);
        }
    }

    public static void spyHelper(BNtpPlatformService ntpPlatformService, SpyWriter out) throws Exception {
        String ntpStatsDir;
        String ntpDriftFile;
        String ntpConfigurationFilePath;
        boolean statsEnabled = false;
        if (ntpPlatformService instanceof BNtpPlatformServiceQnx) {
            ntpConfigurationFilePath = BNtpPlatformServiceQnx._NTP_CONF_PATH;
            ntpDriftFile = "/var/run/ntp.drift";
            ntpStatsDir = "/var/run/ntpdstats";
            statsEnabled = ((BNtpPlatformServiceQnx)ntpPlatformService).getStatistics();
        } else if (ntpPlatformService instanceof BNtpPlatformServiceNpsdk) {
            ntpConfigurationFilePath = BNtpPlatformServiceNpsdk._NTP_CONF_PATH;
            ntpDriftFile = "/var/lib/ntp/drift";
            ntpStatsDir = "/var/log/ntpstats";
            statsEnabled = ((BNtpPlatformServiceNpsdk)ntpPlatformService).getStatistics();
        } else {
            return;
        }
        boolean statsEnabledLambda = statsEnabled;
        AccessController.doPrivileged(() -> {
            Throwable throwable;
            BufferedReader fin;
            Object tempVersionString;
            String nextLine = null;
            if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
                out.startTable(true);
                out.trTitle((Object)"NTP Daemon Version", 1);
                String string = MONITOR;
                // MONITORENTER : "MONITOR"
                if (versionString == null) {
                    tempVersionString = null;
                    ProcessBuilder builder = new ProcessBuilder(TextUtil.split((String)"/proc/boot/ntpd --version", (char)' '));
                    builder.redirectErrorStream(true);
                    BufferedReader outputReader = null;
                    Process proc = null;
                    try {
                        proc = builder.start();
                        outputReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        tempVersionString = outputReader.readLine();
                    }
                    catch (Exception e) {
                        tempVersionString = "Error reading NTP Daemon version: " + e.getMessage();
                        log.log(Level.WARNING, "unable to determine ntpd version information", e);
                    }
                    finally {
                        if (outputReader != null) {
                            try {
                                outputReader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    versionString = tempVersionString;
                }
                // MONITOREXIT : string
                out.tr((Object)versionString);
                out.endTable();
            }
            out.startTable(true);
            out.trTitle((Object)"NTP Configuration File", 1);
            try {
                fin = new BufferedReader(new FileReader(ntpConfigurationFilePath));
                tempVersionString = null;
                try {
                    while ((nextLine = fin.readLine()) != null) {
                        out.tr((Object)nextLine.trim());
                    }
                }
                catch (Throwable throwable2) {
                    tempVersionString = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fin != null) {
                        if (tempVersionString != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)tempVersionString).addSuppressed(throwable3);
                            }
                        } else {
                            fin.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                out.tr((Object)("Error reading " + ntpConfigurationFilePath + ": " + e.getMessage()));
            }
            out.endTable();
            out.startTable(true);
            out.trTitle((Object)"NTP Daemon Drift", 1);
            try {
                fin = new BufferedReader(new FileReader(ntpDriftFile + ".TEMP"));
                tempVersionString = null;
                try {
                    while ((nextLine = fin.readLine()) != null) {
                        out.tr((Object)nextLine.trim());
                    }
                }
                catch (Throwable throwable4) {
                    tempVersionString = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fin != null) {
                        if (tempVersionString != null) {
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)tempVersionString).addSuppressed(throwable5);
                            }
                        } else {
                            fin.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                try {
                    throwable = null;
                    try (BufferedReader fin2 = new BufferedReader(new FileReader(ntpDriftFile));){
                        while ((nextLine = fin2.readLine()) != null) {
                            out.tr((Object)nextLine.trim());
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                catch (IOException ioe2) {
                    out.tr((Object)("Error reading " + ntpDriftFile + ": " + ioe2.getMessage()));
                }
            }
            out.endTable();
            if (statsEnabledLambda) {
                Throwable ioe2;
                out.startTable(true);
                out.trTitle((Object)"NTP Daemon Clock Stats", 1);
                out.tr((Object)"Modified Julian Day | Secs. Past UTC Midnight | Clock Address | Last Time Code");
                try {
                    fin = new BufferedReader(new FileReader(ntpStatsDir + File.separator + "clockstats"));
                    ioe2 = null;
                    try {
                        while ((nextLine = fin.readLine()) != null) {
                            out.tr((Object)nextLine.trim());
                        }
                    }
                    catch (Throwable throwable7) {
                        ioe2 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (fin != null) {
                            if (ioe2 != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable throwable8) {
                                    ioe2.addSuppressed(throwable8);
                                }
                            } else {
                                fin.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    out.tr((Object)("Error reading " + ntpStatsDir + File.separator + "clockstats: " + e.getMessage()));
                }
                out.endTable();
                out.startTable(true);
                out.trTitle((Object)"NTP Daemon Loop Stats", 1);
                out.tr((Object)"Modified Julian Day | Secs. Past UTC Midnight | Time Offset Secs. | Drift Compensation | Estimated Error | Stability | Polling Interval");
                try {
                    fin = new BufferedReader(new FileReader(ntpStatsDir + File.separator + "loopstats"));
                    ioe2 = null;
                    try {
                        while ((nextLine = fin.readLine()) != null) {
                            out.tr((Object)nextLine.trim());
                        }
                    }
                    catch (Throwable throwable9) {
                        ioe2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (fin != null) {
                            if (ioe2 != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable throwable10) {
                                    ioe2.addSuppressed(throwable10);
                                }
                            } else {
                                fin.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    out.tr((Object)("Error reading " + ntpStatsDir + File.separator + "loopstats: " + e.getMessage()));
                }
                out.endTable();
            }
            if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) return null;
            out.startTable(true);
            out.trTitle((Object)"NTP Daemon Log Messages", 1);
            try {
                Process child = Runtime.getRuntime().exec("/proc/boot/slog2info");
                try {
                    throwable = null;
                    try (BufferedReader fin2 = new BufferedReader(new InputStreamReader(child.getInputStream()));){
                        while ((nextLine = fin2.readLine()) != null) {
                            if (!nextLine.contains("ntpd")) continue;
                            out.tr((Object)nextLine.trim());
                        }
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                }
                catch (IOException e) {
                    out.tr((Object)("Error reading NTP Daemon Log: " + e.getMessage()));
                }
            }
            catch (Exception e) {
                out.tr((Object)("Error reading NTP Daemon Log: " + e.getMessage()));
            }
            out.endTable();
            return null;
        });
    }
}

