/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.license.IFileInfo;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.util.TimeFormat;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.LexiconText;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class LicenseInfo
implements IFileInfo {
    public VendorLicense vendorLicense;
    public Optional<byte[]> encoded = Optional.empty();
    public BIFile file = null;
    private static LexiconText neverExpiresFmt = LexiconText.make((String)"platform", (String)"LicenseInfo.neverExpiresFormat");
    private static LexiconText defaultFmt = LexiconText.make((String)"platform", (String)"LicenseInfo.format");
    private static LexiconText expirationDateNever = LexiconText.make((String)"platform", (String)"LicenseInfo.expirationDate.never");

    public static LicenseInfo[] make(BIFile[] files) throws Exception {
        if (files == null) {
            return new LicenseInfo[0];
        }
        LicenseInfo[] result = new LicenseInfo[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new LicenseInfo(files[i]);
        }
        return result;
    }

    public static LicenseInfo[] make(XElem[] licenses) throws Exception {
        if (licenses == null) {
            return new LicenseInfo[0];
        }
        LicenseInfo[] infos = new LicenseInfo[licenses.length];
        for (int i = 0; i < licenses.length; ++i) {
            infos[i] = new LicenseInfo(licenses[i]);
        }
        return infos;
    }

    public static LicenseInfo[] make(VendorLicense[] licenses) throws Exception {
        if (licenses == null) {
            return new LicenseInfo[0];
        }
        LicenseInfo[] result = new LicenseInfo[licenses.length];
        for (int i = 0; i < licenses.length; ++i) {
            result[i] = new LicenseInfo(licenses[i], null);
        }
        return result;
    }

    public static LicenseInfo[] listLocal() {
        Array result = new Array(LicenseInfo.class);
        BDirectory licenseDir = (BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getLicensesDirPath(true));
        for (BIFile kid : licenseDir.listFiles()) {
            if (!(kid instanceof BLicenseFile)) continue;
            try {
                result.add((Object)new LicenseInfo(kid));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (LicenseInfo[])result.trim();
    }

    public static Feature.Brand getLocalBrandFeature() {
        if (Nre.bootEnv.isRemote()) {
            return null;
        }
        String localBrandId = Brand.getBrandId();
        if (localBrandId == null) {
            return null;
        }
        for (LicenseInfo file : LicenseInfo.listLocal()) {
            if (!file.vendorLicense.getHostId().equals(Sys.getHostId()) || !localBrandId.equals(file.getBrand())) continue;
            return file.vendorLicense.getBrandFeature();
        }
        return null;
    }

    public static int countActiveLicenses(LicenseInfo[] licenses, BAbsTime time) {
        if (licenses == null) {
            return 0;
        }
        int active = 0;
        for (LicenseInfo license : licenses) {
            if (license.isExpired(time)) continue;
            ++active;
        }
        return active;
    }

    public LicenseInfo(XElem license) throws Exception {
        this(license, null);
    }

    public LicenseInfo(BIFile file) throws Exception {
        this(XParser.make((InputStream)file.getInputStream()).parse(true), file);
    }

    public LicenseInfo(XElem license, BIFile file) throws Exception {
        this(VendorLicense.make((String)(file == null ? "LicenseInfo" : file.getFileName()), (XElem)license), file);
        XElem withoutSignature = license;
        if (withoutSignature.elem("signature") != null) {
            withoutSignature = license.deepcopy();
            withoutSignature.removeContent((XContent)withoutSignature.elem("signature"));
        }
        this.encoded = Optional.of(LicenseUtil.encode((XElem)withoutSignature));
    }

    public LicenseInfo(VendorLicense vendorLicense, BIFile file) {
        this.vendorLicense = vendorLicense;
        this.file = file;
    }

    public LicenseInfo(InputStream contentStream) throws Exception {
        this(contentStream, true);
    }

    public LicenseInfo(InputStream contentStream, boolean close) throws Exception {
        this(XParser.make((InputStream)contentStream).parse(close), null);
    }

    public boolean isExpired() {
        return this.isExpired(BAbsTime.now());
    }

    public boolean isExpired(BAbsTime time) {
        return this.vendorLicense.getExpiration() != 0L && this.vendorLicense.getExpiration() < time.getMillis();
    }

    public String getBrand() {
        return this.vendorLicense.getBrandId();
    }

    public boolean allowsLocalWbAccess() {
        return this.allowsWbAccess(LicenseInfo.getLocalBrandFeature());
    }

    public boolean allowsLocalStationAccess() {
        return this.allowsStationAccess(LicenseInfo.getLocalBrandFeature());
    }

    public boolean allowsWbAccess(Feature.Brand checkBrand) {
        Feature.Brand against = this.vendorLicense.getBrandFeature();
        if (checkBrand == null || against == null) {
            return true;
        }
        Brand.AcceptList inCheck = new Brand.AcceptList("accept.wb.in", against.getWbIn());
        boolean result = inCheck.accept(checkBrand.getBrandId());
        Brand.AcceptList outCheck = new Brand.AcceptList("accept.wb.out", checkBrand.getWbOut());
        result = result && outCheck.accept(against.getBrandId());
        return result;
    }

    public boolean allowsStationAccess(Feature.Brand checkBrand) {
        Feature.Brand against = this.vendorLicense.getBrandFeature();
        if (checkBrand == null || against == null) {
            return true;
        }
        Brand.AcceptList inCheck = new Brand.AcceptList("accept.station.in", against.getStationIn());
        boolean result = inCheck.accept(checkBrand.getBrandId());
        Brand.AcceptList outCheck = new Brand.AcceptList("accept.station.out", checkBrand.getStationOut());
        result = result && outCheck.accept(against.getBrandId());
        return result;
    }

    @Override
    public String getInstalledFileName() {
        return this.getBaseName() + ".license";
    }

    public String getBaseName() {
        String brand = this.vendorLicense.getBrandId();
        if (brand != null) {
            return TextUtil.capitalize((String)brand);
        }
        return TextUtil.capitalize((String)this.vendorLicense.getVendor());
    }

    @Override
    public String getXmlContent() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.vendorLicense.save((OutputStream)bytes);
            return bytes.toString();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Optional<byte[]> getEncodedLicense() throws Exception {
        if (this.encoded.isPresent()) {
            return this.encoded;
        }
        if (this.file == null) {
            return Optional.empty();
        }
        XElem withoutSignature = XParser.make((InputStream)this.file.getInputStream()).parse(true);
        if (withoutSignature.elem("signature") != null) {
            withoutSignature = withoutSignature.deepcopy();
            withoutSignature.removeContent((XContent)withoutSignature.elem("signature"));
        }
        return Optional.of(LicenseUtil.encode((XElem)withoutSignature));
    }

    @Override
    public String getXmlSummary() {
        return LicenseInfo.getXmlSummary(this.vendorLicense);
    }

    public static String getXmlSummary(VendorLicense license) {
        StringBuilder result = new StringBuilder();
        result.append("<licenseSummary ");
        result.append("hostid=\"").append(license.getHostId()).append("\" ");
        result.append("vendor=\"").append(license.getVendor()).append("\" ");
        String brand = license.getBrandId();
        if (brand != null) {
            result.append("brand=\"").append(brand).append("\" ");
        }
        result.append("expiration=\"").append(license.getExpiration()).append("\" ");
        result.append("signature=\"").append(license.getSignature()).append("\"/>");
        return result.toString();
    }

    @Override
    public FilePath getInstalledFilePath(boolean forNiagara4) {
        return SystemFilePaths.getLicensesDirPath(forNiagara4).merge(this.getInstalledFileName());
    }

    @Override
    public void write(OutputStream out) throws Exception {
        this.write(out, true);
    }

    @Override
    public void write(OutputStream out, boolean close) throws Exception {
        this.vendorLicense.save(out, close);
    }

    public String toString() {
        return this.toString(null);
    }

    public static String getSummaryText(VendorLicense vendorLicense, Context cx) {
        return LicenseInfo.getSummaryText(vendorLicense.getLicenseName() + ".license", vendorLicense, cx);
    }

    @Override
    public String toString(Context cx) {
        String fileName = this.file != null && this.file instanceof BLicenseFile ? this.file.getFileName() : this.getInstalledFileName();
        return LicenseInfo.getSummaryText(fileName, this.vendorLicense, cx);
    }

    public static String getSummaryText(String fileName, VendorLicense vendorLicense, Context cx) {
        if (vendorLicense.getExpiration() == Long.MAX_VALUE) {
            return neverExpiresFmt.getText(cx, new Object[]{fileName, vendorLicense.getVendor(), vendorLicense.getVersion()});
        }
        return defaultFmt.getText(cx, new Object[]{fileName, vendorLicense.getVendor(), vendorLicense.getVersion(), LicenseUtil.formatDate((long)vendorLicense.getExpiration())});
    }

    public String formatExpirationDate(Context cx) {
        return LicenseInfo.formatExpirationDate(this.vendorLicense.getExpiration(), cx);
    }

    public static String formatExpirationDate(long timestamp, Context cx) {
        return timestamp == Long.MAX_VALUE ? expirationDateNever.getText(cx) : TimeFormat.formatDate((BAbsTime)BAbsTime.make((long)timestamp), (Context)cx);
    }

    @Override
    public BIFile getFile() {
        return this.file;
    }
}

