/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorCertificate;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.util.LexiconText;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class CertificateInfo
implements IFileInfo {
    public VendorCertificate vendorCertificate;
    public BIFile file;
    public Optional<byte[]> encoded = Optional.empty();
    private static final Logger logger = Logger.getLogger("platform");
    private static final LexiconText neverExpiresFmt = LexiconText.make((String)"platform", (String)"CertificateInfo.neverExpiresFormat");
    private static final LexiconText defaultFmt = LexiconText.make((String)"platform", (String)"CertificateInfo.format");

    public static CertificateInfo[] make(BIFile[] files) throws Exception {
        if (files == null) {
            return new CertificateInfo[0];
        }
        CertificateInfo[] result = new CertificateInfo[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new CertificateInfo(files[i]);
        }
        return result;
    }

    public static CertificateInfo[] make(XElem[] certs) throws Exception {
        if (certs == null) {
            return new CertificateInfo[0];
        }
        CertificateInfo[] result = new CertificateInfo[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            result[i] = new CertificateInfo(certs[i]);
        }
        return result;
    }

    public static CertificateInfo[] make(VendorCertificate[] certs) throws Exception {
        if (certs == null) {
            return new CertificateInfo[0];
        }
        CertificateInfo[] result = new CertificateInfo[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            result[i] = new CertificateInfo(certs[i], null);
        }
        return result;
    }

    public static CertificateInfo[] listLocal() {
        ArrayList<CertificateInfo> result = new ArrayList<CertificateInfo>();
        BDirectory certsDir = (BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getCertificatesDirPath(true));
        for (BIFile file : certsDir.listFiles()) {
            if (!(file instanceof BCertificateFile)) continue;
            try {
                result.add(new CertificateInfo(file));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create CertificateInfo for file '" + file + "', ignoring result", e);
            }
        }
        return result.toArray(new CertificateInfo[0]);
    }

    public CertificateInfo(XElem certificate) throws Exception {
        this(certificate, null);
    }

    public CertificateInfo(BIFile file) throws Exception {
        this(XParser.make((InputStream)file.getInputStream()).parse(true), file);
    }

    public CertificateInfo(XElem certificate, BIFile file) throws Exception {
        this(VendorCertificate.make((String)(file == null ? "CertificateInfo" : file.getFileName()), (XElem)certificate), file);
        XElem withoutSignature = certificate;
        if (withoutSignature.elem("signature") != null) {
            withoutSignature = certificate.deepcopy();
            withoutSignature.removeContent((XContent)withoutSignature.elem("signature"));
        }
        this.encoded = Optional.of(LicenseUtil.encode((XElem)withoutSignature));
    }

    public CertificateInfo(VendorCertificate vendorCertificate, BIFile file) {
        this.vendorCertificate = vendorCertificate;
        this.file = file;
    }

    public CertificateInfo(InputStream contentStream) throws Exception {
        this(contentStream, true);
    }

    public CertificateInfo(InputStream contentStream, boolean close) throws Exception {
        this(XParser.make((InputStream)contentStream).parse(close), null);
    }

    @Override
    public String getInstalledFileName() {
        return TextUtil.capitalize((String)this.vendorCertificate.getVendor()) + ".certificate";
    }

    @Override
    public String getXmlContent() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.vendorCertificate.save((OutputStream)bytes);
            return bytes.toString();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getXmlSummary() {
        return CertificateInfo.getXmlSummary(this.vendorCertificate);
    }

    public static String getXmlSummary(VendorCertificate cert) {
        return String.format("<certificateSummary vendor=\"%s\" expiration=\"%s\" signature=\"%s\"/>", cert.getVendor(), LicenseUtil.formatDate((long)cert.getExpiration()), cert.getSignature());
    }

    public Optional<byte[]> getEncodedCertificate() throws Exception {
        if (this.encoded.isPresent()) {
            return this.encoded;
        }
        if (this.file == null) {
            return Optional.empty();
        }
        XElem withoutSignature = XParser.make((InputStream)this.file.getInputStream()).parse(true);
        if (withoutSignature.elem("signature") != null) {
            withoutSignature = withoutSignature.deepcopy();
            withoutSignature.removeContent((XContent)withoutSignature.elem("signature"));
        }
        return Optional.of(LicenseUtil.encode((XElem)withoutSignature));
    }

    @Override
    public FilePath getInstalledFilePath(boolean forNiagara4) {
        return SystemFilePaths.getCertificatesDirPath(true).merge(this.getInstalledFileName());
    }

    @Override
    public void write(OutputStream out) throws Exception {
        this.write(out, true);
    }

    @Override
    public void write(OutputStream out, boolean close) throws Exception {
        this.vendorCertificate.save(out, close);
    }

    public String toString() {
        return this.toString(null);
    }

    public static String getSummaryText(VendorCertificate vendorCert, Context cx) {
        return CertificateInfo.getSummaryText(vendorCert.getVendor() + ".certificate", vendorCert, cx);
    }

    @Override
    public String toString(Context cx) {
        String fileName = this.file != null && this.file instanceof BCertificateFile ? this.file.getFileName() : this.getInstalledFileName();
        return CertificateInfo.getSummaryText(fileName, this.vendorCertificate, cx);
    }

    public static String getSummaryText(String fileName, VendorCertificate vendorCert, Context cx) {
        if (vendorCert.getExpiration() == Long.MAX_VALUE) {
            return neverExpiresFmt.getText(cx, new Object[]{fileName, vendorCert.getVendor()});
        }
        return defaultFmt.getText(cx, new Object[]{fileName, vendorCert.getVendor(), LicenseUtil.formatDate((long)vendorCert.getExpiration())});
    }

    public boolean verify(LicenseInfo license) {
        try {
            return LicenseUtil.verify((byte[])license.getEncodedLicense().get(), (byte[])Base64.getMimeDecoder().decode(license.vendorLicense.getSignature()), (byte[])Base64.getMimeDecoder().decode(this.vendorCertificate.getPublicKey()), (String)this.vendorCertificate.getPublicKeyAlgorithm());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifyCertificate() {
        try {
            return LicenseUtil.verify((byte[])this.getEncodedCertificate().get(), (byte[])Base64.getMimeDecoder().decode(this.vendorCertificate.getSignature()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public BIFile getFile() {
        return this.file;
    }
}

