/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.platform.SystemFilePaths;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.Set;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.sys.BajaRuntimeException;

public class BrandProps {
    private Properties props;
    private static BrandProps LOCAL_INSTANCE = null;

    public BrandProps(BFileSpace space) {
        try {
            AccessController.doPrivileged(() -> {
                block14: {
                    try {
                        BIFile propsFile = space.findFile(SystemFilePaths.getBrandPropsPath((BIFileSpace)space));
                        if (propsFile == null) break block14;
                        try (InputStream in = propsFile.getInputStream();){
                            this.props = new Properties();
                            this.props.load(in);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException("Error loading brand.properties", (Throwable)e);
        }
    }

    public String get(String key, String def) {
        return this.props == null ? def : this.props.getProperty(key, def);
    }

    public boolean get(String key, boolean def) {
        return this.props == null ? def : this.props.getProperty(key, def ? "true" : "false").equals("true");
    }

    public int get(String key, int def) {
        return this.props == null ? def : Integer.parseInt(this.props.getProperty(key, Integer.toString(def)));
    }

    public String[] getKeys() {
        if (null == this.props) {
            return new String[0];
        }
        Set<String> keys = this.props.stringPropertyNames();
        return keys.toArray(new String[keys.size()]);
    }

    public static BrandProps getLocalInstance() {
        if (LOCAL_INSTANCE == null) {
            LOCAL_INSTANCE = new BrandProps((BFileSpace)BFileSystem.INSTANCE);
        }
        return LOCAL_INSTANCE;
    }
}

