/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.platform.license.BVendorLicenseSummary;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.sys.license.dom.VendorLicense;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class BEnvLicenseSummary
extends BComponent {
    public static final Property hostId = BEnvLicenseSummary.newProperty((int)1, (String)"", null);
    public static final Property brandIdString = BEnvLicenseSummary.newProperty((int)1, (String)"", null);
    public static final Property vendorInfo = BEnvLicenseSummary.newProperty((int)1, (BValue)new BVector(), null);
    public static final Type TYPE = Sys.loadType(BEnvLicenseSummary.class);

    public String getHostId() {
        return this.getString(hostId);
    }

    public void setHostId(String v) {
        this.setString(hostId, v, null);
    }

    public String getBrandIdString() {
        return this.getString(brandIdString);
    }

    public void setBrandIdString(String v) {
        this.setString(brandIdString, v, null);
    }

    public BVector getVendorInfo() {
        return (BVector)this.get(vendorInfo);
    }

    public void setVendorInfo(BVector v) {
        this.set(vendorInfo, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BEnvLicenseSummary() {
    }

    public BEnvLicenseSummary(String hostId) {
        this(hostId, null);
    }

    public BEnvLicenseSummary(String hostId, String brandId) {
        this.setHostId(hostId);
        this.setBrandId(brandId);
    }

    public static BEnvLicenseSummary make(XElem xml) {
        XElem[] vendorInfo;
        BEnvLicenseSummary result = new BEnvLicenseSummary(xml.get("hostId"), xml.get("brandId", null));
        for (XElem aVendorInfo : vendorInfo = xml.elems("vendorInfo")) {
            result.updateVendorInfo(aVendorInfo.get("vendor"), BVendorLicenseSummary.make(aVendorInfo));
        }
        return result;
    }

    public static BEnvLicenseSummary make(LicenseInfo info) {
        return BEnvLicenseSummary.make(info.vendorLicense);
    }

    public static BEnvLicenseSummary[] make(LicenseInfo[] info) {
        VendorLicense[] licenses = new VendorLicense[info.length];
        for (int i = 0; i < info.length; ++i) {
            licenses[i] = info[i].vendorLicense;
        }
        return BEnvLicenseSummary.make(licenses);
    }

    public static BEnvLicenseSummary[] make(VendorLicense[] licenses) {
        HashSet<String> hostIds = new HashSet<String>();
        HashMap<String, HashMap<String, VendorLicense>> tridiumByHostId = new HashMap<String, HashMap<String, VendorLicense>>();
        HashMap<String, Array> nonTridiumByHostId = new HashMap<String, Array>();
        for (VendorLicense license1 : licenses) {
            String hostId = license1.getHostId();
            hostIds.add(hostId);
            if (license1.getVendor().equalsIgnoreCase("tridium")) {
                HashMap<String, VendorLicense> licenseByBrand = (HashMap<String, VendorLicense>)tridiumByHostId.get(hostId);
                if (licenseByBrand == null) {
                    licenseByBrand = new HashMap<String, VendorLicense>();
                    tridiumByHostId.put(hostId, licenseByBrand);
                }
                licenseByBrand.put(license1.getBrandId(), license1);
                continue;
            }
            Array nonTridiumList = (Array)nonTridiumByHostId.get(hostId);
            if (nonTridiumList == null) {
                nonTridiumList = new Array(VendorLicense.class);
                nonTridiumByHostId.put(hostId, nonTridiumList);
            }
            nonTridiumList.add((Object)license1);
        }
        Array result = new Array(BEnvLicenseSummary.class);
        for (String hostId : hostIds) {
            Map licenseByBrand = (Map)tridiumByHostId.get(hostId);
            Array nonTridiumList = (Array)nonTridiumByHostId.get(hostId);
            if (licenseByBrand == null) {
                BEnvLicenseSummary summary = new BEnvLicenseSummary(hostId);
                if (nonTridiumList != null) {
                    for (int i = 0; i < nonTridiumList.size(); ++i) {
                        VendorLicense license = (VendorLicense)nonTridiumList.get(i);
                        summary.updateVendorInfo(license);
                    }
                }
                result.add((Object)summary);
                continue;
            }
            for (String brandId : licenseByBrand.keySet()) {
                BEnvLicenseSummary summary = new BEnvLicenseSummary(hostId, brandId);
                VendorLicense license = (VendorLicense)licenseByBrand.get(brandId);
                summary.updateVendorInfo(license);
                if (nonTridiumList != null) {
                    for (int i = 0; i < nonTridiumList.size(); ++i) {
                        license = (VendorLicense)nonTridiumList.get(i);
                        summary.updateVendorInfo(license);
                    }
                }
                result.add((Object)summary);
            }
        }
        return (BEnvLicenseSummary[])result.trim();
    }

    public static BEnvLicenseSummary make(VendorLicense license) {
        BEnvLicenseSummary result = new BEnvLicenseSummary(license.getHostId(), license.getBrandId());
        result.updateVendorInfo(license);
        return result;
    }

    public String getBrandId() {
        String result = this.getBrandIdString();
        return result.length() == 0 ? null : result;
    }

    public void setBrandId(String value) {
        this.setBrandIdString(value == null ? "" : value);
    }

    public String[] getVendors() {
        Array result = new Array(String.class);
        SlotCursor c = this.getVendorInfo().getProperties();
        while (c.next(BVendorLicenseSummary.class)) {
            result.add((Object)SlotPath.unescape((String)((Property)c.slot()).getName()));
        }
        return (String[])result.trim();
    }

    public String getLicenseSignature(String vendor) {
        BVendorLicenseSummary vendorInfo = this.getVendorInfo(vendor);
        return vendorInfo == null ? null : vendorInfo.getLicenseSignature();
    }

    public long getLicenseGenerated(String vendor) {
        BVendorLicenseSummary vendorInfo = this.getVendorInfo(vendor);
        return vendorInfo == null ? Long.MIN_VALUE : vendorInfo.getLicenseGenerated();
    }

    public Version getTridiumVersion() {
        BVendorLicenseSummary vendorInfo = this.getVendorInfo("tridium");
        return vendorInfo == null ? null : vendorInfo.getLicenseVersion();
    }

    public BVendorLicenseSummary getVendorInfo(String vendor) {
        SlotCursor c = this.getVendorInfo().getProperties();
        while (c.next()) {
            if (!SlotPath.unescape((String)c.property().getName()).toLowerCase().equals(vendor.toLowerCase())) continue;
            return (BVendorLicenseSummary)c.get();
        }
        return null;
    }

    public void updateVendorInfo(String vendor, BVendorLicenseSummary info) {
        BVendorLicenseSummary existing = this.getVendorInfo(vendor);
        if (existing == null) {
            this.getVendorInfo().add(SlotPath.escape((String)vendor), (BValue)info);
        } else {
            existing.update(info);
        }
    }

    public void updateVendorInfo(VendorLicense license) {
        BVendorLicenseSummary existing = this.getVendorInfo(license.getVendor());
        if (existing == null) {
            this.updateVendorInfo(license.getVendor(), BVendorLicenseSummary.make(license));
        } else {
            existing.update(license);
        }
    }

    public XElem asXml() {
        XElem result = new XElem("licenseSummary");
        result.setAttr("hostId", this.getHostId());
        if (this.getBrandId() != null) {
            result.setAttr("brandId", this.getBrandId());
        }
        SlotCursor c = this.getVendorInfo().getProperties();
        while (c.next(BVendorLicenseSummary.class)) {
            result.addContent((XContent)((BVendorLicenseSummary)c.get()).asXml());
        }
        result.setAttr("clientVersion", Sys.getBajaVersion().toString(2));
        return result;
    }
}

