/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;

public class TaskDispatcher
implements DaemonSessionTaskListener {
    private Array<DaemonSessionTask> tasks = new Array(DaemonSessionTask.class);
    private FoxCircuit circuit;

    public TaskDispatcher(FoxCircuit circuit) {
        this.circuit = circuit;
    }

    @Override
    public synchronized void taskStarted(DaemonSessionTask task) {
        try {
            this.tasks.add((Object)task);
            FoxMessage message = new FoxMessage();
            message.add("type", "taskStatus");
            message.add("id", "started");
            message.add("title", task.getTitle());
            message.add("message", task.getMessage());
            message.add("total", task.getTotal());
            message.add("immediate", task.isImmediate());
            message.add("taskindex", this.tasks.size() - 1);
            this.circuit.writeMessage(message);
            this.circuit.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public synchronized void taskUpdated(DaemonSessionTask task) {
        try {
            int taskindex = this.tasks.indexOf((Object)task);
            if (taskindex < 0) {
                this.taskStarted(task);
            }
            FoxMessage message = new FoxMessage();
            message.add("type", "taskStatus");
            message.add("id", "updated");
            message.add("immediate", task.isImmediate());
            message.add("progress", task.getProgress());
            message.add("message", task.getMessage());
            message.add("taskindex", taskindex);
            this.circuit.writeMessage(message);
            this.circuit.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public synchronized void taskFinished(DaemonSessionTask task) {
        try {
            int taskindex = this.tasks.indexOf((Object)task);
            if (taskindex < 0) {
                return;
            }
            FoxMessage message = new FoxMessage();
            message.add("type", "taskStatus");
            message.add("id", "finished");
            message.add("immediate", task.isImmediate());
            message.add("progress", task.getProgress());
            message.add("message", task.getMessage());
            message.add("taskindex", taskindex);
            this.circuit.writeMessage(message);
            this.circuit.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isCancelEnabled() {
        return false;
    }
}

