/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.platform.fox.MessageClient;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.sys.BajaRuntimeException;

public class ChunkedInputStream
extends InputStream {
    private FoxCircuit circuit;
    private byte[] chunk = null;
    private int nextRead = -1;
    private MessageClient[] messageClients;

    public ChunkedInputStream(FoxCircuit circuit) {
        this(circuit, new MessageClient[0]);
    }

    public ChunkedInputStream(FoxCircuit circuit, MessageClient[] messageClients) {
        this.circuit = circuit;
        this.messageClients = messageClients;
    }

    @Override
    public int read() throws IOException {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        byte result = this.chunk[this.nextRead];
        ++this.nextRead;
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        int toCopy = len > avail ? avail : len;
        System.arraycopy(this.chunk, this.nextRead, b, off, toCopy);
        this.nextRead += toCopy;
        return toCopy;
    }

    @Override
    public int available() throws IOException {
        try {
            if (this.chunk == null || this.nextRead >= this.chunk.length) {
                boolean keepReading = true;
                FoxMessage msg = null;
                block4: while (keepReading) {
                    keepReading = false;
                    msg = this.circuit.readMessage();
                    for (int i = 0; i < this.messageClients.length; ++i) {
                        if (!this.messageClients[i].handleMessage(msg)) continue;
                        keepReading = true;
                        continue block4;
                    }
                }
                this.chunk = msg.getBlob("chunk");
                this.nextRead = 0;
            }
            return this.chunk.length - this.nextRead;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.circuit.writeMessage(new FoxMessage());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }
}

