/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.license.BLicensePlatformService;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

public class BLicenseChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BLicenseChannel.class);

    public Type getType() {
        return TYPE;
    }

    public BLicenseChannel() {
        super("license");
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command.equals("listcertificates")) {
            return this.listcertificates(request);
        }
        if (command.equals("listlicenses")) {
            return this.listlicenses(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command.equals("read")) {
            this.read(circuit);
            return;
        }
        if (command.equals("write")) {
            this.write(circuit);
            return;
        }
        if (command.equals("delete")) {
            this.delete(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public BIFile[] listcertificates(BFoxFileSpace space) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:listcertificates");
        }
        FoxRequest req = this.makeRequest("listcertificates");
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] messages = resp.list("file");
        BFoxFileStore[] stores = new BFoxFileStore[messages.length];
        for (int i = 0; i < stores.length; ++i) {
            FoxMessage msg = (FoxMessage)messages[i];
            String name = msg.getString("name");
            stores[i] = BFileChannel.msgToStore((BFoxFileSpace)space, (FilePath)SystemFilePaths.getCertificatesDirPath(true).merge(name), (FoxMessage)msg);
        }
        BIFile[] files = new BIFile[stores.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = space.makeFile((BIFileStore)stores[i]);
        }
        return files;
    }

    public FoxResponse listcertificates(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listcertificates");
        }
        FoxResponse resp = new FoxResponse(req);
        FilePath path = SystemFilePaths.getCertificatesDirPath(true);
        try {
            AccessController.doPrivileged(() -> {
                BIFile file = BFileSystem.INSTANCE.resolveFile(path);
                if (file instanceof BIDirectory) {
                    BIDirectory dir = (BIDirectory)file;
                    BIFile[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        BPermissions permissions = this.getPermissionsFor(files[i]);
                        FoxMessage msg = new FoxMessage("file");
                        msg.add("name", files[i].getStore().getFileName());
                        msg.add("dir", files[i].getStore().isDirectory());
                        msg.add("readonly", files[i].getStore().isReadonly() || !permissions.has(BPermissions.operatorWrite));
                        msg.add("modified", files[i].getStore().getLastModified().getMillis());
                        msg.add("size", String.valueOf(files[i].getStore().getSize()));
                        msg.add("permissions", permissions.encodeToString());
                        resp.add((FoxTuple)msg);
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return resp;
    }

    public BIFile[] listlicenses(BFoxFileSpace space) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:listlicenses");
        }
        FoxRequest req = this.makeRequest("listlicenses");
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] messages = resp.list("file");
        BFoxFileStore[] stores = new BFoxFileStore[messages.length];
        for (int i = 0; i < stores.length; ++i) {
            FoxMessage msg = (FoxMessage)messages[i];
            String name = msg.getString("name");
            stores[i] = BFileChannel.msgToStore((BFoxFileSpace)space, (FilePath)SystemFilePaths.getLicensesDirPath(true).merge(name), (FoxMessage)msg);
        }
        BIFile[] files = new BIFile[stores.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = space.makeFile((BIFileStore)stores[i]);
        }
        return files;
    }

    public FoxResponse listlicenses(FoxRequest req) throws Exception {
        if (this.isTraceOn()) {
            this.trace("s:listlicenses");
        }
        FoxResponse resp = new FoxResponse(req);
        FilePath path = SystemFilePaths.getLicensesDirPath(true);
        try {
            AccessController.doPrivileged(() -> {
                BIFile file = BFileSystem.INSTANCE.resolveFile(path);
                if (file instanceof BIDirectory) {
                    BIDirectory dir = (BIDirectory)file;
                    BIFile[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        BPermissions permissions = this.getPermissionsFor(files[i]);
                        FoxMessage msg = new FoxMessage("file");
                        msg.add("name", files[i].getStore().getFileName());
                        msg.add("dir", files[i].getStore().isDirectory());
                        msg.add("readonly", files[i].getStore().isReadonly() || !permissions.has(BPermissions.operatorWrite));
                        msg.add("modified", files[i].getStore().getLastModified().getMillis());
                        msg.add("size", String.valueOf(files[i].getStore().getSize()));
                        msg.add("permissions", permissions.encodeToString());
                        resp.add((FoxTuple)msg);
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        return resp;
    }

    public InputStream read(BFoxFileStore store) throws Exception {
        FilePath path = store.getFilePath();
        if (this.isTraceOn()) {
            this.trace("c:read \"" + path.getBody() + "\"");
        }
        if (!path.getBody().startsWith(SystemFilePaths.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(SystemFilePaths.getLicensesDirPath(true).getBody())) {
            return null;
        }
        FoxCircuit circuit = this.openCircuit("read");
        FoxMessage messageOut = new FoxMessage();
        messageOut.add("path", store.getFilePath().getBody());
        circuit.writeMessage(messageOut);
        circuit.flush();
        return circuit.getInputStream();
    }

    public void read(FoxCircuit circuit) throws Exception {
        FoxMessage messageIn = circuit.readMessage();
        FilePath path = new FilePath(messageIn.getString("path"));
        if (!path.getBody().startsWith(SystemFilePaths.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(SystemFilePaths.getLicensesDirPath(true).getBody())) {
            return;
        }
        if (this.isTraceOn()) {
            this.trace("s:read \"" + path.getBody() + "\"");
        }
        try {
            AccessController.doPrivileged(() -> {
                BIFile file = BFileSystem.INSTANCE.resolveFile(path);
                long size = file.getSize();
                InputStream in = file.getInputStream();
                OutputStream out = circuit.getOutputStream();
                try {
                    BajaFileUtil.pipe((InputStream)in, (long)size, (OutputStream)out);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                    try {
                        circuit.close();
                    }
                    catch (Exception exception) {}
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public OutputStream write(BFoxFileStore store) throws Exception {
        FilePath path = store.getFilePath();
        if (this.isTraceOn()) {
            this.trace("c:write \"" + path.getBody() + "\"");
        }
        if (!path.getBody().startsWith(SystemFilePaths.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(SystemFilePaths.getLicensesDirPath(true).getBody())) {
            return null;
        }
        FoxCircuit circuit = this.openCircuit("write");
        FoxMessage messageOut = new FoxMessage();
        messageOut.add("path", path.getBody());
        messageOut.add("size", String.valueOf(store.getSize()));
        circuit.writeMessage(messageOut);
        circuit.flush();
        return circuit.getOutputStream();
    }

    public void write(FoxCircuit circuit) throws Exception {
        BLicensePlatformService lps = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxMessage messageIn = circuit.readMessage();
        FilePath path = new FilePath(messageIn.getString("path"));
        long size = Long.parseLong(messageIn.getString("size"));
        if (!path.getBody().startsWith(SystemFilePaths.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(SystemFilePaths.getLicensesDirPath(true).getBody())) {
            return;
        }
        if (this.isTraceOn()) {
            this.trace("s:write \"" + path.getBody() + "\"");
        }
        try {
            AccessController.doPrivileged(() -> {
                BIFile file = BFileSystem.INSTANCE.makeFile(path);
                InputStream in = circuit.getInputStream();
                OutputStream out = file.getOutputStream();
                try {
                    BajaFileUtil.pipe((InputStream)in, (long)size, (OutputStream)out);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                    try {
                        circuit.close();
                    }
                    catch (Exception exception) {}
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public OutputStream delete(BFoxFileStore store) throws Exception {
        FilePath path = store.getFilePath();
        if (this.isTraceOn()) {
            this.trace("c:delete \"" + path.getBody() + "\"");
        }
        if (!path.getBody().startsWith(SystemFilePaths.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(SystemFilePaths.getLicensesDirPath(true).getBody())) {
            return null;
        }
        FoxCircuit circuit = this.openCircuit("delete");
        FoxMessage msgout = new FoxMessage();
        msgout.add("path", path.getBody());
        circuit.writeMessage(msgout);
        circuit.flush();
        return circuit.getOutputStream();
    }

    public void delete(FoxCircuit circuit) throws Exception {
        BLicensePlatformService lps = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps);
        if (!BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)lps).hasAdminInvoke()) {
            throw new PermissionException("insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        FoxMessage messageIn = circuit.readMessage();
        FilePath path = new FilePath(messageIn.getString("path"));
        if (!path.getBody().startsWith(SystemFilePaths.getCertificatesDirPath(true).getBody()) && !path.getBody().startsWith(SystemFilePaths.getLicensesDirPath(true).getBody())) {
            return;
        }
        if (this.isTraceOn()) {
            this.trace("s:delete \"" + path.getBody() + "\"");
        }
        try {
            AccessController.doPrivileged(() -> {
                BFileSystem.INSTANCE.delete(path);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }
}

