/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.platform.daemon.message.DaemonMessage;
import java.text.MessageFormat;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;

public abstract class XmlResponseMessage
extends DaemonMessage {
    private XElem response = null;
    private String errorMessage = null;
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_INCOMPLETE = 1;
    public static final int STATUS_ERROR = 2;

    @Override
    public final String getMethod() {
        return "GET";
    }

    public XElem getResponse() {
        return this.response;
    }

    public void setResponse(XElem value) {
        this.response = value;
    }

    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            if (this.response == null) {
                throw new IllegalStateException("no response to check");
            }
            XElem statusElem = this.response;
            if (statusElem.name().equals("error")) {
                if (statusElem.elem("message") != null) {
                    statusElem = statusElem.elem("message");
                }
                String text = null;
                XElem msgElem = statusElem.elem("localized");
                if (msgElem != null) {
                    XElem[] argElems = msgElem.elems("lexArg");
                    String[] argStrings = new String[argElems.length];
                    for (int i = 0; i < argElems.length; ++i) {
                        argStrings[i] = argElems[i].get("value");
                    }
                    text = Lexicon.make((String)msgElem.get("module")).get(msgElem.get("key"), null);
                    if (text != null && argStrings.length > 0) {
                        text = MessageFormat.format(text, argStrings);
                    }
                }
                if (text == null && (msgElem = statusElem.elem("nonlocalized")) != null) {
                    text = msgElem.get("text");
                }
                if (text != null) {
                    this.errorMessage = text;
                }
            }
        }
        return this.errorMessage;
    }

    public int getStatus() {
        if (this.errorMessage == null) {
            if (this.response == null) {
                return 1;
            }
            if (this.response.name().equals("error")) {
                return 2;
            }
        } else {
            return 2;
        }
        return 0;
    }
}

