/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;

public class UpdateSSLSettingsMessage
extends XmlResponseMessage {
    private StringBuffer path;
    private BPlatformSSLSettings settings;

    public UpdateSSLSettingsMessage(BPlatformSSLSettings settings, boolean includeAlgorithm) {
        this.settings = settings;
        try {
            this.path = new StringBuffer("updatedaemon");
            this.path.append("?sslEnabled=").append(settings.getSslEnabled()).append("&sslOnly=").append(settings.getSslOnly()).append("&sslPort=").append(settings.getSslPort()).append("&tlsCipherSuiteGroup=").append(settings.getTlsCipherSuiteGroup().getTag()).append("&tlsUseExtendedMasterSecret=").append(settings.getUseExtendedMasterSecret());
            if (includeAlgorithm) {
                this.path.append("&sslAlgType=").append(settings.getSslAlgType().getTag());
            }
            String alias = settings.getKeyAlias().toLowerCase(Locale.ENGLISH);
            try {
                alias = URLEncoder.encode(alias, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                alias = alias.replaceAll(" ", "");
            }
            this.path.append("&keyAlias=").append(alias);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMessageString() {
        return this.path.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    public BPlatformSSLSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getConnectionFlags() {
        return 12;
    }
}

