/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import java.security.AccessController;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.security.BPassword;

public class SystemPasswordMessage
extends EncryptableXmlResponseMessage {
    private String oldPasswordEncoding;
    private String newPasswordEncoding;
    private boolean checkIfValid;

    public SystemPasswordMessage() {
    }

    public SystemPasswordMessage(BPassword newPassword, BPassword oldPassword, boolean checkIfValid, SharedSecretKey sharedSecretKey) throws Exception {
        this.sharedSecretKey = sharedSecretKey;
        this.oldPasswordEncoding = oldPassword == null ? null : this.prepareMessage(AccessController.doPrivileged(() -> ((BPassword)oldPassword).getValue()));
        this.newPasswordEncoding = newPassword == null ? null : this.prepareMessage(AccessController.doPrivileged(() -> ((BPassword)newPassword).getValue()));
        this.checkIfValid = checkIfValid;
    }

    @Override
    public boolean requiresSharedKey() {
        return false;
    }

    @Override
    public String getMessageString() {
        StringBuilder messageString = new StringBuilder();
        messageString.append("systempw");
        if (this.checkIfValid) {
            messageString.append("?check=true");
            if (this.oldPasswordEncoding != null) {
                messageString.append("&oldSystemPassword=").append(this.oldPasswordEncoding);
                messageString.append("&").append("sharedKeyName").append("=").append(this.sharedSecretKey.getName());
            } else if (this.newPasswordEncoding != null) {
                messageString.append("&systemPassword=").append(this.newPasswordEncoding);
                messageString.append("&").append("sharedKeyName").append("=").append(this.sharedSecretKey.getName());
            }
        } else if (this.newPasswordEncoding != null && this.oldPasswordEncoding != null) {
            messageString.append("?update=true");
            messageString.append("&oldSystemPassword=").append(this.oldPasswordEncoding);
            messageString.append("&").append("sharedKeyName").append("=").append(this.sharedSecretKey.getName());
            messageString.append("&systemPassword=").append(this.newPasswordEncoding);
        }
        return messageString.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        if (this.oldPasswordEncoding == null && this.newPasswordEncoding == null) {
            return false;
        }
        return !this.checkIfValid;
    }
}

