/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.UserAccount;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import com.tridium.platform.daemon.message.IUserUpdate;

public class AddUserMessage
extends EncryptableXmlResponseMessage
implements IUserUpdate {
    private boolean sendAsHash;
    private UserAccount account;

    public AddUserMessage(UserAccount account) {
        this(account, false);
    }

    public AddUserMessage(UserAccount account, boolean sendAsHash) {
        this.account = account;
        this.sendAsHash = sendAsHash;
    }

    @Override
    public String getMessageString() {
        StringBuilder buf = new StringBuilder("acctmgt?update=adduser&user=");
        buf.append(this.prepareMessage(this.account.getFullyQualifiedName()));
        buf.append("&comment=");
        buf.append(HttpUtil.encodeUrl((String)this.account.getComment()));
        buf.append("&password=");
        buf.append(this.prepareMessage(this.account.getPassword()));
        buf.append("&hash=");
        buf.append(this.sendAsHash ? "true" : "false");
        buf.append("&").append("sharedKeyName").append("=");
        buf.append(this.sharedSecretKey.getName());
        return buf.toString();
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    public UserAccount getAccount() {
        return this.account;
    }

    @Override
    public String getUsername() {
        return this.account.getAccountName();
    }
}

