/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import java.io.IOException;
import java.net.ConnectException;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDefaultDaemonFileSpace
extends BDaemonFileSpace {
    public static final Type TYPE = Sys.loadType(BDefaultDaemonFileSpace.class);
    private static final BIcon icon = BIcon.std((String)"drive.png");
    private BOrd ordInSession = BOrd.make((String)"file:");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BDaemonSession getDaemonSession() {
        return (BDaemonSession)this.getNavParent();
    }

    @Override
    protected void init() throws ConnectException, AuthenticationException {
        if (this.roots != null) {
            return;
        }
        super.init();
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String navName) {
        try {
            this.init();
            for (int i = 0; i < this.roots.length; ++i) {
                if (!this.roots[i].getFileName().equals(navName)) continue;
                return this.roots[i];
            }
            return null;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BINavNode[] getNavChildren() {
        try {
            this.init();
            return (BINavNode[])this.roots.clone();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    @Override
    public String getNavDescription(Context cx) {
        return this.getLexicon().getText("DaemonFileSpace.navDesc");
    }

    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void delete(FilePath path, Context cx) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    @Override
    public BIFile findFile(FilePath path, BCacheAccessPolicy cachePolicy) {
        try {
            BIFileStore store = this.findStore(null, path, false, false, cachePolicy);
            if (store == null) {
                return null;
            }
            if (store instanceof BDaemonDirectoryStore) {
                return new BDirectory(store);
            }
            return this.makeFile(store);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public BIFileStore findStore(FilePath path) {
        try {
            return this.findStore(null, path, false, false, BCacheAccessPolicy.lazyFetch);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public BIFileStore findStore(FilePath path, BCacheAccessPolicy policy) {
        try {
            return this.findStore(null, path, false, false, policy);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BIFileStore findStore(StoreCache cache, FilePath path, boolean recurseDirs, boolean sendCrc) throws AuthenticationException, IOException {
        return this.findStore(cache, path, recurseDirs, sendCrc, BCacheAccessPolicy.lazyFetch);
    }

    public BIFileStore findStore(StoreCache cache, FilePath path, boolean recurseDirs, boolean sendCrc, BCacheAccessPolicy cachePolicy) throws AuthenticationException, IOException {
        BAbstractFileStore store;
        int cacheStatus = cachePolicy == BCacheAccessPolicy.forceFetch || cache == null ? 2 : cache.getCacheStatus(path);
        if (cacheStatus == 1) {
            return null;
        }
        if (cacheStatus == 0) {
            return cache.getStore(path);
        }
        if (cachePolicy == BCacheAccessPolicy.cacheOnly) {
            return null;
        }
        FileHeaderInfo header = DaemonFileUtil.getFileHeaderInfo(this.getDaemonSession(), new FileHeaderMessage(path, this));
        if (header == null) {
            if (cache != null) {
                cache.cacheNotFound(path);
            }
            return null;
        }
        if (header.isDirectory()) {
            store = BDaemonDirectoryStore.make(this, path, recurseDirs, sendCrc, false, cache);
        } else if (path.depth() == 1 || !sendCrc) {
            store = new BDaemonFileStore(this, path, header.getContentLength(), -1L);
            if (cache != null) {
                cache.cacheResult((BIFileStore)store);
            }
        } else {
            BDaemonDirectoryStore parentStore = BDaemonDirectoryStore.make(this, path.getParent(), recurseDirs, true, false, cache);
            if (parentStore == null) {
                store = new BDaemonFileStore(this, path, header.getContentLength(), -1L);
                if (cache != null) {
                    cache.cacheResult((BIFileStore)store);
                }
            } else {
                store = parentStore.getChild(path.getName());
            }
        }
        return store;
    }

    @Override
    public BIFile getChild(BIFile parent, String childName, BCacheAccessPolicy cachePolicy) {
        if (parent.isDirectory()) {
            BDaemonDirectoryStore store = (BDaemonDirectoryStore)parent.getStore();
            BIFileStore childStore = store.getChild(childName, cachePolicy);
            return childStore == null ? null : this.makeFile(childStore);
        }
        return null;
    }

    @Override
    public BIFile[] getChildren(BIFile parent, BCacheAccessPolicy cachePolicy) {
        if (parent.isDirectory()) {
            BDaemonDirectoryStore store = (BDaemonDirectoryStore)parent.getStore();
            Array<BIFileStore> kids = store.getChildren(cachePolicy);
            BIFile[] result = new BIFile[kids.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.makeFile((BIFileStore)kids.get(i));
            }
            return result;
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }
}

