/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.net.HttpDateFormat;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.message.BogFileHeaderMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.GetBogFileMessage;
import com.tridium.platform.daemon.message.GetFileMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;

public class BDaemonFileStore
extends BAbstractFileStore {
    public static final Type TYPE = Sys.loadType(BDaemonFileStore.class);
    private String fileUri;
    private long size;
    private long crc;
    private BAbsTime lastModified = BAbsTime.NULL;
    private boolean transcodeBog = true;
    private static Lexicon lex = Lexicon.make((String)"platform");

    public Type getType() {
        return TYPE;
    }

    public BDaemonFileStore(BDaemonFileSpace space, FilePath path) {
        this(space, path, -1L, -1L);
    }

    public BDaemonFileStore(BDaemonFileSpace space, FilePath path, long size, long crc) {
        super((BFileSpace)space, path);
        this.fileUri = space.filePathToUri(path);
        this.size = size;
        this.crc = crc;
    }

    public BDaemonFileStore(BDaemonFileSpace space, FilePath path, XElem elem) {
        this(space, path, Long.parseLong(elem.get("size", "-1")), Long.parseLong(elem.get("crc", "-1")));
        String lastModStr = elem.get("lastModified", null);
        if (lastModStr != null) {
            this.lastModified = BAbsTime.make((long)HttpDateFormat.parse((String)lastModStr));
        }
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public BDaemonFileSpace getDaemonFileSpace() {
        return (BDaemonFileSpace)this.getFileSpace();
    }

    public BAbsTime getLastModified() {
        return this.lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public long getCrc() throws IOException {
        if (this.crc == -1L) {
            this.crc = 0L;
            FileHeaderMessage msg = null;
            msg = this.getFilePath().toString().endsWith(".bog") ? new BogFileHeaderMessage(this.getFilePath(), this.getDaemonFileSpace(), true, this.transcodeBog) : new FileHeaderMessage(this.getFilePath(), this.getDaemonFileSpace(), true);
            FileHeaderInfo info = DaemonFileUtil.getFileHeaderInfo(this.getDaemonSession(), msg);
            if (info != null && info.getCrc() > -1L) {
                this.crc = info.getCrc();
            } else {
                try {
                    this.crc = BajaFileUtil.getCrc((InputStream)this.getInputStream());
                }
                catch (IOException ioe) {
                    throw new LocalizableRuntimeException("platform", "LocalFile.exception.readCrc", (Throwable)ioe);
                }
            }
        }
        return this.crc;
    }

    public boolean isReadonly() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        GetFileMessage msg = this.getFilePath().toString().endsWith(".bog") ? new GetBogFileMessage(this.getFilePath(), this.getDaemonFileSpace(), this.transcodeBog) : new GetFileMessage(this.getFilePath(), this.getDaemonFileSpace());
        return this.getDaemonSession().getInputStream((DaemonMessage)msg, msg.getMessageTimeout());
    }

    public BDaemonSession getDaemonSession() {
        return ((BDaemonFileSpace)this.getFileSpace()).getDaemonSession();
    }

    public boolean copyToLocalHost() throws ConnectException, AuthenticationException {
        return this.copyToLocalHost(this.getFilePath(), null);
    }

    public boolean copyToLocalHost(FilePath destPath) throws ConnectException, AuthenticationException {
        return this.copyToLocalHost(destPath, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyToLocalHost(FilePath destPath, DaemonSessionTaskListener listener) throws ConnectException, AuthenticationException {
        InputStream in;
        OutputStream out;
        if (!this.getFilePath().isSysHomeAbsolute() && !this.getFilePath().isUserHomeAbsolute()) {
            throw new IllegalStateException("Only system and user absolute files can be copied to local host");
        }
        DaemonSessionTask task = null;
        if (listener != null) {
            task = new DaemonSessionTask(lex, "DaemonFileStore.copyToLocalHost.title", "DaemonFileStore.copyToLocalHost.message", new Object[]{destPath.getBody()}, (int)this.size);
            task.setProgress(0);
        }
        try {
            if (listener != null) {
                listener.taskStarted(task);
            }
            BIFile newFile = BFileSystem.INSTANCE.makeFile(destPath);
            out = newFile.getOutputStream();
            in = this.getInputStream();
            if (in == null) {
                boolean bl = false;
                if (listener == null) return bl;
                listener.taskFinished(task);
                return bl;
            }
        }
        catch (ConnectException | AuthenticationException ce) {
            try {
                throw ce;
                catch (Exception e) {
                    throw new LocalizableRuntimeException("platform", "RemoteFile.exception.localCopy", new Object[]{this.getFilePath().getBody()}, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (listener == null) throw throwable;
                listener.taskFinished(task);
                throw throwable;
            }
        }
        {
            byte[] buf = new byte[8192];
            try {
                int nRead;
                while ((nRead = in.read(buf, 0, 8192)) > 0) {
                    out.write(buf, 0, nRead);
                    if (listener == null) continue;
                    task.setProgress(task.getProgress() + nRead);
                    listener.taskUpdated(task);
                }
            }
            catch (IOException e) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    out.close();
                    throw e;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (listener == null) return true;
            listener.taskFinished(task);
            return true;
        }
    }

    public void setTranscodeBog(boolean transcodeBog) {
        this.transcodeBog = transcodeBog;
    }
}

