/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.FilePathComparator;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public abstract class BDaemonFileSpace
extends BFileSpace {
    public static final Type TYPE = Sys.loadType(BDaemonFileSpace.class);
    protected FilePath sysHomePathFromRoot = null;
    protected FilePath userHomePathFromRoot = null;
    protected BDirectory[] roots = null;
    protected boolean initializing = false;

    public Type getType() {
        return TYPE;
    }

    public BDaemonFileSpace() {
        super("file", LexiconText.make((String)"platform", (String)"nav.daemonFileSpace"));
    }

    public abstract BDaemonSession getDaemonSession();

    public static boolean isAxDaemonFileSpace(BIFileSpace space) {
        return space instanceof BDaemonFileSpace && !((BDaemonFileSpace)space).getDaemonSession().getHostProperties().isNiagara4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws ConnectException, AuthenticationException {
        if (this.initializing || this.roots != null) {
            return;
        }
        this.initializing = true;
        try {
            BDaemonDirectoryStore rootStore;
            BDaemonDirectoryStore userHomeRootStore;
            ArrayList<BDirectory> rootsArray = new ArrayList<BDirectory>();
            String sysHomeLocalPath = null;
            String userHomeLocalPath = null;
            BDaemonDirectoryStore sysHomeRootStore = BDaemonDirectoryStore.make(this, new FilePath("!"));
            if (sysHomeRootStore != null) {
                sysHomeLocalPath = sysHomeRootStore.getLocalPath();
                BDirectory sysHomeRootDir = new BDirectory((BIFileStore)sysHomeRootStore, LexiconText.make((String)"platform", (String)"nav.sysHomeReadOnly"));
                sysHomeRootDir.setIcon(BIcon.std((String)"home.png"));
                rootsArray.add(sysHomeRootDir);
            }
            if ((userHomeRootStore = BDaemonDirectoryStore.make(this, new FilePath("~"))) != null) {
                userHomeLocalPath = userHomeRootStore.getLocalPath();
                if (this.getDaemonSession().getHostProperties().isNiagara4()) {
                    BDirectory userHomeRootDir = new BDirectory((BIFileStore)userHomeRootStore, LexiconText.make((String)"platform", (String)"nav.userHomeReadOnly"));
                    userHomeRootDir.setIcon(BIcon.std((String)"home.png"));
                    rootsArray.add(userHomeRootDir);
                }
            }
            if ((rootStore = BDaemonDirectoryStore.make(this, new FilePath("/"))) != null) {
                rootsArray.add(new BDirectory((BIFileStore)rootStore, LexiconText.make((String)"platform", (String)"nav.rootReadOnly")));
                String rootStoreLocalPath = rootStore.getLocalPath();
                if (sysHomeLocalPath != null && sysHomeLocalPath.startsWith(rootStoreLocalPath)) {
                    this.sysHomePathFromRoot = new FilePath(sysHomeLocalPath.substring(rootStoreLocalPath.length()));
                }
                if (userHomeLocalPath != null && userHomeLocalPath.startsWith(rootStoreLocalPath)) {
                    this.userHomePathFromRoot = new FilePath(userHomeLocalPath.substring(rootStoreLocalPath.length()));
                }
            }
            this.roots = rootsArray.toArray(new BDirectory[rootsArray.size()]);
        }
        finally {
            this.initializing = false;
        }
    }

    public String filePathToUri(FilePath path) {
        return this.toDaemonUriPath(path).getBody();
    }

    public FilePath toDaemonUriPath(FilePath path) {
        FilePath result;
        if (path.getScheme().equals("daemonuri")) {
            return path;
        }
        String[] names = path.getNames();
        int startIx = 0;
        if (path.isLocalAbsolute()) {
            if (names.length > 0 && names[0].equals("niagara")) {
                result = new FilePath("daemonuri", "/niagara");
                startIx = 1;
            } else if (names.length > 0 && names[0].equals("niagara_user")) {
                result = new FilePath("daemonuri", "/niagara_user");
                startIx = 1;
            } else {
                result = new FilePath("daemonuri", "/files");
            }
        } else if (path.isSysHomeAbsolute() || path.isUserHomeAbsolute()) {
            result = this.getDaemonSession().getHostProperties().isNiagara4() ? (path.isSysHomeAbsolute() ? new FilePath("daemonuri", "/niagara") : new FilePath("daemonuri", "/niagara_user")) : new FilePath("daemonuri", "/niagara");
        } else {
            throw new BajaRuntimeException("file path must be local absolute, sys home, or user home " + path.getBody());
        }
        for (int i = startIx; i < names.length; ++i) {
            result = result.merge(HttpUtil.encodeUrl((String)names[i]));
        }
        return result;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public String getNavDescription(Context cx) {
        return this.getLexicon().getText("DaemonFileSpace.navDesc");
    }

    public FilePath getAltPath(FilePath path) {
        if (this.initializing) {
            return null;
        }
        try {
            this.init();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        if (path.isLocalAbsolute()) {
            FilePath result = this.translateLocalAbsolute(path, this.sysHomePathFromRoot, 3);
            if (result == null) {
                result = this.translateLocalAbsolute(path, this.userHomePathFromRoot, 5);
            }
            return result;
        }
        if (path.isUserHomeAbsolute()) {
            if (this.userHomePathFromRoot == null) {
                return null;
            }
            FilePath result = new FilePath("/");
            result = result.merge(this.userHomePathFromRoot);
            for (int i = 0; i < path.depth(); ++i) {
                result = result.merge(path.nameAt(i));
            }
            return result;
        }
        if (path.isSysHomeAbsolute()) {
            if (this.sysHomePathFromRoot == null) {
                return null;
            }
            FilePath result = new FilePath("/");
            result = result.merge(this.sysHomePathFromRoot);
            for (int i = 0; i < path.depth(); ++i) {
                result = result.merge(path.nameAt(i));
            }
            return result;
        }
        return null;
    }

    private FilePath translateLocalAbsolute(FilePath sourcePath, FilePath targetPath, int targetPathAbsMode) {
        FilePath result;
        if (targetPath == null || sourcePath.depth() < targetPath.depth()) {
            return null;
        }
        for (int i = 0; i < targetPath.depth(); ++i) {
            if (sourcePath.nameAt(i).equals(targetPath.nameAt(i))) continue;
            return null;
        }
        if (targetPathAbsMode == 3) {
            result = new FilePath("!");
        } else if (targetPathAbsMode == 5) {
            result = new FilePath("~");
        } else {
            return null;
        }
        for (int i = targetPath.depth(); i < sourcePath.depth(); ++i) {
            result = result.merge(sourcePath.nameAt(i));
        }
        return result;
    }

    public BIFile[] listFiles() {
        try {
            this.init();
            return (BIFile[])this.roots.clone();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BIFile getChild(BIFile parent, String childName) {
        return this.getChild(parent, childName, BCacheAccessPolicy.forceFetch);
    }

    public BIFile[] getChildren(BIFile parent) {
        return this.getChildren(parent, BCacheAccessPolicy.forceFetch);
    }

    public BIFile findFile(FilePath path) {
        return this.findFile(path, BCacheAccessPolicy.forceFetch);
    }

    public BIFileStore findStore(FilePath path) {
        return this.findStore(path, BCacheAccessPolicy.forceFetch);
    }

    public abstract BIFile getChild(BIFile var1, String var2, BCacheAccessPolicy var3);

    public abstract BIFile[] getChildren(BIFile var1, BCacheAccessPolicy var2);

    public abstract BIFile findFile(FilePath var1, BCacheAccessPolicy var2);

    public abstract BIFileStore findStore(FilePath var1, BCacheAccessPolicy var2);

    public void notify(Set<FilePath> removed, Set<FilePath> transferred) {
        FileCache parentCache = new FileCache(this);
        TreeSet<NavEvent> events = new TreeSet<NavEvent>((o1, o2) -> {
            if (o1.getId() != o2.getId()) {
                return o1.getId() < o2.getId() ? 1 : -1;
            }
            int result = o1.getParentOrd().toString().compareTo(o2.getParentOrd().toString());
            if (result != 0) {
                return result;
            }
            if (o1.getId() == 1) {
                return o1.getNewChildName().compareTo(o2.getNewChildName());
            }
            return o1.getOldChildName().compareTo(o2.getOldChildName());
        });
        TreeSet<FilePath> allRemoved = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        allRemoved.addAll(removed);
        Iterator<Object> i = removed.iterator();
        while (i.hasNext()) {
            FilePath path = this.getAltPath(i.next());
            if (path == null) continue;
            allRemoved.add(path);
        }
        for (FilePath path : allRemoved) {
            BIFile existingKid;
            BDirectory bDirectory = this.findDirectoryForNotify(path.getParent(), parentCache);
            if (bDirectory == null || (existingKid = this.getChild((BIFile)bDirectory, path.getName(), BCacheAccessPolicy.cacheOnly)) == null) continue;
            events.add(NavEvent.makeRemoved((BOrd)bDirectory.getNavOrd(), (String)path.getName(), null));
        }
        TreeSet<FilePath> allTransferred = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        allTransferred.addAll(transferred);
        Iterator<FilePath> i2 = transferred.iterator();
        while (i2.hasNext()) {
            FilePath path = this.getAltPath(i2.next());
            if (path == null) continue;
            allTransferred.add(path);
        }
        block3: for (FilePath path : allTransferred) {
            BDirectory bDirectory = this.findDirectoryForNotify(path.getParent(), parentCache);
            if (bDirectory == null) {
                BIFile prior = (BIFile)this.getNavChild(path.getAbsoluteBase());
                if (prior == null) continue;
                for (int ixNode = 0; ixNode < path.depth() - 1; ++ixNode) {
                    BIFile current = this.getChild(prior, path.nameAt(ixNode), BCacheAccessPolicy.cacheOnly);
                    if (current == null) {
                        events.add(NavEvent.makeAdded((BOrd)prior.getNavOrd(), (String)path.nameAt(ixNode), null));
                        continue block3;
                    }
                    prior = current;
                }
                continue;
            }
            BIFile existingKid = this.getChild((BIFile)bDirectory, path.getName(), BCacheAccessPolicy.cacheOnly);
            if (existingKid == null) continue;
            events.add(NavEvent.makeAdded((BOrd)bDirectory.getNavOrd(), (String)path.getName(), null));
        }
        for (BDirectory bDirectory : parentCache.getCachedFiles()) {
            ((BDaemonDirectoryStore)bDirectory.getStore()).reset();
        }
        for (NavEvent evt : events) {
            BNavRoot.INSTANCE.fireNavEvent(evt);
        }
    }

    private BDirectory findDirectoryForNotify(FilePath path, FileCache cache) {
        if (path == null) {
            return null;
        }
        switch (cache.getCacheStatus(path)) {
            case 2: {
                BDirectory result = (BDirectory)this.findFile(path, BCacheAccessPolicy.cacheOnly);
                if (result == null) {
                    cache.cacheNotFound(path);
                } else {
                    cache.cacheResult((BIFile)result);
                }
                return result;
            }
            case 0: {
                return (BDirectory)cache.getFile(path);
            }
        }
        return null;
    }

    public void notifyTransferred(FilePath path) {
        TreeSet<FilePath> transferred = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        transferred.add(path);
        this.notify(new TreeSet<FilePath>(FilePathComparator.INSTANCE), transferred);
    }

    public void notifyRemoved(FilePath path) {
        TreeSet<FilePath> removed = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        removed.add(path);
        this.notify(removed, new TreeSet<FilePath>(FilePathComparator.INSTANCE));
    }
}

