/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.util.Arrays;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCachedDaemonFileSpace
extends BDaemonFileSpace
implements AutoCloseable {
    public static final Type TYPE = Sys.loadType(BCachedDaemonFileSpace.class);
    private BDaemonSession session;
    private boolean recurseDirs;
    private boolean getCrcs;
    private boolean getLocalPaths;
    private StoreCache cache;
    private ICancelHint cancelHint;
    private DaemonSessionTaskListener taskListener;
    private final DaemonClientEncodingInfo encodingInfo;
    private final AutoCloseable[] autoCloseables;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BCachedDaemonFileSpace make(BDaemonSession session, PBEEncodingKey encodingKey) throws IOException {
        return BCachedDaemonFileSpace.make(session, false, false, false, null, null, encodingKey, new AutoCloseable[0]);
    }

    public static BCachedDaemonFileSpace make(BDaemonSession session, boolean recurseDirs, boolean getCrcs, boolean getLocalPaths, ICancelHint cancelHint, DaemonSessionTaskListener taskListener, PBEEncodingKey encodingKey, AutoCloseable ... cascadeClose) throws IOException {
        DaemonClientEncodingInfo info = DaemonClientEncodingInfo.make(session, encodingKey);
        AutoCloseable[] toCascade = Arrays.copyOf(cascadeClose, cascadeClose.length + 1);
        toCascade[cascadeClose.length] = info;
        return new BCachedDaemonFileSpace(session, recurseDirs, getCrcs, getLocalPaths, cancelHint, taskListener, info, toCascade);
    }

    public BCachedDaemonFileSpace(BDaemonSession session, boolean recurseDirs, boolean getCrcs, boolean getLocalPaths, ICancelHint cancelHint, DaemonSessionTaskListener taskListener, DaemonClientEncodingInfo encodingInfo, AutoCloseable ... cascadeClose) {
        this.session = session;
        this.recurseDirs = recurseDirs;
        this.getCrcs = getCrcs;
        this.getLocalPaths = getLocalPaths;
        this.cache = new StoreCache();
        this.cancelHint = cancelHint;
        this.encodingInfo = encodingInfo;
        this.autoCloseables = cascadeClose;
        this.taskListener = taskListener == null && cancelHint != null && cancelHint instanceof DaemonSessionTaskListener ? (DaemonSessionTaskListener)((Object)cancelHint) : taskListener;
    }

    @Override
    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        int status = this.cache.getCacheStatus(path);
        if (status == 1) {
            return this.createDir(path, cx);
        }
        if (status == 0) {
            return new BDirectory(this.cache.getStore(path));
        }
        BDaemonDirectoryStore store = BDaemonDirectoryStore.make(this, path, this.recurseDirs, this.getCrcs, this.getLocalPaths, this.cache);
        if (store == null) {
            return this.createDir(path, cx);
        }
        return new BDirectory((BIFileStore)store);
    }

    private BDirectory createDir(FilePath path, Context cx) throws IOException {
        this.cache.clear(path);
        try {
            DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeMkDir(path, this), this.cancelHint, this.taskListener);
            BDaemonDirectoryStore store = BDaemonDirectoryStore.make(this, path, this.recurseDirs, this.getCrcs, this.getLocalPaths, this.cache);
            return store == null ? null : new BDirectory((BIFileStore)store);
        }
        catch (IOException | RuntimeException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void delete(FilePath path, Context cx) throws IOException {
        this.cache.clear(path);
        try {
            DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeDelete(path, this), this.cancelHint, this.taskListener);
        }
        catch (IOException | RuntimeException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public BIFile getChild(BIFile parent, String childName) {
        return this.getChild(parent, childName, BCacheAccessPolicy.lazyFetch);
    }

    @Override
    public BIFile[] getChildren(BIFile parent) {
        return this.getChildren(parent, BCacheAccessPolicy.lazyFetch);
    }

    @Override
    public BIFile findFile(FilePath path) {
        return this.findFile(path, BCacheAccessPolicy.lazyFetch);
    }

    @Override
    public BIFileStore findStore(FilePath path) {
        return this.findStore(path, BCacheAccessPolicy.lazyFetch);
    }

    @Override
    public BIFileStore findStore(FilePath path, BCacheAccessPolicy cachePolicy) {
        try {
            BAbstractFileStore store;
            int cacheStatus = cachePolicy == BCacheAccessPolicy.forceFetch ? 2 : this.cache.getCacheStatus(path);
            if (cacheStatus == 1) {
                return null;
            }
            if (cacheStatus == 0) {
                return this.cache.getStore(path);
            }
            if (cachePolicy == BCacheAccessPolicy.cacheOnly) {
                return null;
            }
            FileHeaderInfo header = DaemonFileUtil.getFileHeaderInfo(this.getDaemonSession(), new FileHeaderMessage(path, this));
            if (header == null) {
                if (this.cache != null) {
                    this.cache.cacheNotFound(path);
                }
                return null;
            }
            if (header.isDirectory()) {
                store = BDaemonDirectoryStore.make(this, path, this.recurseDirs, this.getCrcs, this.getLocalPaths, this.cache);
            } else if (path.depth() == 1 || !this.getCrcs) {
                store = new BDaemonFileStore(this, path, header.getContentLength(), -1L);
                if (this.cache != null) {
                    this.cache.cacheResult((BIFileStore)store);
                }
            } else {
                BDaemonDirectoryStore parentStore = BDaemonDirectoryStore.make(this, path.getParent(), this.recurseDirs, true, this.getLocalPaths, this.cache);
                if (parentStore == null) {
                    store = new BDaemonFileStore(this, path, header.getContentLength(), -1L);
                    if (this.cache != null) {
                        this.cache.cacheResult((BIFileStore)store);
                    }
                } else {
                    store = parentStore.getChild(path.getName());
                }
            }
            return store;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public BIFile getChild(BIFile parent, String childName, BCacheAccessPolicy cachePolicy) {
        if (parent.isDirectory()) {
            BDaemonDirectoryStore store = (BDaemonDirectoryStore)parent.getStore();
            BIFileStore childStore = store.getChild(childName, cachePolicy);
            return childStore == null ? null : this.makeFile(childStore);
        }
        return null;
    }

    @Override
    public BIFile[] getChildren(BIFile parent, BCacheAccessPolicy cachePolicy) {
        if (parent.isDirectory()) {
            BDaemonDirectoryStore store = (BDaemonDirectoryStore)parent.getStore();
            Array<BIFileStore> kids = store.getChildren(cachePolicy);
            BIFile[] result = new BIFile[kids.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.makeFile((BIFileStore)kids.get(i));
            }
            return result;
        }
        return null;
    }

    @Override
    public BIFile findFile(FilePath path, BCacheAccessPolicy cachePolicy) {
        try {
            BIFileStore store = this.findStore(path, cachePolicy);
            if (store == null) {
                return null;
            }
            if (store instanceof BDaemonDirectoryStore) {
                return new BDirectory(store);
            }
            return this.makeFile(store);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public StoreCache getCache() {
        return this.cache;
    }

    public DaemonClientEncodingInfo getEncodingInfo() {
        return this.encodingInfo;
    }

    public BOrd getOrdInSession() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        for (AutoCloseable autoCloseable : this.autoCloseables) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

