/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.authn.LoginFailureCause;
import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.crypto.core.exchange.IKeyExchanger;
import com.tridium.crypto.core.exchange.KeyExchange;
import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.GlibcSha256CryptAlgorithmBundle;
import com.tridium.nre.auth.GlibcSha512CryptAlgorithmBundle;
import com.tridium.nre.auth.QnxPlatformAlgorithmBundle;
import com.tridium.nre.auth.ScramAlgorithmBundle;
import com.tridium.nre.auth.ScramClient;
import com.tridium.nre.security.EncryptionAlgorithmBundle;
import com.tridium.nre.security.KeyDerivationAlgorithmBundle;
import com.tridium.nre.security.NullAlgorithmBundle;
import com.tridium.nre.security.SecretBytes;
import com.tridium.platform.daemon.Authenticator;
import java.io.IOException;
import java.security.AccessController;
import java.util.Base64;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.net.HttpConnection;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;

public class ScramAuthenticator
extends Authenticator {
    private static final String ACTION_SERVER_FIRST_SCRAM_MESSAGE = "sendServerFirstMessage";
    private static final String ACTION_SERVER_FINAL_SCRAM_MESSAGE = "sendServerFinalMessage";
    private static final String ACTION_SERVER_FIRST_SRP6_MESSAGE = "sendServerFirstSrp6Message";
    private static final String ACTION_SERVER_FINAL_SRP6_MESSAGE = "sendServerFinalSrp6Message";
    private static final String KEY_SERVER_FIRST_SCRAM_MESSAGE = "serverFirstMessage";
    private static final String KEY_SERVER_FINAL_SCRAM_MESSAGE = "serverFinalMessage";
    private static final String KEY_SERVER_FIRST_SRP6_MESSAGE = "keyExchangeServerB";
    private static final String KEY_SERVER_FINAL_SRP6_MESSAGE = "keyExchangeM2";
    private static final String ACTION_SERVER_AUTH_FAILED = "authenticationFailed";
    private static final String KEY_SERVER_AUTHN_FAILURE_CAUSE = "authnFailureCause";
    private Logger logger = Logger.getLogger("platform.keyExchange");
    private final String realm;
    private final String scramType;
    private ScramClient scramClient;
    private boolean finalAuthorizationSet = false;
    private String authenticationFailureMessage = null;
    IKeyExchanger keyExchangerClient;
    boolean doKeyExchange = false;
    KeyDerivationAlgorithmBundle keyDerivationAlgorithmBundle;
    EncryptionAlgorithmBundle encryptionAlgorithmBundle;

    public ScramAuthenticator(String realm, String scramType) {
        this.realm = realm;
        this.scramType = scramType.toUpperCase();
    }

    @Override
    public boolean setAuthorization(HttpConnection conn, String uri) throws IOException {
        return this.setAuthorization(conn, uri, null);
    }

    @Override
    public boolean setAuthorization(HttpConnection conn, String uri, Properties properties) throws IOException {
        String serverAction;
        if (this.getUserAndPwd() == null) {
            return false;
        }
        Properties wwwAuth = ScramAuthenticator.parseHeader(conn, "WWW-Authenticate");
        if (wwwAuth == null) {
            return true;
        }
        switch (serverAction = wwwAuth.getProperty("action", "")) {
            case "": {
                QnxPlatformAlgorithmBundle algorithmBundle;
                StringBuilder response = new StringBuilder();
                BUsernameAndPassword cred = this.getUserAndPwd();
                switch (this.scramType) {
                    case "SCRAM-SHA512": {
                        algorithmBundle = QnxPlatformAlgorithmBundle.getInstance();
                        break;
                    }
                    case "SCRAM-GLIBC-SHA256": {
                        algorithmBundle = GlibcSha256CryptAlgorithmBundle.getInstance();
                        break;
                    }
                    case "SCRAM-GLIBC-SHA512": {
                        algorithmBundle = GlibcSha512CryptAlgorithmBundle.getInstance();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown SCRAM type \"" + this.scramType + "\"");
                    }
                }
                this.scramClient = new ScramClient((ScramAlgorithmBundle)algorithmBundle, cred.getUsername(), AccessController.doPrivileged(() -> ((BPassword)cred.getPassword()).getValue()));
                String clientFirstMessage = this.scramClient.createClientFirstMessage();
                response.append(this.scramType).append(" ").append("action=sendClientFirstMessage ").append("clientFirstMessage=").append(clientFirstMessage);
                String clientKeyExchangeResponse = this.generateClientKeyExchangeResponse(wwwAuth);
                response.append(clientKeyExchangeResponse);
                conn.setRequestHeader("Authorization", response.toString());
                break;
            }
            case "sendServerFirstMessage": {
                String serverFirstMessage = wwwAuth.getProperty(KEY_SERVER_FIRST_SCRAM_MESSAGE);
                if (this.scramClient == null) {
                    throw new IllegalStateException("Attempting to do second step of " + this.scramType + " without data from first step.");
                }
                StringBuilder response = new StringBuilder();
                String clientFinalMessage = null;
                try {
                    clientFinalMessage = this.scramClient.createClientFinalMessage(serverFirstMessage);
                }
                catch (AssertionError e) {
                    this.authenticationFailureMessage = LoginFailureCause.FIPS_PASSWORD_LENGTH.getDefaultFailureMessage();
                    this.finalAuthorizationSet = true;
                    break;
                }
                String serverKeyExchangeConfirmation = wwwAuth.getProperty("keyExchangeConfirmation", "");
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Received server key exchange confirmation: " + serverKeyExchangeConfirmation);
                }
                switch (serverKeyExchangeConfirmation) {
                    case "srp6": {
                        this.doKeyExchange = true;
                        break;
                    }
                    case "none": {
                        this.doKeyExchange = false;
                        break;
                    }
                }
                response.append(this.scramType).append(" ").append("action=sendClientFinalMessage ").append("clientFinalMessage=").append(clientFinalMessage);
                conn.setRequestHeader("Authorization", response.toString());
                break;
            }
            case "sendServerFinalMessage": {
                String response;
                String serverFinalMessage = wwwAuth.getProperty(KEY_SERVER_FINAL_SCRAM_MESSAGE);
                if (this.scramClient == null) {
                    throw new IllegalStateException("Attempting to do second step of " + this.scramType + " without data from first step.");
                }
                byte[] A = null;
                if (this.doKeyExchange) {
                    this.logger.finer("Initializing key exchange client.");
                    this.keyExchangerClient = KeyExchange.makeClient((KeyDerivationAlgorithmBundle)this.keyDerivationAlgorithmBundle);
                    this.keyExchangerClient.init();
                    try (SecretBytes saltedPassword = this.scramClient.getSaltedPassword();){
                        this.logger.finer("Generating client first SRP message.");
                        A = this.keyExchangerClient.doInitialStep(saltedPassword);
                    }
                }
                this.scramClient.processServerFinalMessage(serverFinalMessage);
                if (this.doKeyExchange) {
                    response = this.scramType + " action=sendClientFirstSrp6Message keyExchangeClientA=" + Base64.getEncoder().encodeToString(A);
                } else {
                    response = this.scramType + " A-OK";
                    this.finalAuthorizationSet = true;
                }
                conn.setRequestHeader("Authorization", response);
                break;
            }
            case "sendServerFirstSrp6Message": {
                String serverFirstSrp6Message = wwwAuth.getProperty(KEY_SERVER_FIRST_SRP6_MESSAGE);
                byte[] B = Base64.getDecoder().decode(serverFirstSrp6Message);
                this.logger.finer("Generating client final SRP message.");
                byte[] M1 = this.keyExchangerClient.doExchangeStep(B);
                String response = this.scramType + " action=sendClientFinalSrp6Message keyExchangeM1=" + Base64.getEncoder().encodeToString(M1);
                conn.setRequestHeader("Authorization", response);
                break;
            }
            case "sendServerFinalSrp6Message": {
                String serverFinalSrp6Message = wwwAuth.getProperty(KEY_SERVER_FINAL_SRP6_MESSAGE);
                byte[] M2 = Base64.getDecoder().decode(serverFinalSrp6Message);
                this.keyExchangerClient.doExchangeStep(M2);
                String response = this.scramType + " A-OK";
                conn.setRequestHeader("Authorization", response);
                this.finalAuthorizationSet = true;
                break;
            }
            case "authenticationFailed": {
                this.authenticationFailureMessage = wwwAuth.getProperty(KEY_SERVER_AUTHN_FAILURE_CAUSE, null);
                if (this.authenticationFailureMessage != null) {
                    this.authenticationFailureMessage = HttpUtil.decodeUrl((String)this.authenticationFailureMessage);
                }
                this.finalAuthorizationSet = true;
            }
        }
        return true;
    }

    @Override
    public boolean finalAuthorizationSet() {
        return this.finalAuthorizationSet;
    }

    @Override
    public String getAuthenticationFailureMessage() {
        return this.authenticationFailureMessage;
    }

    public String getAuthenticationRealmName() {
        return this.realm;
    }

    public String getAuthenticationScheme() {
        return this.scramType;
    }

    @Override
    public boolean canReuseAuthorizationHeader() {
        return false;
    }

    protected void reset() {
        this.finalAuthorizationSet = false;
    }

    @Override
    public boolean supportsSecureKeyExchange() {
        return true;
    }

    @Override
    public boolean keyExchangeEnabled() {
        return this.doKeyExchange;
    }

    @Override
    protected byte[] extractSessionKey() {
        if (this.keyExchangerClient != null) {
            byte[] sessionKey = this.keyExchangerClient.getKey();
            this.keyExchangerClient = null;
            return sessionKey;
        }
        return null;
    }

    @Override
    protected EncryptionAlgorithmBundle getEncryptionAlgorithmBundle() {
        return this.encryptionAlgorithmBundle;
    }

    private String generateClientKeyExchangeResponse(Properties wwwAuth) {
        String[] methods;
        StringBuilder clientKeyExchangeResponse = new StringBuilder(" ");
        String serverKeyExchangeStatus = wwwAuth.getProperty("keyExchange", "none");
        String serverKeyExchangeMethods = wwwAuth.getProperty("keyExchangeMethods", null);
        String serverKeyExchangeCiphers = wwwAuth.getProperty("keyExchangeCiphers", null);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Received server key exchange request: keyExchange: " + serverKeyExchangeStatus + " " + "keyExchangeMethods" + ": " + serverKeyExchangeMethods + " " + "keyExchangeCiphers" + ": " + serverKeyExchangeCiphers);
        }
        switch (serverKeyExchangeStatus) {
            case "srp6": {
                clientKeyExchangeResponse.append("keyExchange").append("=").append("srp6");
                this.doKeyExchange = true;
                break;
            }
            case "nonePendingUser": {
                clientKeyExchangeResponse.append("keyExchange").append("=").append("nonePendingConfirmation");
                this.doKeyExchange = true;
                break;
            }
            case "none": {
                clientKeyExchangeResponse.append("keyExchange").append("=").append("none");
                this.doKeyExchange = false;
                break;
            }
            default: {
                this.doKeyExchange = false;
            }
        }
        for (String method : methods = serverKeyExchangeMethods.split(":")) {
            CryptographicAlgorithmBundle bundle = CryptographicAlgorithmBundle.getInstance((String)method);
            if (!(bundle instanceof KeyDerivationAlgorithmBundle)) continue;
            this.keyDerivationAlgorithmBundle = (KeyDerivationAlgorithmBundle)bundle;
            break;
        }
        if (serverKeyExchangeCiphers != null) {
            String[] ciphers;
            for (String cipher : ciphers = serverKeyExchangeCiphers.split(":")) {
                CryptographicAlgorithmBundle bundle = CryptographicAlgorithmBundle.getInstance((String)cipher);
                if (!(bundle instanceof EncryptionAlgorithmBundle)) continue;
                this.encryptionAlgorithmBundle = (EncryptionAlgorithmBundle)bundle;
                break;
            }
        }
        if (this.keyDerivationAlgorithmBundle != null && this.encryptionAlgorithmBundle != null) {
            String exchangeMethod = this.keyDerivationAlgorithmBundle.getAlgorithmName();
            clientKeyExchangeResponse.append(" ").append("keyExchangeMethod").append("=").append(exchangeMethod);
            clientKeyExchangeResponse.append(" ").append("keyExchangeCipher").append("=").append(this.encryptionAlgorithmBundle.getAlgorithmName());
        } else {
            clientKeyExchangeResponse.append(" ").append("keyExchangeMethod").append("=").append(NullAlgorithmBundle.getInstance().getAlgorithmName());
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Sent client key exchange response: " + clientKeyExchangeResponse);
        }
        return clientKeyExchangeResponse.toString();
    }
}

