/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.authn.AuthenticationClient;
import com.tridium.authn.SimpleAuthenticationClient;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticateUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.BasicNativeAuthMessageAX;
import com.tridium.platform.daemon.message.ChangePasswordMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.CheckDefaultCredentialsMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.FileDomainAuthMessage;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.UpdateNativeAuthenticationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.platform.DaemonSecurityManager;
import javax.baja.platform.security.BPlatformAccountChangeRequest;
import javax.baja.platform.security.BSystemPassphraseChangeRequest;
import javax.baja.platform.security.PlatformSecurityConfigManager;
import javax.baja.security.BAes256PasswordEncoder;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Localizable;
import javax.baja.sys.Sys;
import javax.baja.user.BPasswordStrength;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class PlatformSecurityManager
implements DaemonSecurityManager,
PlatformSecurityConfigManager {
    private BDaemonSession daemonSession;

    private PlatformSecurityManager(BDaemonSession session) {
        this.daemonSession = session;
    }

    public static PlatformSecurityManager make(BDaemonSession session) {
        return new PlatformSecurityManager(session);
    }

    @Override
    public boolean isAuthenticationReadonly() {
        boolean authReadonly = false;
        try {
            XElem authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null) {
                authReadonly = authElem.getb("readonly", false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return authReadonly;
    }

    @Override
    public boolean isSingleUserAuthorizationSupported() throws Exception {
        return !this.daemonSession.getHostProperties().isNiagara4();
    }

    @Override
    public void useSingleAdminAccount(String adminUser, char[] adminPassword) throws Exception {
        if (!this.isSingleUserAuthorizationSupported()) {
            throw new UnsupportedOperationException("useSingleAdminAccount is unsupported for this host");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("authentication settings are readonly for this host");
        }
        this.validatePassword(adminPassword, this.daemonSession.getPlatformPasswordStrengthRequirements());
        String factoryUser = "tridium";
        try {
            XElem authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new AuthenticationInfoMessage(), "text/xml")).parse();
            XElem authElem = authInfoElem.elem("auth");
            Objects.requireNonNull(authElem);
            if (authElem.get("type").equals("digest/file")) {
                XElem userElem = authElem.elem("user");
                Objects.requireNonNull(userElem);
                if (userElem.getb("default", false)) {
                    factoryUser = userElem.get("name");
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        if (adminUser.equals(factoryUser)) {
            throw new IllegalArgumentException("Cannot use factory user name");
        }
        FileDomainAuthMessage msg = new FileDomainAuthMessage(adminUser, adminPassword, "digest/file");
        if (!this.daemonSession.sendMessage(msg)) {
            throw new RuntimeException(msg.getErrorMessage());
        }
        this.daemonSession.setCredentials((BICredentials)new BUsernameAndPassword(adminUser, BPassword.make((char[])adminPassword)), true);
        this.daemonSession.connect();
    }

    @Override
    public boolean isOsGroupAuthorizationSupported() throws Exception {
        XElem authElem;
        try {
            XElem authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new AuthenticationInfoMessage(), "text/xml")).parse();
            authElem = authInfoElem.elem("auth");
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Objects.requireNonNull(authElem);
        HashSet<String> authTypesSupported = new HashSet<String>();
        String authTypesSupportedCSV = authElem.get("authTypesSupported", null);
        if (authTypesSupportedCSV == null) {
            authTypesSupported.add("digest/file");
            boolean nativeAuthSupport = false;
            try {
                boolean nativeAuthSupportedDefault = this.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win");
                nativeAuthSupport = authElem.getb("nativeAuthSupported", nativeAuthSupportedDefault);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nativeAuthSupport) {
                authTypesSupported.add("basic/native");
            }
        } else {
            Collections.addAll(authTypesSupported, authTypesSupportedCSV.split(","));
        }
        if (this.daemonSession.getHostProperties().isNiagara4()) {
            boolean supportsNative = false;
            for (String supportedAuthType : authTypesSupported) {
                if (!DaemonAuthUtil.isNativeScheme((String)supportedAuthType)) continue;
                supportsNative = true;
                break;
            }
            return supportsNative && !this.daemonSession.getHostProperties().supportsServlet("acctmgt");
        }
        return authTypesSupported.contains("basic/native");
    }

    @Override
    public void useAdminGroup(String adminGroupName) throws Exception {
        if (!this.isOsGroupAuthorizationSupported()) {
            throw new UnsupportedOperationException("useAdminGroup is unsupported for this host");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("authentication settings are readonly for this host");
        }
        this.useOsGroups(null, adminGroupName);
    }

    @Override
    public void useOsGroups(String userGroupName, String adminGroupName) throws Exception {
        XElem authElem;
        XElem authInfoElem;
        if (!this.isOsGroupAuthorizationSupported()) {
            throw new UnsupportedOperationException("useOsGroups is unsupported for this host");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("authentication settings are readonly for this host");
        }
        Objects.requireNonNull(adminGroupName);
        try {
            authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new AuthenticationInfoMessage(), "text/xml")).parse();
            authElem = authInfoElem.elem("auth");
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        XmlResponseMessage msg = null;
        Objects.requireNonNull(authElem);
        GroupAccount adminGroup = new GroupAccount(adminGroupName, null);
        if (this.daemonSession.getHostProperties().isNiagara4()) {
            HashSet authTypesSupported = new HashSet();
            String authTypesSupportedCSV = authElem.get("authTypesSupported", null);
            Objects.requireNonNull(authTypesSupportedCSV);
            Collections.addAll(authTypesSupported, authTypesSupportedCSV.split(","));
            String nativeAuthType = null;
            for (String authTypeSupported : authTypesSupported) {
                if (!DaemonAuthUtil.isNativeScheme((String)authTypeSupported)) continue;
                nativeAuthType = authTypeSupported;
                break;
            }
            Objects.requireNonNull(nativeAuthType);
            block4: for (XElem authDomainElem : authInfoElem.elems("domain")) {
                for (XElem domainGroupElem : authDomainElem.elems("group")) {
                    GroupAccount domainGroupAccount = new GroupAccount(domainGroupElem.get("name"), domainGroupElem.get("id"));
                    if (!adminGroup.getFullyQualifiedName().equals(domainGroupAccount.getFullyQualifiedName())) continue;
                    msg = new UpdateNativeAuthenticationMessage(nativeAuthType, (NativeAccount)domainGroupAccount);
                    continue block4;
                }
            }
            if (msg == null) {
                throw new IllegalArgumentException("admin group does not exist");
            }
        } else {
            Objects.requireNonNull(userGroupName);
            GroupAccount userGroup = new GroupAccount(userGroupName, null);
            msg = new BasicNativeAuthMessageAX(userGroup, adminGroup);
        }
        BICredentials credentialsToRestore = this.daemonSession.getCredentials();
        if (!this.daemonSession.sendMessage(msg)) {
            throw new RuntimeException(msg.getErrorMessage());
        }
        this.daemonSession.setCredentials(credentialsToRestore, true);
        this.daemonSession.connect();
    }

    @Override
    public boolean supportsPlatformAccountManagement() throws Exception {
        return this.daemonSession.getHostProperties().isNiagara4() && this.daemonSession.getHostProperties().supportsServlet("acctmgt");
    }

    @Override
    public void addPlatformUser(String userName, char[] password) throws Exception {
        XElem authElem;
        if (!this.supportsPlatformAccountManagement()) {
            throw new UnsupportedOperationException("addPlatformUser is unsupported for this host");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("authentication settings are readonly for this host");
        }
        Objects.requireNonNull(userName);
        this.validatePassword(password, this.daemonSession.getPlatformPasswordStrengthRequirements());
        try {
            XElem authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream(new AuthenticationInfoMessage())).parse();
            authElem = authInfoElem.elem("auth");
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Objects.requireNonNull(authElem);
        XElem adminGroupElem = authElem.elem("admingroup");
        XElem userElem = authElem.elem("user");
        XElem defaultLocalElem = authElem.elem("defaultlocal");
        Objects.requireNonNull(adminGroupElem);
        Objects.requireNonNull(userElem);
        Objects.requireNonNull(defaultLocalElem);
        UserAccount userToAdd = new UserAccount(this.makeFullyQualifiedUserName(userName, defaultLocalElem.get("realm")), null, "", LegacyStorageUtil.encode((char[])password, (int)0));
        if (NativeAccount.isReservedName((String)userToAdd.getAccountName()) || userToAdd.getAccountName().contains("suNkiNg")) {
            throw new IllegalArgumentException(String.format("Cannot add user, %s is a reserved name", userName));
        }
        if (userToAdd.getAccountName().equals(userElem.get("name", "tridium"))) {
            throw new IllegalArgumentException("Cannot add user with factory default username");
        }
        GroupAccount adminGroupAccount = new GroupAccount(adminGroupElem.get("name"), adminGroupElem.get("id"));
        UserAccount defaultAccountToDelete = null;
        try {
            XElem accountInfo = XParser.make((InputStream)this.daemonSession.getInputStream(new AccountManagementMessage())).parse();
            for (XElem group : accountInfo.elems("group")) {
                if (!group.get("id").equals(adminGroupAccount.getPlatformIdentifier())) continue;
                for (XElem user : group.elems("user")) {
                    UserAccount existingUser = new UserAccount(user.get("name"), user.get("id", null));
                    if (existingUser.getAccountName().equals(userElem.get("name"))) {
                        defaultAccountToDelete = existingUser;
                    }
                    if (!existingUser.getAccountName().equals(userToAdd.getAccountName())) continue;
                    throw new IllegalArgumentException("can not add requested user, user already exists");
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        AtomicReference errorRef = new AtomicReference();
        try (SharedSecretKey sharedSecretKey = this.daemonSession.generateSharedSecretKey("addPlatformUser");){
            AddUserMessage addUserMessage = new AddUserMessage(userToAdd);
            addUserMessage.setSharedKey(sharedSecretKey);
            if (!this.daemonSession.sendMessage(errorRef::set, addUserMessage)) {
                throw new BajaRuntimeException("Add user message failed " + ((Localizable)errorRef.get()).toString(null));
            }
            userToAdd.setPlatformIdentifier(addUserMessage.getResponse().get("id", null));
            AddMemberMessage addMemberMessage = new AddMemberMessage(adminGroupAccount, userToAdd);
            if (!this.daemonSession.sendMessage(errorRef::set, addMemberMessage)) {
                throw new BajaRuntimeException("Add member message failed " + ((Localizable)errorRef.get()).toString(null));
            }
            if (defaultAccountToDelete != null) {
                this.daemonSession.setCredentials((BICredentials)new BUsernameAndPassword(userToAdd.getAccountName(), BPassword.make((char[])password)), true);
                this.daemonSession.connect();
                this.daemonSession.reloadHostProperties();
                if (!this.daemonSession.sendMessage(errorRef::set, new DeleteMemberMessage(adminGroupAccount, defaultAccountToDelete))) {
                    throw new BajaRuntimeException("Delete member message failed " + ((Localizable)errorRef.get()).toString(null));
                }
                if (!this.daemonSession.sendMessage(errorRef::set, new DeleteUserMessage(defaultAccountToDelete))) {
                    throw new BajaRuntimeException("Delete user message failed " + ((Localizable)errorRef.get()).toString(null));
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void updatePlatformUserPassword(String userName, char[] oldPassword, char[] newPassword) throws Exception {
        XElem authElem;
        if (!this.supportsPlatformAccountManagement()) {
            throw new UnsupportedOperationException("updatePlatformUserPassword is unsupported for this host");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("authentication settings are readonly for this host");
        }
        Objects.requireNonNull(userName);
        Objects.requireNonNull(oldPassword);
        this.validatePassword(newPassword, this.daemonSession.getPlatformPasswordStrengthRequirements());
        if (SecurityUtil.equals((char[])oldPassword, (char[])newPassword)) {
            throw new IllegalArgumentException("Passwords are not different");
        }
        try {
            XElem authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream(new AuthenticationInfoMessage())).parse();
            authElem = authInfoElem.elem("auth");
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Objects.requireNonNull(authElem);
        XElem defaultLocalElem = authElem.elem("defaultlocal");
        Objects.requireNonNull(defaultLocalElem);
        boolean isCurrentUser = false;
        boolean userNameIsQualified = NativeAccount.isAccountNameFullyQualified((String)userName);
        UserAccount userToUpdate = null;
        try {
            XElem accountInfo = XParser.make((InputStream)this.daemonSession.getInputStream(new AccountManagementMessage())).parse();
            block18: for (XElem group : accountInfo.elems("group")) {
                for (XElem user : group.elems("user")) {
                    UserAccount existingUser = new UserAccount(user.get("name"), user.get("id", null), user.get("description", null), null);
                    if ((!userNameIsQualified || !userName.equals(existingUser.getFullyQualifiedName())) && (userNameIsQualified || !userName.equals(existingUser.getAccountName()))) continue;
                    if (user.get("canModify", "false").equals("false")) {
                        throw new IllegalArgumentException(String.format("user %s cannot be modified", userName));
                    }
                    userToUpdate = existingUser;
                    userToUpdate.setPassword(LegacyStorageUtil.encode((String)new String(newPassword), (int)0));
                    userToUpdate.setOldPassword(LegacyStorageUtil.encode((String)new String(oldPassword), (int)0));
                    isCurrentUser = userToUpdate.getAccountName().equals(NativeAccount.fullyQualifiedToUsername((String)((BUsernameAndPassword)this.daemonSession.getCredentials()).getUsername()));
                    continue block18;
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        if (userToUpdate == null) {
            throw new IllegalArgumentException(String.format("user %s does not exist", userName));
        }
        try {
            SharedSecretKey sharedKey = this.daemonSession.generateSharedSecretKey("updatePlatformUserPassword");
            Object object = null;
            try {
                AtomicReference errorRef = new AtomicReference();
                if (!this.daemonSession.sendMessage(errorRef::set, new AuthenticateUserMessage(userToUpdate.getFullyQualifiedName(), BPassword.make((char[])oldPassword), sharedKey))) {
                    throw new IllegalArgumentException("Invalid account name or old password");
                }
                ChangePasswordMessage changePasswordMessage = new ChangePasswordMessage(userToUpdate, userToUpdate.getOldPassword(), userToUpdate.getPassword(), isCurrentUser);
                changePasswordMessage.setSharedKey(sharedKey);
                if (!this.daemonSession.sendMessage(errorRef::set, changePasswordMessage)) {
                    throw new BajaRuntimeException(((Localizable)errorRef.get()).toString(null));
                }
                if (isCurrentUser) {
                    this.daemonSession.setCredentials((BICredentials)new BUsernameAndPassword(userToUpdate.getAccountName(), BPassword.make((char[])newPassword)), true);
                    this.daemonSession.connect();
                    this.daemonSession.reloadHostProperties();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (sharedKey != null) {
                    if (object != null) {
                        try {
                            sharedKey.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        sharedKey.close();
                    }
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void removePlatformUser(String userName) throws Exception {
        XElem authElem;
        if (!this.supportsPlatformAccountManagement()) {
            throw new UnsupportedOperationException("updatePlatformUserPassword is unsupported for this host");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("authentication settings are readonly for this host");
        }
        Objects.requireNonNull(userName);
        try {
            XElem authInfoElem = XParser.make((InputStream)this.daemonSession.getInputStream(new AuthenticationInfoMessage())).parse();
            authElem = authInfoElem.elem("auth");
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Objects.requireNonNull(authElem);
        XElem adminGroupElem = authElem.elem("admingroup");
        Objects.requireNonNull(adminGroupElem);
        GroupAccount adminGroupAccount = new GroupAccount(adminGroupElem.get("name"), adminGroupElem.get("id"));
        boolean userNameIsQualified = NativeAccount.isAccountNameFullyQualified((String)userName);
        UserAccount userToDelete = null;
        try {
            XElem accountInfo = XParser.make((InputStream)this.daemonSession.getInputStream(new AccountManagementMessage())).parse();
            block6: for (XElem group : accountInfo.elems("group")) {
                for (XElem user : group.elems("user")) {
                    UserAccount existingUser = new UserAccount(user.get("name"), user.get("id", null), user.get("description", null), null);
                    if ((!userNameIsQualified || !userName.equals(existingUser.getFullyQualifiedName())) && (userNameIsQualified || !userName.equals(existingUser.getAccountName()))) continue;
                    if (user.get("canModify", "false").equals("false")) {
                        throw new IllegalArgumentException(String.format("user %s cannot be modified", userName));
                    }
                    userToDelete = existingUser;
                    if (!userToDelete.getAccountName().equals(NativeAccount.fullyQualifiedToUsername((String)((BUsernameAndPassword)this.daemonSession.getCredentials()).getUsername()))) continue block6;
                    throw new IllegalArgumentException("cannot delete the account used to connect to the daemon");
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        if (userToDelete == null) {
            throw new IllegalArgumentException(String.format("user %s not found", userName));
        }
        AtomicReference errorRef = new AtomicReference();
        if (!this.daemonSession.sendMessage(errorRef::set, new DeleteMemberMessage(adminGroupAccount, userToDelete))) {
            throw new BajaRuntimeException(String.format("user %s not deleted - %s", userName, ((Localizable)errorRef.get()).toString(null)));
        }
        if (!this.daemonSession.sendMessage(errorRef::set, new DeleteUserMessage(userToDelete))) {
            throw new BajaRuntimeException(String.format("user %s not deleted - %s", userName, ((Localizable)errorRef.get()).toString(null)));
        }
    }

    @Override
    public boolean isSystemPassphraseReadonly() {
        boolean systemPassphraseReadonly = false;
        try {
            XElem systemPassphraseElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
            systemPassphraseReadonly = systemPassphraseElem.getb("readonly", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return systemPassphraseReadonly;
    }

    @Override
    public void updateSystemPassphrase(char[] currentPassphrase, char[] newPassphrase) throws Exception {
        if (this.daemonSession.getHostProperties().isNiagara4()) {
            if (!this.daemonSession.getHostProperties().supportsServlet("systempw")) {
                throw new UnsupportedOperationException("updateSystemPassphrase is unsupported for this host");
            }
        } else {
            throw new UnsupportedOperationException("updateSystemPassphrase is unsupported for this host");
        }
        if (this.isSystemPassphraseReadonly()) {
            throw new UnsupportedOperationException("System passphrase is readonly for this host");
        }
        Objects.requireNonNull(currentPassphrase);
        this.validatePassword(newPassphrase, this.daemonSession.getPlatformPasswordStrengthRequirements());
        if (SecurityUtil.equals((char[])currentPassphrase, (char[])newPassphrase)) {
            throw new IllegalArgumentException("Passphrase values are not different");
        }
        try (SharedSecretKey sharedSecretKey = this.daemonSession.generateSharedSecretKey("updateSystemPassphrase");){
            AtomicReference errorRef = new AtomicReference();
            if (!this.daemonSession.sendMessage(errorRef::set, new SystemPasswordMessage(BPassword.make((char[])newPassphrase, (String)BAes256PasswordEncoder.ENCODING_TYPE), BPassword.make((char[])currentPassphrase, (String)BAes256PasswordEncoder.ENCODING_TYPE), true, sharedSecretKey))) {
                throw new BajaRuntimeException(((Localizable)errorRef.get()).toString(null));
            }
            if (!this.daemonSession.sendMessage(errorRef::set, new SystemPasswordMessage(BPassword.make((char[])newPassphrase, (String)BAes256PasswordEncoder.ENCODING_TYPE), BPassword.make((char[])currentPassphrase, (String)BAes256PasswordEncoder.ENCODING_TYPE), false, sharedSecretKey))) {
                throw new BajaRuntimeException(((Localizable)errorRef.get()).toString(null));
            }
        }
    }

    @Override
    public String[] listPlatformUsers() {
        try {
            if (!this.supportsPlatformAccountManagement()) {
                throw new UnsupportedOperationException();
            }
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("listPlatformUsers is unsupported for this platform");
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            XElem accountInfo = XParser.make((InputStream)this.daemonSession.getInputStream(new AccountManagementMessage())).parse();
            for (XElem group : accountInfo.elems("group")) {
                for (XElem user : group.elems("user")) {
                    result.add(user.get("name"));
                }
            }
        }
        catch (RuntimeException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return result.toArray(new String[result.size()]);
    }

    private void validatePassword(char[] password, PasswordStrength passwordStrength) throws IllegalArgumentException {
        AtomicReference messageRef = new AtomicReference();
        if (!PlatformSecurityManager.isValidPlatformPassword(password, passwordStrength, messageRef::set)) {
            throw new IllegalArgumentException(((Localizable)messageRef.get()).toString(null));
        }
    }

    public static boolean isValidPlatformPassword(char[] password, PasswordStrength passwordStrength, Consumer<Localizable> messageConsumer) {
        if (messageConsumer == null) {
            messageConsumer = localizable -> {};
        }
        if (password == null) {
            messageConsumer.accept(context -> "Password cannot be null");
            return false;
        }
        for (char c : password) {
            if (c >= '!' && c <= '~') continue;
            messageConsumer.accept(context -> String.format("Invalid password character \"%c\"", Character.valueOf(c)));
            return false;
        }
        if (password.length > 64) {
            messageConsumer.accept(context -> "Password can not exceed 64 characters");
            return false;
        }
        return new BPasswordStrength(passwordStrength).isPasswordValid(password, messageConsumer);
    }

    private String makeFullyQualifiedUserName(String accountName, String defaultRealm) {
        Objects.requireNonNull(accountName);
        Objects.requireNonNull(defaultRealm);
        return NativeAccount.isAccountNameFullyQualified((String)accountName) ? accountName : defaultRealm + "\\" + accountName;
    }

    @Override
    public boolean isPlatformAccountValid() {
        if (!LocalSessionUtil.localDaemonIsAvailable() || this.daemonSession != LocalSessionUtil.getLocalSession()) {
            throw new UnsupportedOperationException("Platform account validation only available for local DaemonSession instance");
        }
        return !this.defaultPlatformAccountExists();
    }

    @Override
    public void replacePlatformAccount(BPlatformAccountChangeRequest platformAccountData) throws BajaRuntimeException {
        if (!LocalSessionUtil.localDaemonIsAvailable() || this.daemonSession != LocalSessionUtil.getLocalSession()) {
            throw new UnsupportedOperationException("Platform account replacement only available for local DaemonSession instance");
        }
        if (this.isAuthenticationReadonly()) {
            throw new UnsupportedOperationException("Platform Authentication Settings Readonly");
        }
        try {
            if (platformAccountData == null) {
                throw new BajaRuntimeException("Platform Account Data Missing");
            }
            if (platformAccountData.getAuthenticationUsername() == null || platformAccountData.getAuthenticationPassphrase() == null || platformAccountData.getNewUsername() == null || platformAccountData.getNewUserPassword() == null) {
                throw new BajaRuntimeException("Platform Account Data Incomplete");
            }
            IPlatformProvider platform = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);
            if (!platform.providesAccountManagement()) {
                throw new BajaRuntimeException("Platform Does Not Provide Account Management");
            }
            if (!this.localAccountExists(new BUsernameAndPassword(platformAccountData.getAuthenticationUsername(), AccessController.doPrivileged(() -> ((BPassword)platformAccountData.getAuthenticationPassphrase()).getValue())))) {
                throw new BajaRuntimeException("Platform Authentication Account Not Found");
            }
            String oldAccountId = platform.getIdFromName(platformAccountData.getAuthenticationUsername(), true);
            if (!PlatformSecurityManager.isPasswordValid(platformAccountData.getNewUserPassword(), new BPasswordStrength(this.daemonSession.getPlatformPasswordStrengthRequirements()))) {
                throw new BajaRuntimeException("New Platform Account Password Invalid");
            }
            if (!PlatformSecurityManager.isCommentValid(platformAccountData.getNewComment())) {
                throw new BajaRuntimeException("New Platform Account Comment Invalid");
            }
            if (platformAccountData.getNewUsername().length() == 0 || NativeAccount.isReservedName((String)platformAccountData.getNewUsername()) || platformAccountData.getNewUsername().contains("suNkiNg")) {
                throw new BajaRuntimeException("Invalid New Platform Account Name \"" + platformAccountData.getNewUsername() + "\"");
            }
            if (platformAccountData.getNewUsername().equals(platform.getDefaultUsername())) {
                throw new BajaRuntimeException("Invalid New Platform Account Name, Matches Factory Default");
            }
            if (SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)platformAccountData.getNewUserPassword()).getValue()), (String)platform.getDefaultPassword())) {
                throw new BajaRuntimeException("Invalid New Platform Account Password, Matches Factory Default");
            }
            String adminGroupId = platform.getDefaultAdminGroup().getPlatformIdentifier();
            boolean success = false;
            String newUserId = platform.addUserAccount(platformAccountData.getNewUsername(), AccessController.doPrivileged(() -> ((BPassword)platformAccountData.getNewUserPassword()).getValue()), platformAccountData.getNewComment(), false);
            if (newUserId != null && platform.addUserToGroup(newUserId, adminGroupId) && platform.removeUserFromGroup(oldAccountId, adminGroupId) && platform.removeUserAccount(oldAccountId)) {
                success = true;
            }
            if (!success) {
                throw new BajaRuntimeException("Platform Account replacement Failed");
            }
        }
        catch (BajaRuntimeException b) {
            throw b;
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to replace Platform Account.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSystemPassphraseValid() {
        if (!LocalSessionUtil.localDaemonIsAvailable()) throw new UnsupportedOperationException("System Passphrase validation only available for local DaemonSession instance");
        if (this.daemonSession != LocalSessionUtil.getLocalSession()) {
            throw new UnsupportedOperationException("System Passphrase validation only available for local DaemonSession instance");
        }
        try {
            IPlatformProvider platform = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);
            try (SecretChars defaultPassphrase = SecretChars.fromString((String)platform.getDefaultPassword());
                 SecretChars currentPassphrase = AccessController.doPrivileged(() -> ((IPlatformProvider)platform).getSystemPassword());){
                if (!SecurityUtil.equals((char[])defaultPassphrase.get(), (char[])currentPassphrase.get())) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to validate system passphrase", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemPassphrase(BSystemPassphraseChangeRequest systemPassphraseChangeRequest) {
        if (!LocalSessionUtil.localDaemonIsAvailable() || this.daemonSession != LocalSessionUtil.getLocalSession()) {
            throw new UnsupportedOperationException("System passphrase replacement only available for local DaemonSession instance");
        }
        if (this.isSystemPassphraseReadonly()) {
            throw new UnsupportedOperationException("System passphrase is readonly for this host");
        }
        try {
            boolean success;
            block24: {
                if (systemPassphraseChangeRequest == null) {
                    throw new SecurityException("System Passphrase Data Missing.");
                }
                if (systemPassphraseChangeRequest.getAuthenticationUsername() == null || systemPassphraseChangeRequest.getAuthenticationPassphrase() == null || systemPassphraseChangeRequest.getCurrentSystemPassphrase() == null || systemPassphraseChangeRequest.getNewPassphrase() == null) {
                    throw new SecurityException("System Passphrase Data Incomplete.");
                }
                BUsernameAndPassword daemonCredentials = new BUsernameAndPassword(systemPassphraseChangeRequest.getAuthenticationUsername(), AccessController.doPrivileged(() -> ((BPassword)systemPassphraseChangeRequest.getAuthenticationPassphrase()).getValue()));
                if (!PlatformSecurityManager.isPasswordValid(systemPassphraseChangeRequest.getNewPassphrase(), new BPasswordStrength(this.daemonSession.getPlatformPasswordStrengthRequirements()))) {
                    throw new SecurityException("New System Passphrase Invalid");
                }
                BDaemonSession session = null;
                success = false;
                try {
                    if (!this.localAccountExists(daemonCredentials)) {
                        throw new SecurityException("System Passphrase Authorization Account Not Found");
                    }
                    session = PlatformSecurityManager.createSession(daemonCredentials);
                    if (session != null && session.isConnected()) {
                        if (!session.getHostProperties().isNiagara4()) {
                            throw new UnsupportedOperationException("System Passphrase is unsupported for Niagara AX hosts");
                        }
                        session.sendMessage(new SystemPasswordMessage(systemPassphraseChangeRequest.getNewPassphrase(), systemPassphraseChangeRequest.getCurrentSystemPassphrase(), false, session.generateSharedSecretKey("updateSystemPassword")));
                        success = true;
                        break block24;
                    }
                    throw new SecurityException("System Passphrase Authorization Account Not Found");
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (session != null) {
                            session.disconnect();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (!success) {
                throw new SecurityException("System Passphrase Reset Failed");
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to set Platform Passphrase.");
        }
    }

    private static boolean isCommentValid(String comment) {
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (!"-=+()@._ ".contains(String.valueOf(c)) && !Character.isLetterOrDigit(c)) {
                return false;
            }
            if (i < 64) continue;
            return false;
        }
        return true;
    }

    private static boolean isPasswordValid(BPassword password, BPasswordStrength desiredStrength) {
        char[] passwordChars;
        if (password == null) {
            return false;
        }
        if (AccessController.doPrivileged(() -> ((BPassword)password).getValue()).length() < 1) {
            return false;
        }
        for (char passwordChar : passwordChars = AccessController.doPrivileged(() -> ((BPassword)password).getValue()).toCharArray()) {
            if (passwordChar >= '!' && passwordChar <= '~') continue;
            return false;
        }
        if (passwordChars.length > 64) {
            return false;
        }
        if (desiredStrength != null) {
            try {
                desiredStrength.isPasswordValid(AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
            }
            catch (Exception strengthException) {
                return false;
            }
        }
        return true;
    }

    private boolean defaultPlatformAccountExists() {
        boolean factoryDefaultCredentials;
        try {
            XElem userElem;
            boolean tempDefaultCredentials = false;
            XElem authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new CheckDefaultCredentialsMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null && (userElem = authElem.elem("user")) != null) {
                tempDefaultCredentials = userElem.getb("default", false);
            }
            factoryDefaultCredentials = tempDefaultCredentials;
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to validate platform account", (Throwable)e);
        }
        return factoryDefaultCredentials;
    }

    private static BDaemonSession createSession(BUsernameAndPassword daemonCredentials) {
        BDaemonSession session;
        try {
            BDaemonSession localSession = LocalSessionUtil.getLocalSession();
            session = BDaemonSession.makeIgnoringCache((BHost)new BIpHost(Sys.getLocalHost(null).getHostAddress()), localSession.getPort());
            session.setCredentials((BICredentials)daemonCredentials, true);
            session.setAuthenticationClient((AuthenticationClient)new SimpleAuthenticationClient(daemonCredentials));
            session.connect();
            session.sendMessage(new InitializeSessionMessage());
        }
        catch (Exception e) {
            return null;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean localAccountExists(BUsernameAndPassword daemonCredentials) {
        BDaemonSession session = null;
        try {
            BDaemonSession localSession = LocalSessionUtil.getLocalSession();
            session = BDaemonSession.makeIgnoringCache((BHost)new BIpHost(Sys.getLocalHost(null).getHostAddress()), localSession.getPort());
            session.setCredentials((BICredentials)daemonCredentials, true);
            session.setAuthenticationClient((AuthenticationClient)new SimpleAuthenticationClient(daemonCredentials));
            session.connect();
            session.sendMessage(new InitializeSessionMessage());
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }
}

